/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CScale;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scale;

class CScaleImplementation
extends JSlider
implements CScale {
    protected Scale handle;
    protected CControl.UserAttributeHandler userAttributeHandler;

    public Container getSwingComponent() {
        return this;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CScaleImplementation(Scale scale, int n2) {
        this.handle = scale;
        this.userAttributeHandler = new CControl.UserAttributeHandler(this);
        this.init(n2);
    }

    protected void init(int n2) {
        this.setMaximum(100);
        this.setMinorTickSpacing(1);
        this.setMajorTickSpacing(10);
        this.setPaintTicks(true);
        this.setSnapToTicks(true);
        this.setValue(0);
        this.setOrientation((n2 & 0x100) != 0 ? 0 : 1);
        if ((n2 & 0x800) != 0) {
            this.setBorder(LookAndFeelUtils.getStandardBorder());
        }
        Utils.installMouseListener(this, this.handle);
        Utils.installKeyListener(this, this.handle);
        Utils.installFocusListener(this, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e2) {
                CScaleImplementation.this.handle.processEvent(e2);
            }
        });
    }

    public Container getClientArea() {
        return this;
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            return this.getOrientation() == 0 ? new Dimension(170, super.getPreferredSize().height) : new Dimension(super.getPreferredSize().width, 170);
        }
        return super.getPreferredSize();
    }

    public Color getBackground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.background != null ? this.userAttributeHandler.background : super.getBackground();
    }

    public Color getForeground() {
        return this.userAttributeHandler != null && this.userAttributeHandler.foreground != null ? this.userAttributeHandler.foreground : super.getForeground();
    }

    public Font getFont() {
        return this.userAttributeHandler != null && this.userAttributeHandler.font != null ? this.userAttributeHandler.font : super.getFont();
    }

    public Cursor getCursor() {
        if (Utils.globalCursor != null) {
            return Utils.globalCursor;
        }
        return this.userAttributeHandler != null && this.userAttributeHandler.cursor != null ? this.userAttributeHandler.cursor : super.getCursor();
    }

    public void setBackgroundImage(Image image) {
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: {
                this.setOpaque(true);
                break;
            }
            case 1: 
            case 2: {
                this.setOpaque(false);
            }
        }
    }
}

