/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.swing;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.eclipse.swt.internal.swing.CControl;
import org.eclipse.swt.internal.swing.CText;
import org.eclipse.swt.internal.swing.LookAndFeelUtils;
import org.eclipse.swt.internal.swing.TextFilterEvent;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Text;

class CTextMulti
extends JScrollPane
implements CText {
    protected Text handle;
    protected JTextArea textArea;
    protected CControl.UserAttributeHandler userAttributeHandler;
    protected KeyEvent keyEvent = null;
    protected int textLimit = Text.LIMIT;
    protected ImageIcon backgroundImageIcon;

    public Container getSwingComponent() {
        return this.textArea;
    }

    public Control getSWTHandle() {
        return this.handle;
    }

    public CControl.UserAttributeHandler getUserAttributeHandler() {
        return this.userAttributeHandler;
    }

    public CTextMulti(Text text, int n2) {
        this.handle = text;
        this.textArea = new JTextArea(){

            public Color getBackground() {
                return CTextMulti.this != null && CTextMulti.this.userAttributeHandler != null && CTextMulti.this.userAttributeHandler.background != null ? CTextMulti.this.userAttributeHandler.background : super.getBackground();
            }

            public Color getForeground() {
                return CTextMulti.this != null && CTextMulti.this.userAttributeHandler != null && CTextMulti.this.userAttributeHandler.foreground != null ? CTextMulti.this.userAttributeHandler.foreground : super.getForeground();
            }

            public Font getFont() {
                return CTextMulti.this != null && CTextMulti.this.userAttributeHandler != null && CTextMulti.this.userAttributeHandler.font != null ? CTextMulti.this.userAttributeHandler.font : super.getFont();
            }

            public Cursor getCursor() {
                if (CTextMulti.this == null || CTextMulti.this.userAttributeHandler == null) {
                    return super.getCursor();
                }
                if (Utils.globalCursor != null) {
                    return Utils.globalCursor;
                }
                Scrollable parent = CTextMulti.this.handle;
                while (parent != null && parent.handle != null) {
                    Cursor cursor = ((CControl)((Object)parent.handle)).getUserAttributeHandler().cursor;
                    if (cursor != null) {
                        return cursor;
                    }
                    parent = parent.getParent();
                }
                return super.getCursor();
            }

            public boolean isOpaque() {
                return CTextMulti.this.backgroundImageIcon == null && super.isOpaque();
            }
        };
        this.userAttributeHandler = new CControl.UserAttributeHandler(this.textArea);
        this.setFocusable(false);
        JViewport jViewport = new JViewport(){

            public boolean isOpaque() {
                return CTextMulti.this.backgroundImageIcon == null && super.isOpaque();
            }

            protected void paintComponent(Graphics g2) {
                Utils.paintTiledImage(this, g2, CTextMulti.this.backgroundImageIcon);
                super.paintComponent(g2);
            }

            public Color getBackground() {
                return CTextMulti.this != null && CTextMulti.this.userAttributeHandler != null && CTextMulti.this.userAttributeHandler.background != null ? CTextMulti.this.userAttributeHandler.background : super.getBackground();
            }
        };
        this.setViewport(jViewport);
        jViewport.setView(this.textArea);
        this.init(n2);
    }

    public boolean isFocusable() {
        return this.textArea.isFocusable();
    }

    public void requestFocus() {
        this.textArea.requestFocus();
    }

    protected void init(int n2) {
        LookAndFeelUtils.applyTextFieldStyle(this.textArea);
        if ((n2 & 0x800) == 0) {
            this.setBorder(null);
        }
        this.textArea.setBorder(null);
        if ((n2 & 0x40) != 0) {
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
        }
        this.textArea.setEditable((n2 & 8) == 0);
        if ((n2 & 0x100) == 0) {
            this.setHorizontalScrollBarPolicy(31);
        }
        if ((n2 & 0x200) == 0) {
            this.setVerticalScrollBarPolicy(21);
        }
        Utils.installMouseListener(this.textArea, this.handle);
        Utils.installKeyListener(this.textArea, this.handle);
        Utils.installFocusListener(this.textArea, this.handle);
        Utils.installComponentListener(this, this.handle);
        this.textArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e2) {
                CTextMulti.this.keyEvent = e2;
            }

            public void keyReleased(KeyEvent e2) {
                CTextMulti.this.keyEvent = null;
            }
        });
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e2) {
                CTextMulti.this.handle.processEvent(e2);
            }

            public void insertUpdate(DocumentEvent e2) {
                CTextMulti.this.handle.processEvent(e2);
            }

            public void removeUpdate(DocumentEvent e2) {
                CTextMulti.this.handle.processEvent(e2);
            }
        });
        ((AbstractDocument)this.textArea.getDocument()).setDocumentFilter(new DocumentFilter(){

            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                if (CTextMulti.this.getText().length() - length + text.length() > CTextMulti.this.getTextLimit()) {
                    return;
                }
                TextFilterEvent filterEvent = new TextFilterEvent(this, text, offset, length, CTextMulti.this.keyEvent);
                CTextMulti.this.handle.processEvent(filterEvent);
                String s2 = filterEvent.getText();
                if (s2 != null) {
                    super.replace(fb, offset, length, s2, attrs);
                }
            }

            public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
                TextFilterEvent filterEvent = new TextFilterEvent(this, "", offset, length, CTextMulti.this.keyEvent);
                CTextMulti.this.handle.processEvent(filterEvent);
                String s2 = filterEvent.getText();
                if (s2 != null) {
                    super.replace(fb, offset, length, s2, null);
                }
            }
        });
    }

    public Container getClientArea() {
        return this.textArea;
    }

    public String getText() {
        return this.textArea.getText();
    }

    public String getText(int n2, int n3) throws BadLocationException {
        return this.textArea.getText(n2, n3);
    }

    public void setText(String string) {
        this.textArea.setText(string);
    }

    public void setSelectionStart(int n2) {
        this.textArea.setSelectionStart(n2);
    }

    public void setSelectionEnd(int n2) {
        this.textArea.setSelectionEnd(n2);
    }

    public int getSelectionStart() {
        return this.textArea.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textArea.getSelectionEnd();
    }

    public void selectAll() {
        this.textArea.selectAll();
    }

    public void setEditable(boolean bl) {
        this.textArea.setEditable(bl);
    }

    public void setEchoChar(char c2) {
    }

    public char getEchoChar() {
        return '\u0000';
    }

    public void copy() {
        this.textArea.copy();
    }

    public void cut() {
        this.textArea.cut();
    }

    public void paste() {
        this.textArea.paste();
    }

    public void setTabSize(int n2) {
        this.textArea.setTabSize(n2);
    }

    public void replaceSelection(String string) {
        this.textArea.replaceSelection(string);
    }

    public boolean isEditable() {
        return this.textArea.isEditable();
    }

    public int getCaretPosition() {
        return this.textArea.getCaretPosition();
    }

    public int getLineCount() {
        return this.textArea.getLineCount();
    }

    public Point getCaretLocation() {
        int n2 = this.textArea.getCaretPosition();
        try {
            int n3 = this.textArea.getLineOfOffset(n2);
            int n4 = this.textArea.getFontMetrics(this.textArea.getFont()).stringWidth(this.textArea.getText().substring(this.textArea.getLineStartOffset(n3), n2));
            return new Point(n4, n3 * this.getRowHeight());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void showSelection() {
        try {
            Rectangle rectangle = this.textArea.modelToView(this.getSelectionStart());
            Rectangle rectangle2 = this.textArea.modelToView(this.getSelectionEnd());
            if (rectangle.y < rectangle2.y) {
                Dimension dimension = this.textArea.getSize();
                rectangle.x = 0;
                rectangle.width = dimension.width;
                rectangle2.x = 0;
                rectangle2.width = dimension.width;
            }
            rectangle.add(rectangle2);
            this.scrollRectToVisible(rectangle);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCaretLineNumber() {
        try {
            return this.textArea.getLineOfOffset(this.textArea.getCaretPosition());
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getRowHeight() {
        return this.textArea.getFontMetrics(this.textArea.getFont()).getHeight();
    }

    public void setComponentOrientation(ComponentOrientation componentOrientation) {
        super.setComponentOrientation(componentOrientation);
        this.textArea.setComponentOrientation(componentOrientation);
    }

    public Point getViewPosition() {
        return this.getViewport().getViewPosition();
    }

    public void setViewPosition(Point point) {
        this.getViewport().setViewPosition(point);
    }

    public void setTextLimit(int n2) {
        this.textLimit = n2;
        String string = this.getText();
        if (string.length() > n2) {
            this.setText(string.substring(0, n2));
        }
    }

    public int getTextLimit() {
        return this.textLimit;
    }

    public void setBackgroundImage(Image image) {
        this.backgroundImageIcon = image == null ? null : new ImageIcon(image);
    }

    public void setBackgroundInheritance(int n2) {
        switch (n2) {
            case 0: 
            case 1: {
                this.setOpaque(true);
                this.getViewport().setOpaque(true);
                this.textArea.setOpaque(true);
                break;
            }
            case 2: {
                this.setOpaque(false);
                this.getViewport().setOpaque(false);
                this.textArea.setOpaque(false);
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textArea.setEnabled(bl);
    }
}

