/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.ole.win32;

import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.IDispatch;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.ole.win32.OLE;
import org.eclipse.swt.ole.win32.OleAutomation;

public final class Variant {
    public static final int sizeof = 16;
    private short type;
    private boolean booleanData;
    private double doubleData;
    private int intData;
    private float floatData;
    private long longData;
    private short shortData;
    private String stringData;
    private int byRefPtr;
    private IDispatch dispatchData;
    private IUnknown unknownData;

    public Variant() {
        this.type = 0;
    }

    public Variant(float f2) {
        this.type = (short)4;
        this.floatData = f2;
    }

    public Variant(double d2) {
        this.type = (short)5;
        this.doubleData = d2;
    }

    public Variant(int n2) {
        this.type = (short)3;
        this.intData = n2;
    }

    public Variant(int n2, short s2) {
        this.type = s2;
        this.byRefPtr = n2;
    }

    public Variant(OleAutomation oleAutomation) {
        this.type = (short)9;
        this.dispatchData = new IDispatch(oleAutomation.getAddress());
    }

    public Variant(IDispatch iDispatch) {
        this.type = (short)9;
        this.dispatchData = iDispatch;
    }

    public Variant(IUnknown iUnknown) {
        this.type = (short)13;
        this.unknownData = iUnknown;
    }

    public Variant(long l2) {
        this.type = (short)20;
        this.longData = l2;
    }

    public Variant(String string) {
        this.type = (short)8;
        this.stringData = string;
    }

    public Variant(short s2) {
        this.type = (short)2;
        this.shortData = s2;
    }

    public Variant(boolean bl) {
        this.type = (short)11;
        this.booleanData = bl;
    }

    public void dispose() {
        if ((this.type & 0x4000) == 16384) {
            return;
        }
        switch (this.type) {
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 11: 
            case 20: {
                break;
            }
            case 9: {
                this.dispatchData.Release();
                break;
            }
            case 13: {
                this.unknownData.Release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OleAutomation getAutomation() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 9) {
            return new OleAutomation(this.dispatchData);
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)9);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            OleAutomation oleAutomation = variant.getAutomation();
            return oleAutomation;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDispatch getDispatch() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 9) {
            return this.dispatchData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)9);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            IDispatch iDispatch = variant.getDispatch();
            return iDispatch;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 11) {
            return this.booleanData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)11);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            boolean bl = variant.getBoolean();
            return bl;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    public int getByRef() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if ((this.type & 0x4000) == 16384) {
            return this.byRefPtr;
        }
        return 0;
    }

    void getData(int n2) {
        if (n2 == 0) {
            OLE.error((int)1007);
        }
        COM.VariantInit((int)n2);
        if ((this.type & 0x4000) == 16384) {
            COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
            COM.MoveMemory((int)(n2 + 8), (int[])new int[]{this.byRefPtr}, (int)4);
            return;
        }
        switch (this.type) {
            case 0: {
                break;
            }
            case 11: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (int[])new int[]{this.booleanData ? -1 : 0}, (int)2);
                break;
            }
            case 4: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (float[])new float[]{this.floatData}, (int)4);
                break;
            }
            case 5: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (double[])new double[]{this.doubleData}, (int)8);
                break;
            }
            case 3: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (int[])new int[]{this.intData}, (int)4);
                break;
            }
            case 20: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (long[])new long[]{this.longData}, (int)8);
                break;
            }
            case 9: {
                this.dispatchData.AddRef();
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (int[])new int[]{this.dispatchData.getAddress()}, (int)4);
                break;
            }
            case 13: {
                this.unknownData.AddRef();
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (int[])new int[]{this.unknownData.getAddress()}, (int)4);
                break;
            }
            case 2: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                COM.MoveMemory((int)(n2 + 8), (short[])new short[]{this.shortData}, (int)2);
                break;
            }
            case 8: {
                COM.MoveMemory((int)n2, (short[])new short[]{this.type}, (int)2);
                char[] cArray = (this.stringData + "\u0000").toCharArray();
                int n3 = COM.SysAllocString((char[])cArray);
                COM.MoveMemory((int)(n2 + 8), (int[])new int[]{n3}, (int)4);
                break;
            }
            default: {
                OLE.error((int)20);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getDouble() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 5) {
            return this.doubleData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)5);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            double d2 = variant.getDouble();
            return d2;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getFloat() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 4) {
            return this.floatData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)4);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            float f2 = variant.getFloat();
            return f2;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 3) {
            return this.intData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)3);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            int n5 = variant.getInt();
            return n5;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLong() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 20) {
            return this.longData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)20);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            long l2 = variant.getLong();
            return l2;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getShort() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 2) {
            return this.shortData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)2);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            short s2 = variant.getShort();
            return s2;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 8) {
            return this.stringData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)8);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            String string = variant.getString();
            return string;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    public short getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnknown getUnknown() {
        if (this.type == 0) {
            OLE.error((int)1010, (int)-1);
        }
        if (this.type == 13) {
            return this.unknownData;
        }
        int n2 = OS.GlobalAlloc((int)64, (int)16);
        int n3 = OS.GlobalAlloc((int)64, (int)16);
        try {
            this.getData(n2);
            int n4 = COM.VariantChangeType((int)n3, (int)n2, (short)0, (short)13);
            if (n4 != 0) {
                OLE.error((int)1010, (int)n4);
            }
            Variant variant = new Variant();
            variant.setData(n3);
            IUnknown iUnknown = variant.getUnknown();
            return iUnknown;
        }
        finally {
            COM.VariantClear((int)n2);
            OS.GlobalFree((int)n2);
            COM.VariantClear((int)n3);
            OS.GlobalFree((int)n3);
        }
    }

    public void setByRef(boolean bl) {
        if ((this.type & 0x4000) == 0 || (this.type & 0xB) == 0) {
            OLE.error((int)1010);
        }
        COM.MoveMemory((int)this.byRefPtr, (short[])new short[]{bl ? (short)-1 : 0}, (int)2);
    }

    public void setByRef(float f2) {
        if ((this.type & 0x4000) == 0 || (this.type & 4) == 0) {
            OLE.error((int)1010);
        }
        COM.MoveMemory((int)this.byRefPtr, (float[])new float[]{f2}, (int)4);
    }

    public void setByRef(int n2) {
        if ((this.type & 0x4000) == 0 || (this.type & 3) == 0) {
            OLE.error((int)1010);
        }
        COM.MoveMemory((int)this.byRefPtr, (int[])new int[]{n2}, (int)4);
    }

    public void setByRef(short s2) {
        if ((this.type & 0x4000) == 0 || (this.type & 2) == 0) {
            OLE.error((int)1010);
        }
        COM.MoveMemory((int)this.byRefPtr, (short[])new short[]{s2}, (int)2);
    }

    void setData(int n2) {
        if (n2 == 0) {
            OLE.error((int)5);
        }
        short[] sArray = new short[1];
        COM.MoveMemory((short[])sArray, (int)n2, (int)2);
        this.type = sArray[0];
        if ((this.type & 0x4000) == 16384) {
            int[] nArray = new int[1];
            OS.MoveMemory((int[])nArray, (int)(n2 + 8), (int)4);
            this.byRefPtr = nArray[0];
            return;
        }
        switch (this.type) {
            case 0: {
                break;
            }
            case 11: {
                short[] sArray2 = new short[1];
                COM.MoveMemory((short[])sArray2, (int)(n2 + 8), (int)2);
                this.booleanData = sArray2[0] != 0;
                break;
            }
            case 4: {
                float[] fArray = new float[1];
                COM.MoveMemory((float[])fArray, (int)(n2 + 8), (int)4);
                this.floatData = fArray[0];
                break;
            }
            case 5: {
                double[] dArray = new double[1];
                COM.MoveMemory((double[])dArray, (int)(n2 + 8), (int)8);
                this.doubleData = dArray[0];
                break;
            }
            case 3: {
                int[] nArray = new int[1];
                OS.MoveMemory((int[])nArray, (int)(n2 + 8), (int)4);
                this.intData = nArray[0];
                break;
            }
            case 20: {
                long[] lArray = new long[1];
                OS.MoveMemory((long[])lArray, (int)(n2 + 8), (int)8);
                this.longData = lArray[0];
                break;
            }
            case 9: {
                int[] nArray = new int[1];
                OS.MoveMemory((int[])nArray, (int)(n2 + 8), (int)4);
                if (nArray[0] == 0) {
                    this.type = 0;
                    break;
                }
                this.dispatchData = new IDispatch(nArray[0]);
                this.dispatchData.AddRef();
                break;
            }
            case 13: {
                int[] nArray = new int[1];
                OS.MoveMemory((int[])nArray, (int)(n2 + 8), (int)4);
                if (nArray[0] == 0) {
                    this.type = 0;
                    break;
                }
                this.unknownData = new IUnknown(nArray[0]);
                this.unknownData.AddRef();
                break;
            }
            case 2: {
                short[] sArray3 = new short[1];
                COM.MoveMemory((short[])sArray3, (int)(n2 + 8), (int)2);
                this.shortData = sArray3[0];
                break;
            }
            case 8: {
                int[] nArray = new int[1];
                OS.MoveMemory((int[])nArray, (int)(n2 + 8), (int)4);
                if (nArray[0] == 0) {
                    this.type = 0;
                    break;
                }
                int n3 = COM.SysStringByteLen((int)nArray[0]);
                if (n3 > 0) {
                    char[] cArray = new char[(n3 + 1) / 2];
                    COM.MoveMemory((char[])cArray, (int)nArray[0], (int)n3);
                    this.stringData = new String(cArray);
                    break;
                }
                this.stringData = "";
                break;
            }
            default: {
                int n4 = OS.GlobalAlloc((int)64, (int)16);
                if (COM.VariantChangeType((int)n4, (int)n2, (short)0, (short)4) == 0) {
                    this.setData(n4);
                } else if (COM.VariantChangeType((int)n4, (int)n2, (short)0, (short)3) == 0) {
                    this.setData(n4);
                } else if (COM.VariantChangeType((int)n4, (int)n2, (short)0, (short)8) == 0) {
                    this.setData(n4);
                }
                COM.VariantClear((int)n4);
                OS.GlobalFree((int)n4);
            }
        }
    }

    public String toString() {
        switch (this.type) {
            case 11: {
                return "VT_BOOL{" + this.booleanData + "}";
            }
            case 2: {
                return "VT_I2{" + this.shortData + "}";
            }
            case 3: {
                return "VT_I4{" + this.intData + "}";
            }
            case 20: {
                return "VT_I8{" + this.longData + "}";
            }
            case 4: {
                return "VT_R4{" + this.floatData + "}";
            }
            case 5: {
                return "VT_R8{" + this.doubleData + "}";
            }
            case 8: {
                return "VT_BSTR{" + this.stringData + "}";
            }
            case 9: {
                return "VT_DISPATCH{" + (this.dispatchData == null ? 0 : this.dispatchData.getAddress()) + "}";
            }
            case 13: {
                return "VT_UNKNOWN{" + (this.unknownData == null ? 0 : this.unknownData.getAddress()) + "}";
            }
            case 0: {
                return "VT_EMPTY";
            }
        }
        if ((this.type & 0x4000) != 0) {
            return "VT_BYREF|" + (this.type & 0xFFFFBFFF) + "{" + this.byRefPtr + "}";
        }
        return "Unsupported Type " + this.type;
    }
}

