/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.PageRanges;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.swing.CGC;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.NullGraphics2D;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    public PrinterJob handle;
    PrinterData data;
    boolean isGCCreated = false;
    protected int dpiX;
    protected int dpiY;
    volatile int pageCount;
    volatile List pageCommandList;
    volatile State initialState;
    CGCRecorder lastRecorder;
    PageFormat referencePageFormat;

    public static PrinterData[] getPrinterList() {
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        PrinterData[] printerDataArray = new PrinterData[printServiceArray.length];
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            PrintService printService = printServiceArray[i2];
            printerDataArray[i2] = new PrinterData(printService.getClass().getName(), printService.getName());
        }
        return printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        PrintService printService = PrinterJob.getPrinterJob().getPrintService();
        if (printService == null) {
            return null;
        }
        return new PrinterData(printService.getClass().getName(), printService.getName());
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
        this.initPrinterData();
    }

    protected void initPrinterData() {
        if (this.referencePageFormat != null) {
            return;
        }
        this.dpiX = 72;
        this.dpiY = 72;
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = this.getHashPrintRequestAttributeSet();
        PageFormat pageFormat = Compatibility.IS_JAVA_6_OR_GREATER ? this.handle.getPageFormat(hashPrintRequestAttributeSet) : this.handle.defaultPage();
        Paper paper = pageFormat.getPaper();
        paper.setImageableArea(0.0, 0.0, paper.getWidth(), paper.getHeight());
        pageFormat.setPaper(paper);
        this.referencePageFormat = this.handle.validatePage(pageFormat);
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintService(this.handle.getPrintService());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        printerJob.setPageable((Pageable)((Object)new CGCCommand(this){
            final /* synthetic */ CGCRecorder this$1;
            private final /* synthetic */ State val$state;
            {
                this.this$1 = cGCRecorder;
                this.val$state = state;
            }

            public void run(CGC cgc) {
                cgc.setFont(this.val$state.font);
                cgc.setColor(this.val$state.color);
                cgc.setBackground(this.val$state.background);
                cgc.setUserClip(this.val$state.userClip);
                cgc.setComposite(this.val$state.composite);
                cgc.setRenderingHints(this.val$state.renderingHints);
                cgc.setStroke(this.val$state.stroke);
                if (cgc instanceof CGCRecorder) {
                    ((CGCRecorder)cgc).setFontRenderContext(this.val$state.fontRenderContext);
                }
                cgc.setTransform(this.val$state.transform);
            }
        }));
        try {
            printerJob.print(hashPrintRequestAttributeSet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        PrintService printService = null;
        PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
        for (int i2 = 0; i2 < printServiceArray.length; ++i2) {
            PrintService printService2 = printServiceArray[i2];
            if (!printService2.getClass().getName().equals(this.data.driver) || !printService2.getName().equals(this.data.name)) continue;
            printService = printService2;
            break;
        }
        this.handle = PrinterJob.getPrinterJob();
        if (printService != null) {
            try {
                this.handle.setPrintService(printService);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.handle == null) {
            SWT.error(2);
        }
    }

    void addCommand(CGCRecorder cGCRecorder, CGCCommand cGCCommand) {
        if (this.pageCount > 0) {
            if (this.lastRecorder != cGCRecorder) {
                this.lastRecorder = cGCRecorder;
                this.addCommand(cGCRecorder, cGCRecorder.getStateCommand());
            }
            ((List)this.pageCommandList.get(this.pageCount - 1)).add(cGCCommand);
        }
    }

    public CGC internal_new_GC(GCData gCData) {
        if (this.handle == null) {
            SWT.error(2);
        }
        CGCRecorder cGCRecorder = new CGCRecorder();
        cGCRecorder.setState(this.initialState);
        return cGCRecorder;
    }

    public void internal_dispose_GC(CGC cGC, GCData gCData) {
        if (gCData != null) {
            cGC.dispose();
        }
    }

    HashPrintRequestAttributeSet getHashPrintRequestAttributeSet() {
        ArrayList<Cloneable> arrayList = new ArrayList<Cloneable>();
        if (this.data.printToFile) {
            arrayList.add(new Destination(new File(this.data.fileName).toURI()));
        }
        if (this.data.scope == 1) {
            arrayList.add(new PageRanges(this.data.startPage, this.data.endPage));
        }
        HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
        if (this.data.otherData != null) {
            hashPrintRequestAttributeSet.addAll(this.data.otherData);
        }
        hashPrintRequestAttributeSet.addAll(new HashPrintRequestAttributeSet(arrayList.toArray(new PrintRequestAttribute[0])));
        return hashPrintRequestAttributeSet;
    }

    public boolean startJob(String string) {
        this.checkDevice();
        this.handle.setJobName(string);
        this.pageCount = 0;
        this.pageCommandList = new ArrayList();
        return true;
    }

    public void endJob() {
        this.checkDevice();
        this.handle.setPageable((Pageable)((Object)new CGCCommand(this){
            final /* synthetic */ CGCRecorder this$1;
            private final /* synthetic */ int val$x;
            private final /* synthetic */ int val$y;
            private final /* synthetic */ int val$width;
            private final /* synthetic */ int val$height;
            private final /* synthetic */ int val$dx;
            private final /* synthetic */ int val$dy;
            {
                this.this$1 = cGCRecorder;
                this.val$x = n2;
                this.val$y = n3;
                this.val$width = n4;
                this.val$height = n5;
                this.val$dx = n6;
                this.val$dy = n7;
            }

            public void run(CGC cgc) {
                this.this$1.copyArea(this.val$x, this.val$y, this.val$width, this.val$height, this.val$dx, this.val$dy);
            }
        }));
        try {
            this.handle.print(this.getHashPrintRequestAttributeSet());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.pageCommandList = null;
        this.lastRecorder = null;
    }

    public void cancelJob() {
        this.checkDevice();
        this.handle.cancel();
        this.pageCommandList = null;
    }

    public boolean startPage() {
        this.checkDevice();
        ++this.pageCount;
        this.pageCommandList.add(new ArrayList());
        this.lastRecorder = null;
        return true;
    }

    public void endPage() {
        this.checkDevice();
    }

    protected Point getDPI_() {
        this.checkDevice();
        this.initPrinterData();
        return new Point(this.dpiX, this.dpiY);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        Point point = this.getDPI_();
        int n2 = (int)Math.round(this.referencePageFormat.getImageableWidth() * (double)point.x / 72.0);
        int n3 = (int)Math.round(this.referencePageFormat.getImageableHeight() * (double)point.y / 72.0);
        return new Rectangle(0, 0, n2, n3);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkDevice();
        return new Rectangle(n2, n3, n4, n5);
    }

    public PrinterData getPrinterData() {
        return this.data;
    }

    protected void checkDevice() {
        if (this.handle == null) {
            SWT.error(45);
        }
    }

    protected void release() {
        super.release();
        this.data = null;
    }

    protected void destroy() {
        this.handle = null;
    }

    class CGCRecorder
    extends CGC.CGCGraphics2D {
        protected Graphics2D graphics2D = new NullGraphics2D();
        protected FontRenderContext fontRenderContext;

        CGCRecorder() {
        }

        public Graphics2D getGraphics() {
            return this.graphics2D;
        }

        public void setState(State state) {
            super.setFont(state.font);
            super.setBackground(state.background);
            super.setColor(state.color);
            super.setUserClip(state.userClip);
            super.setComposite(state.composite);
            super.setRenderingHints(state.renderingHints);
            super.setStroke(state.stroke);
            super.setTransform(state.transform);
            this.setFontRenderContext(state.fontRenderContext);
        }

        public State getState() {
            State state = new State();
            state.font = super.getFont();
            state.background = super.getBackground();
            state.color = super.getColor();
            state.userClip = super.getUserClip();
            state.composite = super.getComposite();
            state.renderingHints = super.getRenderingHints();
            state.stroke = super.getStroke();
            state.fontRenderContext = super.getFontRenderContext();
            state.transform = super.getTransform();
            return state;
        }

        public CGCCommand getStateCommand() {
            State state = this.getState();
            return new /* invalid duplicate definition of identical inner class */;
        }

        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            Printer.this.addCommand(this, new /* invalid duplicate definition of identical inner class */);
            super.copyArea(x, y, width, height, dx, dy);
        }

        public void dispose() {
            super.dispose();
        }

        public void draw(Shape s2) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, s2){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Shape val$s;
                {
                    this.this$1 = cGCRecorder;
                    this.val$s = shape;
                }

                public void run(CGC cgc) {
                    cgc.draw(this.val$s);
                }
            });
            super.draw(s2);
        }

        public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height, startAngle, arcAngle){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                private final /* synthetic */ int val$startAngle;
                private final /* synthetic */ int val$arcAngle;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                    this.val$startAngle = n6;
                    this.val$arcAngle = n7;
                }

                public void run(CGC cgc) {
                    cgc.drawArc(this.val$x, this.val$y, this.val$width, this.val$height, this.val$startAngle, this.val$arcAngle);
                }
            });
            super.drawArc(x, y, width, height, startAngle, arcAngle);
        }

        public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
            BufferedImage image = new BufferedImage(sx2 - sx1, sy2 - sy1, 2);
            image.getGraphics().drawImage(img, 0, 0, image.getWidth(), image.getHeight(), sx1, sy1, sx2, sy2, observer);
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, image, dx1, dy1, dx2, dy2, observer){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ BufferedImage val$image;
                private final /* synthetic */ int val$dx1;
                private final /* synthetic */ int val$dy1;
                private final /* synthetic */ int val$dx2;
                private final /* synthetic */ int val$dy2;
                private final /* synthetic */ ImageObserver val$observer;
                {
                    this.this$1 = cGCRecorder;
                    this.val$image = bufferedImage;
                    this.val$dx1 = n2;
                    this.val$dy1 = n3;
                    this.val$dx2 = n4;
                    this.val$dy2 = n5;
                    this.val$observer = imageObserver;
                }

                public void run(CGC cgc) {
                    cgc.drawImage(this.val$image, this.val$dx1, this.val$dy1, this.val$dx2, this.val$dy2, 0, 0, this.val$image.getWidth(), this.val$image.getHeight(), this.val$observer);
                }
            });
            return super.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, observer);
        }

        public void drawLine(int x1, int y1, int x2, int y2) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x1, y1, x2, y2){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x1;
                private final /* synthetic */ int val$y1;
                private final /* synthetic */ int val$x2;
                private final /* synthetic */ int val$y2;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x1 = n2;
                    this.val$y1 = n3;
                    this.val$x2 = n4;
                    this.val$y2 = n5;
                }

                public void run(CGC cgc) {
                    cgc.drawLine(this.val$x1, this.val$y1, this.val$x2, this.val$y2);
                }
            });
            super.drawLine(x1, y1, x2, y2);
        }

        public void drawOval(int x, int y, int width, int height) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                }

                public void run(CGC cgc) {
                    cgc.drawOval(this.val$x, this.val$y, this.val$width, this.val$height);
                }
            });
            super.drawOval(x, y, width, height);
        }

        public void drawPolygon(int[] points, int[] points2, int points3) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, points, points2, points3){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int[] val$points;
                private final /* synthetic */ int[] val$points2;
                private final /* synthetic */ int val$points3;
                {
                    this.this$1 = cGCRecorder;
                    this.val$points = nArray;
                    this.val$points2 = nArray2;
                    this.val$points3 = n2;
                }

                public void run(CGC cgc) {
                    cgc.drawPolygon(this.val$points, this.val$points2, this.val$points3);
                }
            });
            super.drawPolygon(points, points2, points3);
        }

        public void drawPolyline(int[] points, int[] points2, int points3) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, points, points2, points3){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int[] val$points;
                private final /* synthetic */ int[] val$points2;
                private final /* synthetic */ int val$points3;
                {
                    this.this$1 = cGCRecorder;
                    this.val$points = nArray;
                    this.val$points2 = nArray2;
                    this.val$points3 = n2;
                }

                public void run(CGC cgc) {
                    cgc.drawPolyline(this.val$points, this.val$points2, this.val$points3);
                }
            });
            super.drawPolyline(points, points2, points3);
        }

        public void drawRect(int x, int y, int width, int height) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                }

                public void run(CGC cgc) {
                    cgc.drawRect(this.val$x, this.val$y, this.val$width, this.val$height);
                }
            });
            super.drawRect(x, y, width, height);
        }

        public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height, arcWidth, arcHeight){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                private final /* synthetic */ int val$arcWidth;
                private final /* synthetic */ int val$arcHeight;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                    this.val$arcWidth = n6;
                    this.val$arcHeight = n7;
                }

                public void run(CGC cgc) {
                    cgc.drawRoundRect(this.val$x, this.val$y, this.val$width, this.val$height, this.val$arcWidth, this.val$arcHeight);
                }
            });
            super.drawRoundRect(x, y, width, height, arcWidth, arcHeight);
        }

        public void drawString(String str, int x, int y) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, str, x, y){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ String val$str;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                {
                    this.this$1 = cGCRecorder;
                    this.val$str = string;
                    this.val$x = n2;
                    this.val$y = n3;
                }

                public void run(CGC cgc) {
                    cgc.drawString(this.val$str, this.val$x, this.val$y);
                }
            });
            super.drawString(str, x, y);
        }

        public void fill(Shape s2) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, s2){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Shape val$s;
                {
                    this.this$1 = cGCRecorder;
                    this.val$s = shape;
                }

                public void run(CGC cgc) {
                    cgc.fill(this.val$s);
                }
            });
            super.fill(s2);
        }

        public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height, startAngle, arcAngle){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                private final /* synthetic */ int val$startAngle;
                private final /* synthetic */ int val$arcAngle;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                    this.val$startAngle = n6;
                    this.val$arcAngle = n7;
                }

                public void run(CGC cgc) {
                    cgc.fillArc(this.val$x, this.val$y, this.val$width, this.val$height, this.val$startAngle, this.val$arcAngle);
                }
            });
            super.fillArc(x, y, width, height, startAngle, arcAngle);
        }

        public void fillOval(int x, int y, int width, int height) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                }

                public void run(CGC cgc) {
                    cgc.fillOval(this.val$x, this.val$y, this.val$width, this.val$height);
                }
            });
            super.fillOval(x, y, width, height);
        }

        public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, xPoints, yPoints, nPoints){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int[] val$xPoints;
                private final /* synthetic */ int[] val$yPoints;
                private final /* synthetic */ int val$nPoints;
                {
                    this.this$1 = cGCRecorder;
                    this.val$xPoints = nArray;
                    this.val$yPoints = nArray2;
                    this.val$nPoints = n2;
                }

                public void run(CGC cgc) {
                    cgc.fillPolygon(this.val$xPoints, this.val$yPoints, this.val$nPoints);
                }
            });
            super.fillPolygon(xPoints, yPoints, nPoints);
        }

        public void fillRect(int x, int y, int width, int height) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                }

                public void run(CGC cgc) {
                    cgc.fillRect(this.val$x, this.val$y, this.val$width, this.val$height);
                }
            });
            super.fillRect(x, y, width, height);
        }

        public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, x, y, width, height, arcWidth, arcHeight){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ int val$x;
                private final /* synthetic */ int val$y;
                private final /* synthetic */ int val$width;
                private final /* synthetic */ int val$height;
                private final /* synthetic */ int val$arcWidth;
                private final /* synthetic */ int val$arcHeight;
                {
                    this.this$1 = cGCRecorder;
                    this.val$x = n2;
                    this.val$y = n3;
                    this.val$width = n4;
                    this.val$height = n5;
                    this.val$arcWidth = n6;
                    this.val$arcHeight = n7;
                }

                public void run(CGC cgc) {
                    cgc.fillRoundRect(this.val$x, this.val$y, this.val$width, this.val$height, this.val$arcWidth, this.val$arcHeight);
                }
            });
            super.fillRoundRect(x, y, width, height, arcWidth, arcHeight);
        }

        public Color getBackground() {
            return super.getBackground();
        }

        public Color getColor() {
            return super.getColor();
        }

        public Composite getComposite() {
            return super.getComposite();
        }

        public Font getFont() {
            return super.getFont();
        }

        public FontMetrics getFontMetrics() {
            return super.getFontMetrics();
        }

        public void setFontRenderContext(FontRenderContext fontRenderContext) {
            this.fontRenderContext = fontRenderContext;
        }

        public FontRenderContext getFontRenderContext() {
            if (this.fontRenderContext != null) {
                return this.fontRenderContext;
            }
            return super.getFontRenderContext();
        }

        public Paint getPaint() {
            return super.getPaint();
        }

        public Object getRenderingHint(RenderingHints.Key hintKey) {
            return super.getRenderingHint(hintKey);
        }

        public RenderingHints getRenderingHints() {
            return super.getRenderingHints();
        }

        public Stroke getStroke() {
            return super.getStroke();
        }

        public AffineTransform getTransform() {
            return super.getTransform();
        }

        public void setBackground(Color background) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, background){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Color val$background;
                {
                    this.this$1 = cGCRecorder;
                    this.val$background = color;
                }

                public void run(CGC cgc) {
                    cgc.setBackground(this.val$background);
                }
            });
            super.setBackground(background);
        }

        public void setColor(Color color) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, color){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Color val$color;
                {
                    this.this$1 = cGCRecorder;
                    this.val$color = color;
                }

                public void run(CGC cgc) {
                    cgc.setColor(this.val$color);
                }
            });
            super.setColor(color);
        }

        public void setComposite(Composite comp) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, comp){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Composite val$comp;
                {
                    this.this$1 = cGCRecorder;
                    this.val$comp = composite;
                }

                public void run(CGC cgc) {
                    cgc.setComposite(this.val$comp);
                }
            });
            super.setComposite(comp);
        }

        public void setFont(Font font) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, font){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Font val$font;
                {
                    this.this$1 = cGCRecorder;
                    this.val$font = font;
                }

                public void run(CGC cgc) {
                    cgc.setFont(this.val$font);
                }
            });
            super.setFont(font);
        }

        public void setPaint(Paint paint) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, paint){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Paint val$paint;
                {
                    this.this$1 = cGCRecorder;
                    this.val$paint = paint;
                }

                public void run(CGC cgc) {
                    cgc.setPaint(this.val$paint);
                }
            });
            super.setPaint(paint);
        }

        public void setPaintMode() {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this){
                final /* synthetic */ CGCRecorder this$1;
                {
                    this.this$1 = cGCRecorder;
                }

                public void run(CGC cgc) {
                    cgc.setPaintMode();
                }
            });
            super.setPaintMode();
        }

        public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, hintKey, hintValue){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ RenderingHints.Key val$hintKey;
                private final /* synthetic */ Object val$hintValue;
                {
                    this.this$1 = cGCRecorder;
                    this.val$hintKey = key;
                    this.val$hintValue = object;
                }

                public void run(CGC cgc) {
                    cgc.setRenderingHint(this.val$hintKey, this.val$hintValue);
                }
            });
            super.setRenderingHint(hintKey, hintValue);
        }

        public void setRenderingHints(Map hints) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, hints){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Map val$hints;
                {
                    this.this$1 = cGCRecorder;
                    this.val$hints = map;
                }

                public void run(CGC cgc) {
                    cgc.setRenderingHints(this.val$hints);
                }
            });
            super.setRenderingHints(hints);
        }

        public void setStroke(Stroke s2) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, s2){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Stroke val$s;
                {
                    this.this$1 = cGCRecorder;
                    this.val$s = stroke;
                }

                public void run(CGC cgc) {
                    cgc.setStroke(this.val$s);
                }
            });
            super.setStroke(s2);
        }

        public void setTransform(AffineTransform tx) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, tx){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ AffineTransform val$tx;
                {
                    this.this$1 = cGCRecorder;
                    this.val$tx = affineTransform;
                }

                public void run(CGC cgc) {
                    cgc.setTransform(this.val$tx);
                }
            });
            super.setTransform(tx);
        }

        public void setXORMode(Color c1) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, c1){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Color val$c1;
                {
                    this.this$1 = cGCRecorder;
                    this.val$c1 = color;
                }

                public void run(CGC cgc) {
                    cgc.setXORMode(this.val$c1);
                }
            });
            super.setXORMode(c1);
        }

        public void transform(AffineTransform tx) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, tx){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ AffineTransform val$tx;
                {
                    this.this$1 = cGCRecorder;
                    this.val$tx = affineTransform;
                }

                public void run(CGC cgc) {
                    cgc.transform(this.val$tx);
                }
            });
            super.transform(tx);
        }

        public void setUserClip(Shape userClip) {
            Printer.this.addCommand(this, new CGCCommand(this, Printer.this, userClip){
                final /* synthetic */ CGCRecorder this$1;
                private final /* synthetic */ Shape val$userClip;
                {
                    this.this$1 = cGCRecorder;
                    this.val$userClip = shape;
                }

                public void run(CGC cgc) {
                    cgc.setUserClip(this.val$userClip);
                }
            });
            super.setUserClip(userClip);
        }

        public Shape getUserClip() {
            return super.getUserClip();
        }

        public Dimension getDeviceSize() {
            Rectangle bounds = Printer.this.getBounds();
            return new Dimension(bounds.width, bounds.height);
        }
    }

    class State {
        Font font;
        Color background;
        Color color;
        Shape userClip;
        Composite composite;
        RenderingHints renderingHints;
        Stroke stroke;
        AffineTransform transform;
        FontRenderContext fontRenderContext;

        State() {
        }
    }

    abstract class CGCCommand {
        CGCCommand() {
        }

        public abstract void run(CGC var1);
    }
}

