/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.program;

import java.awt.Desktop;
import java.io.File;
import java.net.URI;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.Utils;

public final class Program {
    String name;
    String command;
    String iconName;

    Program() {
    }

    public static Program findProgram(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return null;
        }
        if (string.charAt(0) != '.') {
            string = "." + string;
        }
        Utils.notImplemented();
        return null;
    }

    public static String[] getExtensions() {
        Utils.notImplemented();
        return new String[0];
    }

    public static Program[] getPrograms() {
        Utils.notImplemented();
        return new Program[0];
    }

    public static boolean launch(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (!Compatibility.IS_JAVA_6_OR_GREATER) {
            if (!Compatibility.IS_JAVA_5_OR_GREATER) {
                try {
                    Runtime.getRuntime().exec(string);
                    return true;
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ProcessBuilder processBuilder = new ProcessBuilder(string);
            try {
                processBuilder.start();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.open(new File(string));
            return true;
        }
        catch (Exception exception) {
            try {
                URI uRI = new URI(string);
                if (string.startsWith("mailto:")) {
                    desktop.mail(uRI);
                } else if (string.startsWith("http:") || string.startsWith("https:") || string.startsWith("ftp:")) {
                    desktop.browse(uRI);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return false;
        }
    }

    public boolean execute(String string) {
        if (string == null) {
            SWT.error(4);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (!Compatibility.IS_JAVA_5_OR_GREATER) {
            try {
                Runtime.getRuntime().exec(string);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        ProcessBuilder processBuilder = new ProcessBuilder(string);
        try {
            processBuilder.start();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ImageData getImageData() {
        Utils.notImplemented();
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Program) {
            Program program = (Program)object;
            return this.name.equals(program.name) && this.command.equals(program.command) && this.iconName.equals(program.iconName);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.command.hashCode() ^ this.iconName.hashCode();
    }

    public String toString() {
        return "Program {" + this.name + "}";
    }
}

