/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CCoolBar;
import org.eclipse.swt.internal.swing.CCoolItem;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.JCoolBarItem;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;

public class CoolBar
extends Composite {
    ArrayList itemList;
    ArrayList originalItemList;

    public CoolBar(Composite composite, int n2) {
        super(composite, CoolBar.checkStyle(n2));
    }

    static int checkStyle(int n2) {
        return (n2 |= 0x80000) & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    boolean autoAddChildren() {
        return false;
    }

    void createHandleInit() {
        super.createHandleInit();
        this.state &= 0xFFFFFEFD;
    }

    protected Container createHandle() {
        return (Container)((Object)CCoolBar.Factory.newInstance(this, this.style));
    }

    void createItem(CoolItem coolItem, int n2) {
        int n3 = this.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.itemList.add(n2, coolItem);
        this.handle.add((Component)coolItem.handle, n2);
        this.originalItemList.add(n2, coolItem);
    }

    void createWidget() {
        super.createWidget();
        this.itemList = new ArrayList(4);
        this.originalItemList = new ArrayList(4);
    }

    void destroyItem(CoolItem coolItem) {
        if (!this.itemList.remove(coolItem)) {
            return;
        }
        Component[] componentArray = this.handle.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] != coolItem.handle) continue;
            if (i2 + 1 < componentArray.length && ((CCoolItem)((Object)coolItem.handle)).isWrapped()) {
                ((CCoolItem)((Object)componentArray[i2 + 1])).setWrapped(true);
            }
            this.handle.remove(i2);
            ((JComponent)this.handle).revalidate();
            this.handle.repaint();
            break;
        }
        this.originalItemList.remove(coolItem);
        if (this.itemList.isEmpty()) {
            this.itemList = new ArrayList(4);
            this.originalItemList = new ArrayList(4);
        }
    }

    public CoolItem getItem(int n2) {
        this.checkWidget();
        int n3 = this.getItemCount();
        if (0 > n2 || n2 >= n3) {
            this.error(6);
        }
        Component component = this.handle.getComponent(n2);
        for (int i2 = this.itemList.size() - 1; i2 >= 0; --i2) {
            CoolItem coolItem = (CoolItem)this.itemList.get(i2);
            if (coolItem.handle != component) continue;
            return coolItem;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return ((CCoolBar)((Object)this.handle)).getItemCount();
    }

    public int[] getItemOrder() {
        this.checkWidget();
        Utils.notImplemented();
        return null;
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        int n2 = this.getItemCount();
        CoolItem[] coolItemArray = new CoolItem[n2];
        ArrayList arrayList = (ArrayList)this.itemList.clone();
        Component[] componentArray = this.handle.getComponents();
        block0: for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            for (int i3 = arrayList.size() - 1; i3 >= 0; --i3) {
                CoolItem coolItem = (CoolItem)arrayList.get(i3);
                if (coolItem.handle != component) continue;
                arrayList.remove(i3);
                coolItemArray[i2] = coolItem;
                continue block0;
            }
        }
        return coolItemArray;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        Component[] componentArray = this.handle.getComponents();
        int n2 = componentArray.length;
        Point[] pointArray = new Point[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Dimension dimension = componentArray[i2].getSize();
            pointArray[i2] = new Point(dimension.width, dimension.height);
        }
        return pointArray;
    }

    public boolean getLocked() {
        this.checkWidget();
        return ((CCoolBar)((Object)this.handle)).isLocked();
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        Component[] componentArray = this.handle.getComponents();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 1; i2 < componentArray.length; ++i2) {
            if (!((JCoolBarItem)componentArray[i2]).isWrapped()) continue;
            if (Compatibility.IS_JAVA_5_OR_GREATER) {
                arrayList.add(i2);
                continue;
            }
            arrayList.add(new Integer(i2));
        }
        int[] nArray = new int[arrayList.size()];
        for (int i3 = 0; i3 < nArray.length; ++i3) {
            nArray[i3] = (Integer)arrayList.get(i3);
        }
        return nArray;
    }

    public int indexOf(CoolItem coolItem) {
        this.checkWidget();
        if (coolItem == null) {
            this.error(4);
        }
        if (coolItem.isDisposed()) {
            this.error(5);
        }
        Component[] componentArray = this.handle.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] != coolItem.handle) continue;
            return i2;
        }
        return -1;
    }

    Point minimumSize(int n2, int n3, boolean bl) {
        Dimension dimension = this.handle.getPreferredSize();
        return new Point(dimension.width, dimension.height);
    }

    void releaseChildren(boolean bl) {
        if (this.itemList != null) {
            for (int i2 = this.itemList.size() - 1; i2 >= 0; --i2) {
                CoolItem coolItem = (CoolItem)this.itemList.get(i2);
                if (coolItem == null || coolItem.isDisposed()) continue;
                coolItem.release(false);
            }
            this.itemList = null;
            this.originalItemList = null;
        }
        super.releaseChildren(bl);
    }

    void removeControl(Control control) {
        if (this.isDisposed()) {
            return;
        }
        super.removeControl(control);
        int n2 = this.itemList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            CoolItem coolItem = (CoolItem)this.itemList.get(i2);
            if (coolItem == null || coolItem.control != control) continue;
            coolItem.setControl(null);
        }
    }

    public void setItemLayout(int[] nArray, int[] nArray2, Point[] pointArray) {
        this.checkWidget();
        this.setRedraw(false);
        Utils.notImplemented();
    }

    public void setLocked(boolean bl) {
        this.checkWidget();
        ((CCoolBar)((Object)this.handle)).setLocked(bl);
    }

    public void setWrapIndices(int[] nArray) {
        this.checkWidget();
        if (nArray == null) {
            nArray = new int[]{};
        }
        int n2 = this.getItemCount();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] >= 0 && nArray[i2] < n2) continue;
            this.error(6);
        }
        this.setRedraw(false);
        ((CCoolBar)((Object)this.handle)).setWrappedIndices(nArray);
        this.setRedraw(true);
    }
}

