/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.Compatibility;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Menu
extends Widget {
    public JComponent handle;
    int x;
    int y;
    boolean hasLocation;
    MenuItem cascade;
    Decorations parent;

    public Menu(Control control) {
        this(Menu.checkNull(control).menuShell(), 8);
    }

    public Menu(Decorations decorations, int n2) {
        this(decorations, Menu.checkStyle(n2), null);
    }

    public Menu(Menu menu) {
        this(Menu.checkNull((Menu)menu).parent, 4);
    }

    public Menu(MenuItem menuItem) {
        this(Menu.checkNull((MenuItem)menuItem).parent);
    }

    Menu(Decorations decorations, int n2, JMenuBar jMenuBar) {
        super(decorations, Menu.checkStyle(n2));
        this.parent = decorations;
        this.handle = jMenuBar;
        this.createWidget();
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(menuListener);
        this.addListener(23, typedListener);
        this.addListener(22, typedListener);
    }

    static Control checkNull(Control control) {
        if (control == null) {
            SWT.error(4);
        }
        return control;
    }

    static Menu checkNull(Menu menu) {
        if (menu == null) {
            SWT.error(4);
        }
        return menu;
    }

    static MenuItem checkNull(MenuItem menuItem) {
        if (menuItem == null) {
            SWT.error(4);
        }
        return menuItem;
    }

    static int checkStyle(int n2) {
        return Menu.checkBits(n2, 8, 2, 4, 0, 0, 0);
    }

    void createHandle() {
        if (this.handle != null) {
            return;
        }
        if ((this.style & 2) != 0) {
            JMenuBar jMenuBar = new JMenuBar();
            this.handle = jMenuBar;
        } else if ((this.style & 8) != 0) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e2) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                    if (!Menu.this.hooks(23)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(Menu.this.getDisplay());
                    if (Menu.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            Event event = new Event();
                            event.widget = Menu.this;
                            Menu.this.sendEvent(23, event);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                    if (!Menu.this.hooks(22)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(Menu.this.getDisplay());
                    if (Menu.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            Event event = new Event();
                            event.widget = Menu.this;
                            Menu.this.sendEvent(22, event);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            });
            this.handle = jPopupMenu;
        } else if ((this.style & 4) != 0) {
            this.handle = new JMenu();
        }
    }

    void createItem(MenuItem menuItem, int n2) {
        int n3 = this.handle.getComponentCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.display.addMenuItem(menuItem);
        this.handle.add((Component)menuItem.handle, n2);
    }

    void createWidget() {
        this.checkOrientation(this.parent);
        this.createHandle();
        this.parent.addMenu(this);
    }

    void destroyItem(MenuItem menuItem) {
        Container container = menuItem.handle.getParent();
        this.handle.remove(menuItem.handle);
        if (container instanceof JPopupMenu) {
            ((JPopupMenu)container).pack();
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    void fixMenus(Decorations decorations) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            menuItemArray[i2].fixMenus(decorations);
        }
        this.parent.removeMenu(this);
        decorations.addMenu(this);
        this.parent = decorations;
    }

    org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = this.handle.getBounds();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public MenuItem getDefaultItem() {
        this.checkWidget();
        return null;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.handle.isEnabled();
    }

    public MenuItem getItem(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        int n3 = 0;
        int n4 = this.handle.getComponentCount();
        if (n2 > n4) {
            this.error(6);
        }
        for (int i2 = 0; i2 < n4; ++i2) {
            MenuItem menuItem = this.display.getMenuItem((JComponent)this.handle.getComponent(i2));
            if (menuItem == null) continue;
            if (n3 == n2) {
                return menuItem;
            }
            ++n3;
        }
        this.error(6);
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        int n2 = this.handle.getComponentCount();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = this.display.getMenuItem((JComponent)this.handle.getComponent(i2));
            if (menuItem == null) continue;
            ++n3;
        }
        return n3;
    }

    public MenuItem[] getItems() {
        this.checkWidget();
        int n2 = this.handle.getComponentCount();
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = this.display.getMenuItem((JComponent)this.handle.getComponent(i2));
            if (menuItem == null) continue;
            arrayList.add(menuItem);
        }
        return arrayList.toArray(new MenuItem[0]);
    }

    String getNameText() {
        String string = "";
        MenuItem[] menuItemArray = this.getItems();
        int n2 = menuItemArray.length;
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                string = string + menuItemArray[i2].getNameText() + ", ";
            }
            string = string + menuItemArray[n2 - 1].getNameText();
        }
        return string;
    }

    public Decorations getParent() {
        this.checkWidget();
        return this.parent;
    }

    public MenuItem getParentItem() {
        this.checkWidget();
        return this.cascade;
    }

    public Menu getParentMenu() {
        this.checkWidget();
        if (this.cascade != null) {
            return this.cascade.parent;
        }
        return null;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        Menu menu;
        Menu[] menuArray;
        this.checkWidget();
        if (!this.handle.isVisible()) {
            return false;
        }
        if ((this.style & 2) != 0) {
            return this == this.parent.menuShell().menuBar;
        }
        if ((this.style & 8) != 0) {
            menuArray = this.display.popups;
            if (menuArray == null) {
                return false;
            }
            for (int i2 = 0; i2 < menuArray.length; ++i2) {
                if (menuArray[i2] != this) continue;
                return true;
            }
        }
        menuArray = this.getShell();
        for (menu = menuArray.activeMenu; menu != null && menu != this; menu = menu.getParentMenu()) {
        }
        return this == menu;
    }

    public int indexOf(MenuItem menuItem) {
        this.checkWidget();
        if (menuItem == null) {
            this.error(4);
        }
        if (menuItem.isDisposed()) {
            this.error(5);
        }
        if (menuItem.parent != this) {
            return -1;
        }
        int n2 = this.handle.getComponentCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.handle.getComponent(i2) != menuItem.handle) continue;
            return i2;
        }
        return -1;
    }

    public boolean isEnabled() {
        this.checkWidget();
        Menu menu = this.getParentMenu();
        if (menu == null) {
            return this.getEnabled();
        }
        return this.getEnabled() && menu.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = null;
    }

    void releaseChildren(boolean bl) {
        MenuItem[] menuItemArray = this.getItems();
        for (int i2 = 0; i2 < menuItemArray.length; ++i2) {
            MenuItem menuItem = menuItemArray[i2];
            if (menuItem == null || menuItem.isDisposed()) continue;
            menuItem.release(false);
        }
        super.releaseChildren(bl);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.cascade != null) {
            this.cascade.releaseMenu();
        }
        if ((this.style & 2) != 0) {
            this.display.removeBar(this);
            if (this == this.parent.menuBar) {
                this.parent.setMenuBar(null);
            }
        } else if ((this.style & 8) != 0) {
            this.display.removePopup(this);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent != null) {
            this.parent.removeMenu(this);
        }
        this.parent = null;
        this.cascade = null;
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeMenuListener(MenuListener menuListener) {
        this.checkWidget();
        if (menuListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(23, menuListener);
        this.eventTable.unhook(22, menuListener);
    }

    public void setDefaultItem(MenuItem menuItem) {
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.handle.setEnabled(bl);
    }

    public void setLocation(int n2, int n3) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        this.x = n2;
        this.y = n3;
        this.hasLocation = true;
    }

    public void setLocation(Point point) {
        this.checkWidget();
        if (point == null) {
            SWT.error(4);
        }
        this.setLocation(point.x, point.y);
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if ((this.style & 6) != 0) {
            return;
        }
        JPopupMenu jPopupMenu = (JPopupMenu)this.handle;
        if (bl) {
            Container container;
            this.display.addPopup(this);
            java.awt.Point point = this.hasLocation ? new java.awt.Point(this.x, this.y) : (Compatibility.IS_JAVA_5_OR_GREATER ? MouseInfo.getPointerInfo().getLocation() : new java.awt.Point(0, 0));
            Shell shell = this.getShell();
            if (shell != null && (container = shell.handle).isShowing()) {
                SwingUtilities.convertPointFromScreen(point, container);
                jPopupMenu.show(container, point.x, point.y);
                return;
            }
            jPopupMenu.show(null, point.x, point.y);
        } else {
            this.display.removePopup(this);
            jPopupMenu.setVisible(false);
        }
    }
}

