/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int accelerator;
    JComponent handle;
    boolean adjustSelection;

    public MenuItem(Menu menu, int n2) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.createHandle();
        menu.createItem(this, menu.getItemCount());
    }

    public MenuItem(Menu menu, int n2, int n3) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.createHandle();
        menu.createItem(this, n3);
    }

    MenuItem(Menu menu, Menu menu2, int n2, int n3) {
        super(menu, MenuItem.checkStyle(n2));
        this.parent = menu;
        this.menu = menu2;
        if (menu2 != null) {
            menu2.cascade = this;
        }
        this.display.addMenuItem(this);
    }

    public void addArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(armListener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(helpListener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    static int checkStyle(int n2) {
        return MenuItem.checkBits(n2, 8, 32, 16, 2, 64, 0);
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    void fixMenus(Decorations decorations) {
        if (this.menu != null) {
            this.menu.fixMenus(decorations);
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = this.handle.getBounds();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.handle.isEnabled();
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return ((AbstractButton)this.handle).isSelected();
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseChildren(boolean bl) {
        if (this.menu != null) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(bl);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseMenu() {
        this.setMenu(null);
        this.menu = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.accelerator = 0;
        this.display.removeMenuItem(this);
    }

    public void removeArmListener(ArmListener armListener) {
        this.checkWidget();
        if (armListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, armListener);
    }

    public void removeHelpListener(HelpListener helpListener) {
        this.checkWidget();
        if (helpListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, helpListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        MenuItem[] menuItemArray = this.parent.getItems();
        for (int i2 = 0; i2 < menuItemArray.length && menuItemArray[i2] != this; ++i2) {
        }
        for (int i3 = i2 - 1; i3 >= 0 && menuItemArray[i3].setRadioSelection(false); --i3) {
        }
        for (int i4 = i2 + 1; i4 < menuItemArray.length && menuItemArray[i4].setRadioSelection(false); ++i4) {
        }
        this.setSelection(true);
    }

    public void setAccelerator(int n2) {
        this.checkWidget();
        if (this.accelerator == n2) {
            return;
        }
        this.accelerator = n2;
        int n3 = n2 & 0x100FFFF;
        int n4 = Display.untranslateKey(n3);
        if (n4 != 0) {
            n3 = n4;
        }
        if (this.handle instanceof JMenu) {
            ((JMenu)this.handle).setMnemonic(n3);
        } else {
            int n5 = 0;
            if ((n2 & 0x10000) != 0) {
                n5 |= 0x200;
            }
            if ((n2 & 0x20000) != 0) {
                n5 |= 0x40;
            }
            if ((n2 & 0x40000) != 0) {
                n5 |= 0x80;
            }
            ((JMenuItem)this.handle).setAccelerator(KeyStroke.getKeyStroke(n3, n5));
        }
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.handle.setEnabled(bl);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        ImageIcon imageIcon = null;
        if (image != null && image.handle != null) {
            imageIcon = new ImageIcon(image.handle);
        }
        ((AbstractButton)this.handle).setIcon(imageIcon);
    }

    public void setMenu(Menu menu) {
        Object object;
        Container container;
        JMenu jMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            this.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 4) == 0) {
                this.error(21);
            }
            if (menu.parent != this.parent.parent) {
                this.error(32);
            }
        }
        if (!(this.handle instanceof JMenu)) {
            jMenu = new JMenu(){

                public void menuSelectionChanged(boolean isIncluded) {
                    super.menuSelectionChanged(isIncluded);
                    if (!isIncluded) {
                        return;
                    }
                    if (!MenuItem.this.hooks(30)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            MenuItem.this.sendEvent(30);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            };
            jMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

                public void popupMenuCanceled(PopupMenuEvent e2) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
                    if (MenuItem.this.menu == null) {
                        return;
                    }
                    if (!MenuItem.this.menu.hooks(23)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            Event event = new Event();
                            event.widget = MenuItem.this.menu;
                            MenuItem.this.menu.sendEvent(23, event);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
                    if (MenuItem.this.menu == null) {
                        return;
                    }
                    if (!MenuItem.this.menu.hooks(22)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            Event event = new Event();
                            event.widget = MenuItem.this.menu;
                            MenuItem.this.menu.sendEvent(22, event);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            });
            container = this.handle.getParent();
            if (container != null) {
                for (int i2 = container.getComponentCount() - 1; i2 >= 0; --i2) {
                    if (container.getComponent(i2) != this.handle) continue;
                    container.remove(this.handle);
                    container.add((Component)jMenu, i2);
                    if (container instanceof JComponent) {
                        ((JComponent)container).revalidate();
                    } else {
                        container.invalidate();
                        container.validate();
                    }
                    container.repaint();
                    break;
                }
            }
            object = (JMenuItem)this.handle;
            jMenu.setText(((AbstractButton)object).getText());
            jMenu.setMnemonic(((AbstractButton)object).getMnemonic());
            jMenu.setEnabled(((Component)object).isEnabled());
            jMenu.setSelected(((AbstractButton)object).isSelected());
            jMenu.setIcon(((AbstractButton)object).getIcon());
            this.handle = jMenu;
        }
        jMenu = (JMenu)this.handle;
        container = jMenu.getPopupMenu();
        container.removeAll();
        object = this.menu;
        if (object == menu) {
            return;
        }
        if (object != null) {
            ((Menu)object).cascade = null;
        }
        this.menu = menu;
        if (menu != null) {
            menu.cascade = this;
            Component[] componentArray = ((JMenu)menu.handle).getPopupMenu().getComponents();
            for (int i3 = 0; i3 < componentArray.length; ++i3) {
                container.add(componentArray[i3]);
            }
            menu.handle = container;
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.adjustSelection = true;
        ((AbstractButton)this.handle).setSelected(bl);
        this.adjustSelection = false;
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.text.equals(string)) {
            return;
        }
        super.setText(string);
        AbstractButton abstractButton = (AbstractButton)this.handle;
        int n2 = this.findMnemonicIndex(string);
        if (n2 != -1) {
            abstractButton.setMnemonic(string.charAt(n2));
            string = string.substring(0, n2 - 1) + string.substring(n2);
        } else {
            abstractButton.setMnemonic('\u0000');
        }
        n2 = string.lastIndexOf(9);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        abstractButton.setText(string);
        Container container = abstractButton.getParent();
        if (container instanceof JPopupMenu) {
            ((JPopupMenu)container).pack();
        }
    }

    void createHandle() {
        if ((this.style & 2) != 0) {
            this.handle = new JSeparator();
        } else if ((this.style & 0x40) != 0 || (this.style & 8) != 0) {
            JMenuItem jMenuItem = new JMenuItem(){

                public void menuSelectionChanged(boolean isIncluded) {
                    super.menuSelectionChanged(isIncluded);
                    if (!isIncluded) {
                        if (MenuItem.this.parent == null || MenuItem.this.parent.cascade == null) {
                            return;
                        }
                        if (!MenuItem.this.parent.cascade.hooks(30)) {
                            return;
                        }
                        UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                        if (MenuItem.this.isDisposed()) {
                            UIThreadUtils.stopExclusiveSection();
                            return;
                        }
                        MenuItem.this.parent.cascade.sendEvent(30);
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    if (!MenuItem.this.hooks(30)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    MenuItem.this.sendEvent(30);
                    UIThreadUtils.stopExclusiveSection();
                }
            };
            this.handle = jMenuItem;
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e2) {
                    if (!MenuItem.this.hooks(13)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            Event event = new Event();
                            event.stateMask = Display.getInputState();
                            MenuItem.this.sendEvent(13, event);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            });
        } else if ((this.style & 0x20) != 0) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.handle = jCheckBoxMenuItem;
            jCheckBoxMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e2) {
                    if (MenuItem.this.adjustSelection || !MenuItem.this.hooks(13)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            MenuItem.this.sendEvent(13);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            });
        } else if ((this.style & 0x10) != 0) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(){

                protected void fireActionPerformed(ActionEvent e2) {
                    if (!this.isSelected()) {
                        this.setSelected(true);
                    }
                    Component[] components = this.getParent().getComponents();
                    int i2 = 0;
                    while (i2 < components.length) {
                        Component component = components[i2];
                        if (component instanceof JRadioButton && component != this) {
                            ((JRadioButton)component).setSelected(false);
                        }
                        ++i2;
                    }
                    super.fireActionPerformed(e2);
                    if (MenuItem.this.adjustSelection || !MenuItem.this.hooks(13)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    Event event = new Event();
                    event.stateMask = Display.getInputState();
                    MenuItem.this.sendEvent(13, event);
                    UIThreadUtils.stopExclusiveSection();
                }
            };
            this.handle = jRadioButtonMenuItem;
            jRadioButtonMenuItem.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e2) {
                    if (e2.getStateChange() == 1) {
                        MenuItem.this.selectRadio();
                    }
                    if (!MenuItem.this.hooks(30)) {
                        return;
                    }
                    UIThreadUtils.startExclusiveSection(MenuItem.this.getDisplay());
                    if (MenuItem.this.isDisposed()) {
                        UIThreadUtils.stopExclusiveSection();
                        return;
                    }
                    try {
                        try {
                            MenuItem.this.sendEvent(30);
                        }
                        catch (Throwable t2) {
                            UIThreadUtils.storeException(t2);
                        }
                    }
                    finally {
                        UIThreadUtils.stopExclusiveSection();
                    }
                }
            });
        }
    }
}

