/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.swing.CScrollable;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;
    JScrollBar handle;
    boolean blockListener;

    ScrollBar(Scrollable scrollable, int n2) {
        super(scrollable, ScrollBar.checkStyle(n2));
        this.parent = scrollable;
        this.createWidget();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ScrollBar.checkBits(n2, 256, 512, 0, 0, 0, 0);
    }

    void createWidget() {
        this.handle = (this.style & 0x100) != 0 ? ((CScrollable)((Object)this.parent.handle)).getHorizontalScrollBar() : ((CScrollable)((Object)this.parent.handle)).getVerticalScrollBar();
        this.handle.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent e2) {
                if (ScrollBar.this.blockListener || ScrollBar.this.isDisposed()) {
                    return;
                }
                Event event = new Event();
                event.detail = 1;
                switch (e2.getAdjustmentType()) {
                    case 3: {
                        event.detail = 0x1000006;
                        break;
                    }
                    case 4: {
                        event.detail = 0x1000005;
                        break;
                    }
                    case 2: {
                        event.detail = 0x1000002;
                        break;
                    }
                    case 1: {
                        event.detail = 0x1000001;
                    }
                }
                ScrollBar.this.sendEvent(13, event);
            }
        });
    }

    void destroyWidget() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.releaseHandle();
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.handle.isEnabled();
    }

    public int getIncrement() {
        this.checkWidget();
        return this.handle.getUnitIncrement();
    }

    public int getMaximum() {
        this.checkWidget();
        return this.handle.getMaximum();
    }

    public int getMinimum() {
        this.checkWidget();
        return this.handle.getMinimum();
    }

    public int getPageIncrement() {
        this.checkWidget();
        return this.handle.getBlockIncrement();
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        return this.handle.getValue();
    }

    public Point getSize() {
        this.checkWidget();
        Dimension dimension = (this.style & 0x100) != 0 ? ((CScrollable)((Object)this.parent.handle)).getHorizontalScrollBar().getSize() : ((CScrollable)((Object)this.parent.handle)).getVerticalScrollBar().getSize();
        return new Point(dimension.width, dimension.height);
    }

    public int getThumb() {
        this.checkWidget();
        return this.handle.getVisibleAmount();
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.handle.isVisible();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible() && this.parent.isVisible();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.handle.setEnabled(bl);
    }

    public void setIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.handle.setUnitIncrement(n2);
    }

    public void setMaximum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        int n3 = this.handle.getMinimum();
        if (n2 <= n3) {
            return;
        }
        this.blockListener = true;
        this.handle.setMaximum(n2);
        this.blockListener = false;
    }

    public void setMinimum(int n2) {
        this.checkWidget();
        if (n2 < 0) {
            return;
        }
        int n3 = this.handle.getMaximum();
        if (n2 >= n3) {
            return;
        }
        this.blockListener = true;
        this.handle.setMinimum(n2);
        this.blockListener = false;
    }

    public void setPageIncrement(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        this.handle.setBlockIncrement(n2);
    }

    public void setSelection(int n2) {
        this.checkWidget();
        this.blockListener = true;
        this.handle.setValue(n2);
        this.blockListener = false;
    }

    public void setThumb(int n2) {
        this.checkWidget();
        if (n2 < 1) {
            return;
        }
        int n3 = this.handle.getMinimum();
        int n4 = this.handle.getMaximum();
        int n5 = n4 - n3;
        if (n2 > n5) {
            n2 = n5;
        }
        int n6 = n4 - n2;
        int n7 = this.handle.getValue();
        if (n7 > n6) {
            n7 = n6;
        }
        this.blockListener = true;
        this.handle.setValues(n7, n2, n3, n4);
        this.blockListener = false;
    }

    public void setValues(int n2, int n3, int n4, int n5, int n6, int n7) {
        this.checkWidget();
        if (n3 < 0) {
            return;
        }
        if (n4 < 0) {
            return;
        }
        if (n5 < 1) {
            return;
        }
        if (n6 < 1) {
            return;
        }
        if (n7 < 1) {
            return;
        }
        this.blockListener = true;
        this.handle.setValues(n2, n5, n3, n4);
        this.blockListener = false;
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (this.handle.getParent() instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)this.handle.getParent();
            if ((this.style & 0x100) != 0) {
                if (bl) {
                    jScrollPane.setHorizontalScrollBarPolicy((this.parent.getStyle() & 0x100) != 0 ? 32 : 30);
                } else {
                    jScrollPane.setHorizontalScrollBarPolicy(31);
                }
            } else if (bl) {
                jScrollPane.setVerticalScrollBarPolicy((this.parent.getStyle() & 0x200) != 0 ? 22 : 20);
            } else {
                jScrollPane.setVerticalScrollBarPolicy(21);
            }
        } else {
            this.handle.setVisible(bl);
        }
    }
}

