/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.awt.AWTEvent;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.ImageIcon;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.swing.CToolItem;
import org.eclipse.swt.internal.swing.UIThreadUtils;
import org.eclipse.swt.internal.swing.Utils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;

public class ToolItem
extends Item {
    ToolBar parent;
    Control control;
    Image disabledImage;
    Image hotImage;
    Container handle;
    boolean isAdjustingSelection;
    String toolTipText;

    public ToolItem(ToolBar toolBar, int n2) {
        super(toolBar, ToolItem.checkStyle(n2));
        this.parent = toolBar;
        this.handle = this.createHandle();
        toolBar.createItem(this, toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n2, int n3) {
        super(toolBar, ToolItem.checkStyle(n2));
        this.parent = toolBar;
        this.handle = this.createHandle();
        toolBar.createItem(this, n3);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n2) {
        return ToolItem.checkBits(n2, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    Container createHandle() {
        return (Container)((Object)CToolItem.Factory.newInstance(this, this.style));
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public org.eclipse.swt.graphics.Rectangle getBounds() {
        this.checkWidget();
        Rectangle rectangle = this.handle.getBounds();
        return new org.eclipse.swt.graphics.Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return this.handle.isEnabled();
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return ((CToolItem)((Object)this.handle)).isSelected();
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        return this.handle.getWidth();
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
        this.hotImage = null;
        this.disabledImage = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i2 = 0; i2 < toolItemArray.length && toolItemArray[i2] != this; ++i2) {
        }
        for (int i3 = i2 - 1; i3 >= 0 && toolItemArray[i3].setRadioSelection(false); --i3) {
        }
        for (int i4 = i2 + 1; i4 < toolItemArray.length && toolItemArray[i4].setRadioSelection(false); ++i4) {
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control != null) {
            this.handle.remove(this.control.handle);
        }
        this.control = control;
        this.handle.add(control.handle);
        this.handle.invalidate();
        this.handle.validate();
        this.handle.repaint();
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        this.handle.setEnabled(bl);
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.disabledImage = image;
        ((CToolItem)((Object)this.handle)).setDisabledIcon(image == null ? null : new ImageIcon(image.handle));
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.hotImage = image;
        ((CToolItem)((Object)this.handle)).setRolloverIcon(image == null ? null : new ImageIcon(image.handle));
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        super.setImage(image);
        ((CToolItem)((Object)this.handle)).setIcon(image == null ? null : new ImageIcon(image.handle));
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            if (!this.isAdjustingSelection) {
                this.sendEvent(13);
            }
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        this.isAdjustingSelection = true;
        ((CToolItem)((Object)this.handle)).setSelected(bl);
        this.isAdjustingSelection = false;
    }

    public void setText(String string) {
        char c2;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        CToolItem cToolItem = (CToolItem)((Object)this.handle);
        int n2 = this.findMnemonicIndex(string);
        if (n2 < 0) {
            c2 = '\u0000';
            cToolItem.setText(string);
        } else {
            c2 = string.charAt(n2);
            cToolItem.setText(string.substring(0, n2 - 1) + string.substring(n2));
        }
        cToolItem.setMnemonic(c2);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
        ((CToolItem)((Object)this.handle)).setToolTipText(Utils.convertStringToHTML(string));
    }

    public void setWidth(int n2) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n2 < 0) {
            return;
        }
        ((CToolItem)((Object)this.handle)).setWidth(n2);
        this.parent.handle.invalidate();
        this.parent.handle.validate();
        this.parent.handle.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processEvent(AWTEvent aWTEvent) {
        int n2 = aWTEvent.getID();
        switch (n2) {
            case 1001: {
                if ((this.style & 0x10) != 0) break;
                if (this.isAdjustingSelection) return;
                if (this.hooks(13)) break;
                return;
            }
            case 701: {
                if (this.isAdjustingSelection) return;
                if (this.hooks(13)) break;
                return;
            }
            default: {
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        UIThreadUtils.startExclusiveSection(this.getDisplay());
        if (this.isDisposed()) {
            UIThreadUtils.stopExclusiveSection();
            return;
        }
        try {
            switch (n2) {
                case 1001: {
                    Event event = new Event();
                    if ((this.style & 0x10) != 0) {
                        if ((this.parent.getStyle() & 0x400000) == 0) {
                            this.selectRadio();
                        }
                    } else if ("Arrow".equals(((ActionEvent)aWTEvent).getActionCommand())) {
                        event.detail = 4;
                    }
                    if (this.isAdjustingSelection) return;
                    this.sendEvent(13, event);
                    return;
                }
                case 701: {
                    if (this.isAdjustingSelection) return;
                    this.sendEvent(13);
                    return;
                }
            }
            return;
        }
        catch (Throwable throwable) {
            UIThreadUtils.storeException(throwable);
            return;
        }
        finally {
            UIThreadUtils.stopExclusiveSection();
        }
    }
}

