/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.formats.html;

import bluej.doclet.doclets.formats.html.ConfigurationImpl;
import bluej.doclet.doclets.formats.html.HtmlDocletWriter;
import bluej.doclet.doclets.formats.html.LinkInfoImpl;
import bluej.doclet.doclets.internal.toolkit.util.IndexBuilder;
import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MemberDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Tag;
import java.io.IOException;
import java.util.List;

public class AbstractIndexWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;

    protected AbstractIndexWriter(ConfigurationImpl configuration, String path, String filename, String relpath, IndexBuilder indexbuilder) throws IOException {
        super(configuration, path, filename, relpath);
        this.indexbuilder = indexbuilder;
    }

    protected AbstractIndexWriter(ConfigurationImpl configuration, String filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    @Override
    protected void navLinkIndex() {
        this.navCellRevStart();
        this.fontStyle("NavBarFont1Rev");
        this.boldText("doclet.Index");
        this.fontEnd();
        this.navCellEnd();
    }

    protected void generateContents(Character unicode, List memberlist) {
        this.anchor("_" + unicode + "_");
        this.h2();
        this.bold(unicode.toString());
        this.h2End();
        this.dl();
        for (int i = 0; i < memberlist.size(); ++i) {
            Doc element = (Doc)memberlist.get(i);
            if (element instanceof MemberDoc) {
                this.printDescription((MemberDoc)element);
                continue;
            }
            if (element instanceof ClassDoc) {
                this.printDescription((ClassDoc)element);
                continue;
            }
            if (!(element instanceof PackageDoc)) continue;
            this.printDescription((PackageDoc)element);
        }
        this.dlEnd();
        this.hr();
    }

    protected void printDescription(PackageDoc pkg) {
        this.dt();
        this.printPackageLink(pkg, Util.getPackageName(pkg), true);
        this.print(" - ");
        this.print(this.configuration.getText("doclet.package") + " " + pkg.name());
        this.dd();
        this.printSummaryComment((Doc)pkg);
    }

    protected void printDescription(ClassDoc cd) {
        this.dt();
        this.printLink(new LinkInfoImpl(5, cd, true));
        this.print(" - ");
        this.printClassInfo(cd);
        this.dd();
        this.printComment((ProgramElementDoc)cd);
    }

    protected void printClassInfo(ClassDoc cd) {
        this.print(this.configuration.getText("doclet.in", Util.getTypeName(this.configuration, cd, false), this.getPackageLink(cd.containingPackage(), Util.getPackageName(cd.containingPackage()), false)));
    }

    protected void printDescription(MemberDoc member) {
        String name;
        String string = name = member instanceof ExecutableMemberDoc ? member.name() + ((ExecutableMemberDoc)member).flatSignature() : member.name();
        if (name.indexOf("<") != -1 || name.indexOf(">") != -1) {
            name = Util.escapeHtmlChars(name);
        }
        ClassDoc containing = member.containingClass();
        this.dt();
        this.printDocLink(5, member, name, true);
        this.println(" - ");
        this.printMemberDesc(member);
        this.println();
        this.dd();
        this.printComment((ProgramElementDoc)member);
        this.println();
    }

    protected void printComment(ProgramElementDoc element) {
        if (Util.isDeprecated(element)) {
            this.boldText("doclet.Deprecated");
            this.space();
            Tag[] tags = element.tags("deprecated");
            if (tags.length > 0) {
                this.printInlineDeprecatedComment((Doc)element, tags[0]);
            }
        } else {
            for (ClassDoc cont = element.containingClass(); cont != null; cont = cont.containingClass()) {
                if (!Util.isDeprecated((ProgramElementDoc)cont)) continue;
                this.boldText("doclet.Deprecated");
                this.space();
                break;
            }
            this.printSummaryComment((Doc)element);
        }
    }

    protected void printMemberDesc(MemberDoc member) {
        ClassDoc containing = member.containingClass();
        String classdesc = Util.getTypeName(this.configuration, containing, true) + " " + this.getPreQualifiedClassLink(5, containing, false);
        if (member.isField()) {
            if (member.isStatic()) {
                this.printText("doclet.Static_variable_in", classdesc);
            } else {
                this.printText("doclet.Variable_in", classdesc);
            }
        } else if (member.isConstructor()) {
            this.printText("doclet.Constructor_for", classdesc);
        } else if (member.isMethod()) {
            if (member.isStatic()) {
                this.printText("doclet.Static_method_in", classdesc);
            } else {
                this.printText("doclet.Method_in", classdesc);
            }
        }
    }
}

