/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.util;

import bluej.doclet.doclets.internal.toolkit.util.Util;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassDocCatalog {
    private Set packageSet;
    private Map allClasses;
    private Map ordinaryClasses;
    private Map exceptions;
    private Map enums;
    private Map annotationTypes;
    private Map errors;
    private Map interfaces;

    public ClassDocCatalog(ClassDoc[] classdocs) {
        this.init();
        for (int i = 0; i < classdocs.length; ++i) {
            this.addClassDoc(classdocs[i]);
        }
    }

    public ClassDocCatalog() {
        this.init();
    }

    private void init() {
        this.allClasses = new HashMap();
        this.ordinaryClasses = new HashMap();
        this.exceptions = new HashMap();
        this.enums = new HashMap();
        this.annotationTypes = new HashMap();
        this.errors = new HashMap();
        this.interfaces = new HashMap();
        this.packageSet = new HashSet();
    }

    public void addClassDoc(ClassDoc classdoc) {
        if (classdoc == null) {
            return;
        }
        this.addClass(classdoc, this.allClasses);
        if (classdoc.isOrdinaryClass()) {
            this.addClass(classdoc, this.ordinaryClasses);
        } else if (classdoc.isException()) {
            this.addClass(classdoc, this.exceptions);
        } else if (classdoc.isEnum()) {
            this.addClass(classdoc, this.enums);
        } else if (classdoc.isAnnotationType()) {
            this.addClass(classdoc, this.annotationTypes);
        } else if (classdoc.isError()) {
            this.addClass(classdoc, this.errors);
        } else if (classdoc.isInterface()) {
            this.addClass(classdoc, this.interfaces);
        }
    }

    private void addClass(ClassDoc classdoc, Map map) {
        PackageDoc pkg = classdoc.containingPackage();
        if (pkg.isIncluded()) {
            return;
        }
        String key = Util.getPackageName(pkg);
        HashSet<ClassDoc> s = (HashSet<ClassDoc>)map.get(key);
        if (s == null) {
            this.packageSet.add(key);
            s = new HashSet<ClassDoc>();
        }
        s.add(classdoc);
        map.put(key, s);
    }

    private ClassDoc[] getArray(Map m, String key) {
        Set s = (Set)m.get(key);
        if (s == null) {
            return new ClassDoc[0];
        }
        return s.toArray(new ClassDoc[0]);
    }

    public ClassDoc[] allClasses(PackageDoc pkgDoc) {
        return pkgDoc.isIncluded() ? pkgDoc.allClasses() : this.getArray(this.allClasses, Util.getPackageName(pkgDoc));
    }

    public ClassDoc[] allClasses(String packageName) {
        return this.getArray(this.allClasses, packageName);
    }

    public String[] packageNames() {
        return this.packageSet.toArray(new String[0]);
    }

    public boolean isKnownPackage(String packageName) {
        return this.packageSet.contains(packageName);
    }

    public ClassDoc[] errors(String packageName) {
        return this.getArray(this.errors, packageName);
    }

    public ClassDoc[] exceptions(String packageName) {
        return this.getArray(this.exceptions, packageName);
    }

    public ClassDoc[] enums(String packageName) {
        return this.getArray(this.enums, packageName);
    }

    public ClassDoc[] annotationTypes(String packageName) {
        return this.getArray(this.annotationTypes, packageName);
    }

    public ClassDoc[] interfaces(String packageName) {
        return this.getArray(this.interfaces, packageName);
    }

    public ClassDoc[] ordinaryClasses(String packageName) {
        return this.getArray(this.ordinaryClasses, packageName);
    }
}

