/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.bluej.extensions.submitter.properties.CompilationException;

class Tokenizer {
    static final Type END = new Type();
    static final Type BLOCK_START = new Type();
    static final Type BLOCK_END = new Type();
    static final Type CONFIG = new Type();
    static final Type EMPTY_SCHEME = new Type();
    private BufferedReader source;
    private String title;
    private String key;
    private String value;
    private char nextChar;
    private StringBuffer buf;
    private int lineNumber;
    private boolean endOfFile;
    private String currentLine;
    private int linePosition;

    Tokenizer(Reader source) {
        this.source = new BufferedReader(source);
        this.buf = new StringBuffer();
        this.lineNumber = 0;
        this.currentLine = "";
        this.linePosition = 1;
        this.endOfFile = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Type next() throws CompilationException {
        if (this.endOfFile) {
            return END;
        }
        Type token = null;
        this.readNext();
        this.skipWhiteSpace();
        if (this.endOfFile) {
            return END;
        }
        if (this.nextChar == '}') {
            return BLOCK_END;
        }
        if (this.parseConfig()) {
            return CONFIG;
        }
        if (!this.parseString("\"{}=;/")) throw new CompilationException("Syntax Error", this);
        if (this.nextChar == '{') {
            token = BLOCK_START;
            this.title = this.buf.toString();
            return token;
        } else if (this.nextChar == ';') {
            token = EMPTY_SCHEME;
            this.title = this.buf.toString();
            return token;
        } else {
            if (this.nextChar == '\"') throw new CompilationException("; or { expected", this);
            this.pushBack();
            throw new CompilationException("; or { expected", this);
        }
    }

    private boolean parseConfig() throws CompilationException {
        if (this.nextChar != '.') {
            return false;
        }
        this.parseString("\"{}/*=!#\u00a3$%^&()+-[]@'~:;\\<>,");
        this.key = this.buf.toString().toLowerCase();
        if (this.nextChar != '=') {
            throw new CompilationException("= expected", this);
        }
        this.readNext();
        this.parseString("\";{}");
        if (this.nextChar != ';') {
            if (this.nextChar != '\"') {
                this.pushBack();
            }
            throw new CompilationException("; expected", this);
        }
        this.value = this.buf.toString();
        return true;
    }

    private boolean parseString(String terminate) throws CompilationException {
        this.buf.setLength(0);
        this.skipWhiteSpace();
        if (this.nextChar == '\"') {
            this.readNext();
            while (this.nextChar != '\"') {
                this.buf.append(this.nextChar);
                this.readNext();
            }
            do {
                this.readNext();
            } while (this.nextChar == ' ');
            return true;
        }
        while (terminate.indexOf(this.nextChar) == -1) {
            if (this.nextChar != '\n') {
                this.buf.append(this.nextChar);
            }
            this.readNext();
        }
        return this.buf.length() != 0;
    }

    private void skipWhiteSpace() throws CompilationException {
        boolean soak;
        do {
            soak = false;
            if (Character.isWhitespace(this.nextChar)) {
                soak = true;
            } else if (this.nextChar == '/') {
                if (this.lookAhead() == '/') {
                    do {
                        this.readNext();
                    } while (this.nextChar != '\n');
                    soak = true;
                } else if (this.lookAhead() == '*') {
                    do {
                        this.readNext();
                    } while (this.nextChar != '*' || this.lookAhead() != '/');
                    this.readNext();
                    soak = true;
                }
            }
            if (!soak) continue;
            this.readNext();
        } while (soak && !this.endOfFile);
    }

    private void readNext() throws CompilationException {
        char prevChar = this.nextChar;
        if (this.endOfFile) {
            throw new CompilationException("Unexpected End Of File", this);
        }
        do {
            try {
                if (this.linePosition > this.currentLine.length()) {
                    ++this.lineNumber;
                    this.currentLine = this.source.readLine();
                    this.linePosition = 0;
                    if (this.currentLine == null) {
                        this.endOfFile = true;
                        this.nextChar = '\u0000';
                        return;
                    }
                }
                if (this.linePosition == this.currentLine.length()) {
                    ++this.linePosition;
                    this.nextChar = (char)10;
                    continue;
                }
                this.nextChar = this.currentLine.charAt(this.linePosition++);
                if (!Character.isWhitespace(this.nextChar)) continue;
                this.nextChar = (char)32;
            }
            catch (IOException ex) {
                throw new CompilationException("Trouble reading file: " + ex.toString(), this);
            }
        } while (Character.isWhitespace(prevChar) && Character.isWhitespace(this.nextChar));
    }

    private char lookAhead() {
        if (this.linePosition < this.currentLine.length()) {
            return this.currentLine.charAt(this.linePosition);
        }
        return '\u0000';
    }

    private void pushBack() {
        if (this.linePosition > 0) {
            --this.linePosition;
        }
    }

    String getCurrentLine() {
        return this.currentLine;
    }

    int getLinePosition() {
        return this.linePosition;
    }

    String getTitle() {
        String trim = this.title.trim();
        if (trim.charAt(0) == '#') {
            trim = '#' + this.title.substring(1).trim();
        }
        return trim;
    }

    String getKey() {
        return this.key.trim();
    }

    String getValue() {
        return this.value.trim();
    }

    int getLineNumber() {
        return this.lineNumber;
    }

    static class Type {
        Type() {
        }
    }
}

