/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.actions;

import bluej.Config;
import greenfoot.core.GClass;
import greenfoot.core.GPackage;
import greenfoot.gui.GreenfootFrame;
import greenfoot.gui.NewClassDialog;
import greenfoot.gui.classbrowser.ClassBrowser;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.gui.classbrowser.role.NormalClassRole;
import greenfoot.platforms.ide.GreenfootUtilDelegateIDE;
import greenfoot.record.InteractionListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

public class NewClassAction
extends AbstractAction {
    private GreenfootFrame gfFrame;
    private InteractionListener interactionListener;

    public NewClassAction(GreenfootFrame gfFrame, InteractionListener interactionListener) {
        super(Config.getString((String)"new.class"));
        this.setEnabled(false);
        this.gfFrame = gfFrame;
        this.interactionListener = interactionListener;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        GreenfootFrame f = this.gfFrame;
        ClassBrowser classBrowser = this.gfFrame.getClassBrowser();
        GPackage pkg = null;
        pkg = classBrowser.getProject().getDefaultPackage();
        NewClassDialog dialog = new NewClassDialog(f, pkg);
        dialog.setVisible(true);
        if (!dialog.okPressed()) {
            return;
        }
        String className = dialog.getClassName();
        try {
            File dir = pkg.getProject().getDir();
            File newJavaFile = new File(dir, String.valueOf(className) + ".java");
            GreenfootUtilDelegateIDE.getInstance().createSkeleton(className, null, newJavaFile, NormalClassRole.getInstance().getTemplateFileName(), pkg.getProject().getCharsetName());
            GClass newClass = pkg.newClass(className, false);
            ClassView classView = new ClassView(classBrowser, newClass, this.interactionListener);
            classBrowser.addClass(classView);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }
}

