/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.core;

import bluej.extensions.ClassNotFoundException;
import bluej.extensions.CompilationNotStartedException;
import bluej.extensions.PackageNotFoundException;
import bluej.extensions.ProjectNotOpenException;
import bluej.runtime.ExecServer;
import bluej.utility.Debug;
import greenfoot.core.GPackage;
import greenfoot.core.ProjectProperties;
import greenfoot.gui.classbrowser.ClassView;
import greenfoot.util.GreenfootUtil;
import java.awt.EventQueue;
import java.rmi.RemoteException;
import rmiextension.wrappers.RClass;

public class GClass {
    private static String simObj = "greenfoot.Actor";
    private static String worldObj = "greenfoot.World";
    private RClass rmiClass;
    private GPackage pkg;
    private String superclassGuess;
    private String className;
    private boolean compiled;
    private ClassView classView;
    private Class<?> realClass;

    protected GClass() {
    }

    public GClass(RClass cls, GPackage pkg, boolean inRemoteCallback) {
        this.rmiClass = cls;
        this.pkg = pkg;
        try {
            this.compiled = cls.isCompiled(inRemoteCallback);
            if (this.compiled) {
                this.loadRealClass();
            }
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Problem checking class compiled state", (Throwable)e);
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Problem checking class compiled state", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Problem checking class compiled state", (Throwable)e);
        }
    }

    public void loadSavedSuperClass(boolean inRemoteCallback) {
        String savedSuperclass = this.getClassProperty("superclass");
        if (savedSuperclass == null) {
            this.guessSuperclass(inRemoteCallback);
        } else {
            this.setSuperclassGuess(savedSuperclass);
        }
    }

    public void setClassView(ClassView view) {
        this.classView = view;
    }

    public synchronized void nameChanged(final String oldName) {
        try {
            this.className = null;
            ProjectProperties props = this.pkg.getProject().getProjectProperties();
            String superClass = props.removeProperty("class." + oldName + ".superclass");
            String classImage = props.removeProperty("class." + oldName + ".image");
            props.removeCachedImage(oldName);
            this.setClassProperty("superclass", superClass);
            if (classImage != null) {
                this.setClassProperty("image", classImage);
            }
        }
        catch (Exception e) {
            Debug.reportError((String)"Remote error in GClass.nameChanged()", (Throwable)e);
        }
        if (this.classView != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GClass.this.classView.nameChanged(oldName);
                }
            });
        }
    }

    public String getClassProperty(String propertyName) {
        return this.pkg.getProject().getProjectProperties().getString("class." + this.getName() + "." + propertyName);
    }

    public void setClassProperty(String propertyName, String value) {
        try {
            String key = "class." + this.getName() + "." + propertyName;
            if (value != null) {
                this.pkg.getProject().getProjectProperties().setString(key, value);
            } else {
                this.pkg.getProject().getProjectProperties().removeProperty(key);
            }
        }
        catch (Exception exc) {
            Debug.reportError((String)("Greenfoot: Could not set class property: " + this.getName() + "." + propertyName), (Throwable)exc);
        }
    }

    public void compile(boolean waitCompileEnd, boolean forceQuiet) throws ProjectNotOpenException, PackageNotFoundException, RemoteException, CompilationNotStartedException {
        this.rmiClass.compile(waitCompileEnd, forceQuiet);
    }

    public void edit() {
        try {
            this.rmiClass.edit();
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not open editor", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not open editor", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not open editor", (Throwable)e);
        }
    }

    public void closeEditor() {
        try {
            this.rmiClass.closeEditor();
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not close editor", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not close editor", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not close editor", (Throwable)e);
        }
    }

    public boolean hasSourceCode() {
        try {
            return this.rmiClass.hasSourceCode();
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not close editor", (Throwable)e);
            return false;
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not close editor", (Throwable)e);
            return false;
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not close editor", (Throwable)e);
            return false;
        }
    }

    public void insertAppendMethod(String comment, String access, String methodName, String methodBody, boolean showEditorOnCreate, boolean showEditorOnAppend) {
        try {
            this.rmiClass.insertAppendMethod(comment, access, methodName, methodBody, showEditorOnCreate, showEditorOnAppend);
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not insert code", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not insert code", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not insert code", (Throwable)e);
        }
    }

    public void insertMethodCallInConstructor(String methodName, boolean showEditor) {
        try {
            this.rmiClass.insertMethodCallInConstructor(methodName, showEditor);
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not insert code", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not insert code", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not insert code", (Throwable)e);
        }
    }

    public void showMessage(String message) {
        try {
            this.rmiClass.showMessage(message);
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not display editor message", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not display editor message", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not display editor message", (Throwable)e);
        }
    }

    public void remove() {
        ProjectProperties props = this.pkg.getProject().getProjectProperties();
        props.removeProperty("class." + this.getName() + ".superclass");
        props.removeProperty("class." + this.getName() + ".image");
        props.removeCachedImage(this.getName());
        try {
            this.rmiClass.remove();
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Could not remove class", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Could not remove class", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Debug.reportError((String)"Could not remove class", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Could not remove class", (Throwable)e);
        }
    }

    public Class<?> getJavaClass() {
        return this.realClass;
    }

    public GPackage getPackage() {
        return this.pkg;
    }

    public synchronized String getQualifiedName() {
        if (this.className == null) {
            try {
                this.className = this.rmiClass.getQualifiedName();
            }
            catch (Exception e) {
                Debug.reportError((String)"While trying to get class name", (Throwable)e);
            }
        }
        return this.className;
    }

    public String getName() {
        return GreenfootUtil.extractClassName(this.getQualifiedName());
    }

    public GClass getSuperclass() {
        GClass superClass = this.getSuperclassWithoutCheck();
        if (this.containsCyclicHierarchy()) {
            return null;
        }
        return superClass;
    }

    private boolean containsCyclicHierarchy() {
        GClass superCls = this.getSuperclassWithoutCheck();
        while (superCls != null) {
            if (superCls == this) {
                return true;
            }
            superCls = superCls.getSuperclassWithoutCheck();
        }
        return false;
    }

    private GClass getSuperclassWithoutCheck() {
        String superclassName = this.getSuperclassGuess();
        if (superclassName == null) {
            return null;
        }
        superclassName = GreenfootUtil.extractClassName(superclassName);
        GClass superClass = this.pkg.getClass(superclassName);
        return superClass;
    }

    public String getSuperclassGuess() {
        return this.superclassGuess;
    }

    public boolean setSuperclassGuess(String superclassName) {
        boolean isNewName;
        if (superclassName.equals(this.getQualifiedName())) {
            return false;
        }
        boolean isDefaultPkg = !superclassName.contains(".");
        boolean isGreenfootClass = superclassName.startsWith("greenfoot.");
        boolean bl = isNewName = this.superclassGuess == null || !this.superclassGuess.equals(superclassName);
        if (isNewName && (isDefaultPkg || isGreenfootClass)) {
            this.superclassGuess = superclassName;
            if (this.containsCyclicHierarchy()) {
                this.superclassGuess = "";
            }
        } else if (!isDefaultPkg && !isGreenfootClass) {
            this.superclassGuess = "";
        }
        this.setClassProperty("superclass", this.superclassGuess);
        return true;
    }

    private synchronized void guessSuperclass(boolean inRemoteCallback) {
        String name = this.getQualifiedName();
        if ((name.equals("greenfoot.World") || name.equals("greenfoot.Actor")) && this.setSuperclassGuess("")) {
            return;
        }
        if (this.isCompiled()) {
            Class<?> superclass = this.realClass.getSuperclass();
            if (superclass == null || !this.setSuperclassGuess(superclass.getName())) {
                this.setSuperclassGuess("");
            }
            return;
        }
        try {
            RClass sclass = this.rmiClass.getSuperclass(inRemoteCallback);
            if (sclass != null) {
                this.setSuperclassGuess(sclass.getQualifiedName());
                return;
            }
        }
        catch (ProjectNotOpenException e) {
            Debug.reportError((String)"Couldn't get superclass", (Throwable)e);
        }
        catch (PackageNotFoundException e) {
            Debug.reportError((String)"Couldn't get superclass", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            Debug.reportError((String)"Couldn't get superclass", (Throwable)e);
        }
        catch (RemoteException e) {
            Debug.reportError((String)"Couldn't get superclass", (Throwable)e);
        }
    }

    public boolean isCompiled() {
        return this.compiled;
    }

    public synchronized void setCompiledState(boolean isCompiled) {
        this.compiled = isCompiled;
        if (this.classView != null) {
            this.classView.repaint();
        }
        if (isCompiled) {
            this.loadRealClass();
        } else {
            this.realClass = null;
        }
    }

    public boolean isSubclassOf(String className) {
        if (this.getQualifiedName().equals(className)) {
            return false;
        }
        GClass currentClass = this;
        do {
            String superclassName;
            if (!className.equals(superclassName = currentClass.getSuperclassGuess())) continue;
            return true;
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return false;
    }

    public synchronized void reload() {
        this.loadRealClass();
        this.guessSuperclass(false);
        if (this.classView != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GClass.this.classView.updateView();
                }
            });
        }
    }

    private void loadRealClass() {
        Class<?> cls = null;
        if (!this.isCompiled()) {
            this.realClass = null;
            return;
        }
        try {
            String className = this.getQualifiedName();
            ClassLoader classLdr = ExecServer.getCurrentClassLoader();
            cls = Class.forName(className, false, classLdr);
        }
        catch (java.lang.ClassNotFoundException className) {
        }
        catch (LinkageError e) {
            e.printStackTrace();
        }
        this.realClass = cls;
    }

    public boolean isActorClass() {
        return this.getQualifiedName().equals(simObj);
    }

    public boolean isWorldClass() {
        return this.getQualifiedName().equals(worldObj);
    }

    public boolean isActorSubclass() {
        return this.isSubclassOf(simObj);
    }

    public boolean isWorldSubclass() {
        return this.isSubclassOf(worldObj);
    }
}

