/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.gui.images;

import greenfoot.gui.images.ImageLibList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageCategorySelector
extends JList
implements ListSelectionListener {
    private ImageLibList imageLibList;
    private static int NUMBER_OF_CATEGORIES = 10;
    private int preferredHeight;

    public ImageCategorySelector(File categoryDir) {
        DefaultListModel<Object> listModel = new DefaultListModel<Object>();
        this.setModel(listModel);
        this.setLayoutOrientation(0);
        this.setSelectionMode(0);
        this.setCellRenderer(new MyCellRenderer());
        this.addListSelectionListener(this);
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File path) {
                return path.isDirectory();
            }
        };
        Object[] imageFiles = categoryDir.listFiles(filter);
        if (imageFiles == null) {
            return;
        }
        Arrays.sort(imageFiles);
        int i = 0;
        while (i < imageFiles.length) {
            listModel.addElement(imageFiles[i]);
            if (i == NUMBER_OF_CATEGORIES - 1) {
                this.preferredHeight = this.getPreferredSize().height;
            }
            ++i;
        }
        if (this.preferredHeight == 0) {
            this.preferredHeight = this.getPreferredSize().height;
        }
    }

    public void setImageLibList(ImageLibList imageLibList) {
        this.imageLibList = imageLibList;
    }

    public File getSelectedDirectory() {
        return (File)this.getSelectedValue();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        File selected;
        if (this.imageLibList != null && (selected = this.getSelectedDirectory()) != null) {
            this.imageLibList.setDirectory(selected);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension d = super.getPreferredScrollableViewportSize();
        Dimension preferredSize = this.getPreferredSize();
        d.height = Math.max(d.height, this.preferredHeight);
        d.width = Math.min(d.width, preferredSize.width);
        return d;
    }

    private static class MyCellRenderer
    extends Box
    implements ListCellRenderer {
        private static final String iconFile = "openRight.png";
        private static final Icon openRightIcon = new ImageIcon(ImageCategorySelector.class.getClassLoader().getResource("openRight.png"));
        private JLabel categoryNameLabel;
        private JLabel iconLabel = new JLabel(openRightIcon);

        public MyCellRenderer() {
            super(0);
            Dimension iconSize = this.iconLabel.getPreferredSize();
            this.iconLabel.setMaximumSize(iconSize);
            this.categoryNameLabel = new JLabel(" ");
            Dimension preferredSize = this.categoryNameLabel.getPreferredSize();
            preferredSize.height = iconSize.height;
            this.categoryNameLabel.setPreferredSize(preferredSize);
            this.add(this.categoryNameLabel);
            this.add(this.iconLabel);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Color foregroundColor;
            Color backgroundColor;
            File entry = (File)value;
            this.categoryNameLabel.setText(entry.getName());
            this.categoryNameLabel.setFont(list.getFont());
            Dimension size = this.categoryNameLabel.getPreferredSize();
            size.width = Integer.MAX_VALUE;
            this.categoryNameLabel.setMaximumSize(size);
            MyCellRenderer item = this;
            if (isSelected) {
                backgroundColor = list.getSelectionBackground();
                foregroundColor = list.getSelectionForeground();
            } else {
                backgroundColor = list.getBackground();
                foregroundColor = list.getForeground();
            }
            this.categoryNameLabel.setBackground(backgroundColor);
            this.categoryNameLabel.setForeground(foregroundColor);
            this.iconLabel.setBackground(backgroundColor);
            this.iconLabel.setForeground(foregroundColor);
            this.categoryNameLabel.setOpaque(isSelected);
            this.iconLabel.setOpaque(isSelected);
            item.setEnabled(list.isEnabled());
            item.setFont(list.getFont());
            item.setOpaque(true);
            return item;
        }
    }
}

