/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.platforms.standalone;

import greenfoot.GreenfootImage;
import greenfoot.UserInfo;
import greenfoot.UserInfoVisitor;
import greenfoot.platforms.GreenfootUtilDelegate;
import greenfoot.util.GreenfootStorageException;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;

public class GreenfootUtilDelegateStandAlone
implements GreenfootUtilDelegate {
    private SocketChannel socket;
    private boolean failedLastConnection;
    private boolean firstStorageException = true;
    private boolean storageStandalone;
    private String storageHost;
    private String storagePort;
    private String storagePasscode;
    private String storageScenarioId;
    private String storageUserId;
    private String storageUserName;

    public GreenfootUtilDelegateStandAlone(boolean storageStandalone, String storageHost, String storagePort, String storagePasscode, String storageScenarioId, String storageUserId, String storageUserName) {
        this.storageStandalone = storageStandalone;
        this.storageHost = storageHost;
        this.storagePort = storagePort;
        this.storagePasscode = storagePasscode;
        this.storageScenarioId = storageScenarioId;
        this.storageUserId = storageUserId;
        this.storageUserName = storageUserName;
    }

    @Override
    public URL getResource(String path) {
        URL res = this.getClass().getClassLoader().getResource(path);
        if (res != null && (res.toString().contains("!") || res.getProtocol().equals("file"))) {
            return res;
        }
        if (path.indexOf(92) != -1) {
            path = path.replace('\\', '/');
            res = this.getClass().getClassLoader().getResource(path);
            if (res != null && res.toString().contains("!")) {
                return res;
            }
        }
        return null;
    }

    @Override
    public Iterable<String> getSoundFiles() {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("soundindex.list");
        ArrayList<String> r = new ArrayList<String>();
        if (is != null) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    r.add(line);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return r;
    }

    @Override
    public String getGreenfootLogoPath() {
        return this.getClass().getClassLoader().getResource("greenfoot.png").toString();
    }

    @Override
    public void displayMessage(Component parent, String messageText) {
        System.err.println(messageText);
    }

    private void closeConnection(Exception e) {
        e.printStackTrace();
        this.socket = null;
        this.failedLastConnection = false;
    }

    @Override
    public boolean isStorageSupported() {
        try {
            this.ensureStorageConnected();
            return this.getCurrentUserInfo() != null;
        }
        catch (GreenfootStorageException e) {
            if (this.firstStorageException) {
                e.printStackTrace();
            }
            this.firstStorageException = false;
            return false;
        }
    }

    private void ensureStorageConnected() throws GreenfootStorageException {
        short port;
        int userId;
        if (this.socket != null && this.socket.isConnected()) {
            return;
        }
        if ((this.socket == null || !this.socket.isConnected()) && this.failedLastConnection) {
            throw new GreenfootStorageException("Already failed to connect to storage server on last attempt");
        }
        if (!this.storageStandalone) {
            throw new GreenfootStorageException("Standalone storage not supported");
        }
        System.err.println("Attempting to reconnect to storage server");
        try {
            userId = Integer.parseInt(this.storageUserId);
            if (userId < 0) {
                throw new GreenfootStorageException("User not logged in");
            }
        }
        catch (NumberFormatException e) {
            throw new GreenfootStorageException("Invalid user ID");
        }
        try {
            port = Short.parseShort(this.storagePort);
        }
        catch (NumberFormatException e) {
            throw new GreenfootStorageException("Error connecting to storage server -- invalid port: " + e.getMessage());
        }
        try {
            if (this.storagePasscode == null) {
                throw new GreenfootStorageException("Could not find passcode to send back to server");
            }
            this.failedLastConnection = true;
            this.socket = SocketChannel.open();
            if (!this.socket.connect(new InetSocketAddress(this.storageHost, (int)port))) {
                this.socket = null;
                throw new GreenfootStorageException("Could not connect to storage server");
            }
            ByteBuffer buffer = this.makeRequest(this.storagePasscode.length() / 2 + 4 + 4);
            int i = 0;
            while (i < this.storagePasscode.length() / 2) {
                byte b = (byte)(0xFF & Short.parseShort(this.storagePasscode.substring(i * 2, i * 2 + 2), 16));
                buffer.put(b);
                ++i;
            }
            try {
                buffer.putInt(Integer.parseInt(this.storageScenarioId));
                buffer.putInt(userId);
            }
            catch (NumberFormatException e) {
                this.socket = null;
                throw new GreenfootStorageException("Invalid scenario ID: " + e.getMessage());
            }
            buffer.flip();
            this.socket.write(buffer);
            this.failedLastConnection = false;
        }
        catch (IOException e) {
            this.socket = null;
            throw new GreenfootStorageException("Error connecting to storage server: " + e.getMessage());
        }
    }

    private ByteBuffer makeRequest(int plusBytes) {
        ByteBuffer buf = ByteBuffer.allocate(4 + plusBytes);
        buf.putInt(plusBytes);
        return buf;
    }

    private void readFullBuffer(ByteBuffer buf, int amount) throws IOException {
        int bytesRead;
        for (int totalBytes = 0; totalBytes < amount; totalBytes += bytesRead) {
            bytesRead = this.socket.read(buf);
            if (bytesRead > 0) {
                continue;
            }
            throw new IOException("Zero or negative bytes read from socket");
        }
        buf.flip();
    }

    private ByteBuffer readResponse() throws IOException {
        ByteBuffer buf = ByteBuffer.allocate(4);
        this.readFullBuffer(buf, 4);
        int size = buf.getInt();
        buf = ByteBuffer.allocate(size);
        this.readFullBuffer(buf, size);
        return buf;
    }

    @Override
    public UserInfo getCurrentUserInfo() {
        ByteBuffer buf;
        block5: {
            this.ensureStorageConnected();
            buf = this.makeRequest(1);
            buf.put((byte)1);
            buf.flip();
            this.socket.write(buf);
            buf = this.readResponse();
            if (1 == buf.getInt()) break block5;
            return null;
        }
        try {
            return this.readLines(buf, 1, true)[0];
        }
        catch (IOException e) {
            this.closeConnection(e);
            return null;
        }
        catch (BufferUnderflowException e) {
            this.closeConnection(e);
            return null;
        }
        catch (GreenfootStorageException e) {
            this.closeConnection(e);
            return null;
        }
    }

    private static String getString(ByteBuffer buf) throws BufferUnderflowException {
        int len = buf.getShort();
        if (len == -1) {
            return null;
        }
        char[] cs = new char[len];
        int i = 0;
        while (i < len) {
            cs[i] = buf.getChar();
            ++i;
        }
        return new String(cs);
    }

    private static void putString(ByteBuffer buf, String value) {
        if (value == null) {
            buf.putShort((short)-1);
        } else {
            buf.putShort((short)value.length());
            int i = 0;
            while (i < value.length()) {
                buf.putChar(value.charAt(i));
                ++i;
            }
        }
    }

    private UserInfo[] readLines(ByteBuffer buf, int numLines, boolean useSingleton) throws BufferUnderflowException {
        int numInts = buf.getInt();
        int numStrings = buf.getInt();
        UserInfo[] r = new UserInfo[numLines];
        int line = 0;
        while (line < numLines) {
            String userName = GreenfootUtilDelegateStandAlone.getString(buf);
            int score = buf.getInt();
            int rank = buf.getInt();
            r[line] = UserInfoVisitor.allocate(userName, rank, useSingleton ? this.getUserName() : null);
            r[line].setScore(score);
            int i = 0;
            while (i < numInts) {
                int x = buf.getInt();
                if (i < 10) {
                    r[line].setInt(i, x);
                }
                ++i;
            }
            i = 0;
            while (i < numStrings) {
                String s = GreenfootUtilDelegateStandAlone.getString(buf);
                if (i < 5) {
                    r[line].setString(i, s);
                }
                ++i;
            }
            ++line;
        }
        return r;
    }

    @Override
    public boolean storeCurrentUserInfo(UserInfo data) {
        try {
            this.ensureStorageConnected();
            int payloadLength = 0;
            payloadLength += 52;
            int i = 0;
            while (i < 5) {
                payloadLength += GreenfootUtilDelegateStandAlone.stringSize(data.getString(i));
                ++i;
            }
            ByteBuffer buf = this.makeRequest(1 + payloadLength);
            buf.put((byte)2);
            buf.putInt(data.getScore());
            buf.putInt(10);
            buf.putInt(5);
            int i2 = 0;
            while (i2 < 10) {
                buf.putInt(data.getInt(i2));
                ++i2;
            }
            i2 = 0;
            while (i2 < 5) {
                GreenfootUtilDelegateStandAlone.putString(buf, data.getString(i2));
                ++i2;
            }
            buf.flip();
            this.socket.write(buf);
            buf = this.readResponse();
            byte code = buf.get();
            if (code != 0) {
                throw new GreenfootStorageException("Error storing data, code: " + Byte.toString(code));
            }
            return true;
        }
        catch (IOException e) {
            this.closeConnection(e);
            return false;
        }
        catch (BufferUnderflowException e) {
            this.closeConnection(e);
            return false;
        }
        catch (GreenfootStorageException e) {
            this.closeConnection(e);
            return false;
        }
    }

    private static int stringSize(String string) {
        if (string == null) {
            return 2;
        }
        return 2 + 2 * string.length();
    }

    @Override
    public List<UserInfo> getTopUserInfo(int limit) {
        try {
            this.ensureStorageConnected();
            ByteBuffer buf = this.makeRequest(5);
            buf.put((byte)3);
            buf.putInt(limit);
            buf.flip();
            this.socket.write(buf);
            buf = this.readResponse();
            int numUsers = buf.getInt();
            UserInfo[] storage = this.readLines(buf, numUsers, false);
            ArrayList<UserInfo> r = new ArrayList<UserInfo>();
            UserInfo[] userInfoArray = storage;
            int n = storage.length;
            int n2 = 0;
            while (n2 < n) {
                UserInfo s = userInfoArray[n2];
                r.add(s);
                ++n2;
            }
            return r;
        }
        catch (IOException e) {
            this.closeConnection(e);
            return null;
        }
        catch (BufferUnderflowException e) {
            this.closeConnection(e);
            return null;
        }
        catch (GreenfootStorageException e) {
            this.closeConnection(e);
            return null;
        }
    }

    @Override
    public List<UserInfo> getNearbyUserInfo(int limit) {
        int numUsers;
        ByteBuffer buf;
        block6: {
            this.ensureStorageConnected();
            buf = this.makeRequest(5);
            buf.put((byte)5);
            buf.putInt(limit);
            buf.flip();
            this.socket.write(buf);
            buf = this.readResponse();
            numUsers = buf.getInt();
            if (numUsers >= 0) break block6;
            return null;
        }
        try {
            UserInfo[] storage = this.readLines(buf, numUsers, false);
            ArrayList<UserInfo> r = new ArrayList<UserInfo>();
            UserInfo[] userInfoArray = storage;
            int n = storage.length;
            int n2 = 0;
            while (n2 < n) {
                UserInfo s = userInfoArray[n2];
                r.add(s);
                ++n2;
            }
            return r;
        }
        catch (IOException e) {
            this.closeConnection(e);
            return null;
        }
        catch (BufferUnderflowException e) {
            this.closeConnection(e);
            return null;
        }
        catch (GreenfootStorageException e) {
            this.closeConnection(e);
            return null;
        }
    }

    @Override
    public GreenfootImage getUserImage(String userName) {
        if (userName == null || userName.equals("")) {
            userName = this.storageUserName;
        }
        try {
            this.ensureStorageConnected();
            ByteBuffer buf = this.makeRequest(3 + 2 * userName.length());
            buf.put((byte)4);
            GreenfootUtilDelegateStandAlone.putString(buf, userName);
            buf.flip();
            this.socket.write(buf);
            buf = this.readResponse();
            int numBytes = buf.getInt();
            byte[] fileData = new byte[numBytes];
            buf.get(fileData);
            try {
                return UserInfoVisitor.readImage(fileData);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        catch (IOException e) {
            this.closeConnection(e);
            return null;
        }
        catch (GreenfootStorageException e) {
            this.closeConnection(e);
            return null;
        }
    }

    @Override
    public String getUserName() {
        return this.storageUserName;
    }
}

