/*
 * Decompiled with CFR 0.152.
 */
package greenfoot.util;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class ShadowRenderer {
    public static BufferedImage createDropShadow(BufferedImage image, int size, float opacity, Color color) {
        BufferedImage shadow = new BufferedImage(image.getWidth() + 4 * size, image.getHeight() + 4 * size, 2);
        Graphics2D g2 = shadow.createGraphics();
        g2.drawImage((Image)image, size * 2, size * 2, null);
        g2.setComposite(AlphaComposite.SrcIn);
        g2.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), (int)(255.0f * opacity)));
        g2.fillRect(0, 0, shadow.getWidth(), shadow.getHeight());
        g2.dispose();
        shadow = ShadowRenderer.getGaussianBlurFilter(size, true).filter(shadow, null);
        shadow = ShadowRenderer.getGaussianBlurFilter(size, false).filter(shadow, null);
        return shadow;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }
}

