/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.collect.DataCollector;
import bluej.compiler.CompileObserver;
import bluej.compiler.Diagnostic;
import bluej.compiler.EventqueueCompileObserver;
import bluej.compiler.JobQueue;
import bluej.debugger.Debugger;
import bluej.debugger.DebuggerObject;
import bluej.debugger.DebuggerResult;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.gentype.GenTypeParameter;
import bluej.debugger.gentype.JavaType;
import bluej.debugger.gentype.NameTransform;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallDialogWatcher;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.ConstructorDialog;
import bluej.debugmgr.InvokerCompiler;
import bluej.debugmgr.MethodDialog;
import bluej.debugmgr.NamedValue;
import bluej.debugmgr.ResultWatcher;
import bluej.debugmgr.ValueCollection;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.pkgmgr.Project;
import bluej.runtime.Shell;
import bluej.testmgr.record.ConstructionInvokerRecord;
import bluej.testmgr.record.ExpressionInvokerRecord;
import bluej.testmgr.record.InvokerRecord;
import bluej.testmgr.record.MethodInvokerRecord;
import bluej.testmgr.record.StatementInvokerRecord;
import bluej.testmgr.record.VoidMethodInvokerRecord;
import bluej.utility.Debug;
import bluej.utility.DialogManager;
import bluej.utility.JavaNames;
import bluej.utility.Utility;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.MethodView;
import java.awt.Component;
import java.awt.EventQueue;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JFrame;

public class Invoker
implements CompileObserver,
CallDialogWatcher {
    public static final int OBJ_NAME_LENGTH = 8;
    public static final String SHELLNAME = "__SHELL";
    private static int shellNumber = 0;
    private static Map<MethodView, MethodDialog> methods = new HashMap<MethodView, MethodDialog>();
    private static Map<ConstructorView, ConstructorDialog> constructors = new HashMap<ConstructorView, ConstructorDialog>();
    private JFrame pmf;
    private Package pkg;
    private boolean codepad;
    private File pkgPath;
    private String pkgName;
    private String pkgScopeId;
    private CallHistory callHistory;
    private ResultWatcher watcher;
    private CallableView member;
    private String shellName;
    private String objName;
    private String benchName;
    private Map<String, GenTypeParameter> typeMap;
    private ValueCollection localVars;
    private ValueCollection objectBenchVars;
    private ObjectBenchInterface objectBench;
    private Debugger debugger;
    private String imports;
    private NameTransform nameTransform;
    private InvokerCompiler compiler;
    private Charset sourceCharset;
    private String instanceName;
    private CallDialog dialog;
    private boolean constructing;
    private String commandString;
    private InvokerRecord ir;
    private boolean gotError;

    private static final synchronized String getShellName() {
        return SHELLNAME + shellNumber++;
    }

    public Invoker(JFrame frame, CallableView member, ResultWatcher watcher, File pkgPath, String pkgName, String pkgScopeId, CallHistory callHistory, ValueCollection objectBenchVars, ObjectBenchInterface objectBench, Debugger debugger, InvokerCompiler compiler, String instanceName, Charset sourceCharset) {
        this.pmf = frame;
        this.member = member;
        this.watcher = watcher;
        if (member instanceof ConstructorView) {
            this.objName = member.getClassName().toLowerCase();
            this.constructing = true;
        } else if (member instanceof MethodView) {
            this.constructing = false;
        }
        this.instanceName = instanceName;
        this.pkgPath = pkgPath;
        this.pkgName = pkgName;
        this.pkgScopeId = pkgScopeId;
        this.callHistory = callHistory;
        this.objectBenchVars = objectBenchVars;
        this.objectBench = objectBench;
        this.debugger = debugger;
        this.nameTransform = new NameTransform(){

            @Override
            public String transform(String typeName) {
                return typeName;
            }
        };
        this.compiler = compiler;
        this.shellName = Invoker.getShellName();
        this.sourceCharset = sourceCharset;
    }

    public Invoker(PkgMgrFrame pmf, ValueCollection localVars, String command, ResultWatcher watcher) {
        this.initialize(pmf);
        this.watcher = watcher;
        this.member = null;
        this.shellName = Invoker.getShellName();
        this.objName = null;
        this.instanceName = null;
        this.localVars = localVars;
        this.constructing = false;
        this.codepad = true;
        this.commandString = command;
    }

    public Invoker(PkgMgrFrame pmf, CallableView member, ResultWatcher watcher) {
        this.initialize(pmf);
        this.member = member;
        this.watcher = watcher;
        this.shellName = Invoker.getShellName();
        this.codepad = false;
        if (member instanceof ConstructorView) {
            this.benchName = this.objName = pmf.getProject().getDebugger().guessNewName(member.getClassName());
            this.constructing = true;
        } else if (member instanceof MethodView) {
            this.constructing = false;
        } else {
            Debug.reportError("illegal member type in invocation");
            throw new IllegalArgumentException("Unknown callable type");
        }
    }

    public Invoker(PkgMgrFrame pmf, MethodView member, ObjectWrapper objWrapper, ResultWatcher watcher) {
        this.initialize(pmf);
        this.member = member;
        this.watcher = watcher;
        this.shellName = Invoker.getShellName();
        this.codepad = false;
        this.instanceName = objWrapper.getName();
        this.typeMap = objWrapper.getObject().getGenType().mapToSuper(member.getClassName()).getMap();
        this.constructing = false;
    }

    private void initialize(PkgMgrFrame pmf) {
        this.pmf = pmf;
        this.pkg = pmf.getPackage();
        final Package pkg = pmf.getPackage();
        this.pkgPath = pkg.getPath();
        this.pkgName = pkg.getQualifiedName();
        this.pkgScopeId = pkg.getId();
        this.callHistory = pkg.getCallHistory();
        this.objectBenchVars = pmf.getObjectBench();
        this.objectBench = pmf.getObjectBench();
        this.debugger = pkg.getProject().getDebugger();
        this.nameTransform = new CleverQualifyTypeNameTransform(pkg);
        this.compiler = new InvokerCompiler(){

            @Override
            public void compile(File[] files, CompileObserver observer) {
                Project project = pkg.getProject();
                JobQueue.getJobQueue().addJob(files, observer, project.getClassLoader(), project.getProjectDir(), true, project.getProjectCharset());
            }
        };
        this.sourceCharset = pmf.getProject().getProjectCharset();
    }

    public void setImports(String importStatements) {
        this.imports = importStatements;
    }

    public void invokeInteractive() {
        this.gotError = false;
        if (!(this.constructing && !Config.isGreenfoot() || this.member.hasParameters())) {
            this.dialog = null;
            this.doInvocation(null, (JavaType[])null, null);
        } else {
            CallDialog cDialog;
            if (this.member instanceof MethodView) {
                MethodView mmember = (MethodView)this.member;
                MethodDialog mDialog = methods.get(this.member);
                if (mDialog == null) {
                    mDialog = new MethodDialog(this.pmf, this.objectBench, this.callHistory, this.instanceName, mmember, this.typeMap);
                    methods.put(mmember, mDialog);
                } else {
                    mDialog.setInstanceInfo(this.instanceName, this.typeMap);
                    mDialog.setCallLabel(mmember.isStatic() ? mmember.getClassName() : this.instanceName);
                }
                cDialog = mDialog;
            } else {
                ConstructorView cmember = (ConstructorView)this.member;
                ConstructorDialog conDialog = constructors.get(cmember);
                if (conDialog == null) {
                    conDialog = new ConstructorDialog(this.pmf, this.objectBench, this.callHistory, this.objName, cmember);
                    constructors.put(cmember, conDialog);
                } else {
                    conDialog.setInstanceInfo(this.objName);
                }
                cDialog = conDialog;
            }
            cDialog.setVisible(true);
            ((Component)cDialog).setEnabled(true);
            cDialog.setWatcher(this);
            this.dialog = cDialog;
        }
    }

    @Override
    public void callDialogEvent(CallDialog dlg, int event) {
        if (event == 1) {
            dlg.setVisible(false);
        } else if (event == 0) {
            this.gotError = false;
            this.dialog.setEnabled(false);
            this.benchName = this.objName = this.dialog.getNewInstanceName();
            String[] actualTypeParams = this.dialog.getTypeParams();
            this.doInvocation(this.dialog.getArgs(), this.dialog.getArgGenTypes(true), actualTypeParams);
        } else {
            Debug.reportError("Invoker: Unknown CallDialog event");
        }
    }

    public void invokeDirect(String[] params) {
        this.gotError = false;
        JavaType[] argTypes = this.member.getParamTypes(false);
        for (int i = 0; i < argTypes.length; ++i) {
            argTypes[i] = argTypes[i].mapTparsToTypes(this.typeMap).getUpperBound();
        }
        this.doInvocation(params, argTypes, null);
    }

    protected void doInvocation(String[] args, JavaType[] argTypes, String[] typeParams) {
        this.gotError = false;
        int numArgs = args == null ? 0 : args.length;
        String[] argTypeStrings = argTypes != null ? new String[argTypes.length] : null;
        if (!this.member.isGeneric() || this.member.isConstructor()) {
            for (int i = 0; i < numArgs; ++i) {
                JavaType argType = argTypes[i];
                argTypeStrings[i] = argType.toString(this.nameTransform);
            }
        }
        this.doInvocation(args, argTypeStrings, typeParams);
    }

    private void doInvocation(String[] args, String[] argTypes, String[] typeParams) {
        String command;
        int numArgs = args == null ? 0 : args.length;
        final String className = this.member.getClassName();
        boolean isGenericMethod = this.member.isGeneric() && !this.member.isConstructor();
        StringBuffer buffer = new StringBuffer();
        if (!isGenericMethod) {
            for (int i = 0; i < numArgs; ++i) {
                buffer.append(argTypes[i]);
                buffer.append(" __bluej_param" + i);
                buffer.append(" = " + args[i]);
                buffer.append(";" + Config.nl);
            }
        }
        String paramInit = buffer.toString();
        buffer.setLength(0);
        StringBuffer argBuffer = new StringBuffer();
        this.buildArgStrings(buffer, argBuffer, args);
        String argString = buffer.toString();
        String actualArgString = argBuffer.toString();
        if (isGenericMethod) {
            argString = actualArgString;
        }
        buffer.setLength(0);
        boolean isVoid = false;
        String constype = null;
        if (this.constructing) {
            constype = this.nameTransform.transform(className);
            if (typeParams != null && typeParams.length > 0) {
                constype = constype + "<";
                for (int i = 0; i < typeParams.length; ++i) {
                    String typeParam = typeParams[i];
                    constype = constype + typeParam;
                    if (i >= typeParams.length - 1) continue;
                    constype = constype + ",";
                }
                constype = constype + ">";
            }
            command = "new " + constype;
            this.ir = new ConstructionInvokerRecord(constype, this.objName, command + actualArgString, args);
        } else {
            MethodView method = (MethodView)this.member;
            isVoid = method.isVoid();
            command = method.isStatic() ? this.nameTransform.transform(className) + "." + method.getName() : this.instanceName + "." + method.getName();
            if (isVoid) {
                this.ir = new VoidMethodInvokerRecord(command + actualArgString, args);
                this.objName = null;
            } else {
                this.ir = new MethodInvokerRecord(method.getGenericReturnType(), command + actualArgString, args);
                this.objName = "result";
            }
        }
        if (this.constructing && this.member.getParameterCount() == 0 && (typeParams == null || typeParams.length == 0)) {
            this.commandString = command + actualArgString;
            this.watcher.beginCompile();
            this.watcher.beginExecution(this.ir);
            new Thread(){

                @Override
                public void run() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Invoker.this.closeCallDialog();
                        }
                    });
                    final DebuggerResult result = Invoker.this.debugger.instantiateClass(className);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Invoker.this.handleResult(result, false);
                        }
                    });
                }
            }.start();
        } else {
            if (isVoid) {
                argString = argString + ';';
            }
            this.watcher.beginCompile();
            File shell = this.writeInvocationFile(paramInit, command + argString, isVoid, constype);
            if (shell != null) {
                this.commandString = command + actualArgString;
                this.compileInvocationFile(shell);
            } else {
                this.endCompile(new File[0], false);
            }
        }
    }

    protected void buildArgStrings(StringBuffer buffer, StringBuffer argBuffer, String[] args) {
        int numArgs = args == null ? 0 : args.length;
        buffer.append("(");
        argBuffer.append("(");
        if (numArgs > 0) {
            buffer.append("__bluej_param0");
            argBuffer.append(args[0]);
        }
        for (int i = 1; i < numArgs; ++i) {
            buffer.append(",__bluej_param" + i);
            argBuffer.append(", ");
            argBuffer.append(args[i]);
        }
        buffer.append(")");
        argBuffer.append(")");
    }

    public boolean doFreeFormInvocation(String resultType) {
        boolean hasResult;
        this.gotError = false;
        boolean bl = hasResult = resultType != null;
        if (hasResult) {
            if (resultType.equals("")) {
                resultType = null;
            }
            this.objName = "result";
            this.ir = new ExpressionInvokerRecord(this.commandString);
        } else {
            this.objName = null;
            this.ir = new StatementInvokerRecord(this.commandString);
        }
        File shell = this.writeInvocationFile("", this.commandString, !hasResult, resultType);
        if (shell != null) {
            this.compileInvocationFile(shell);
            return true;
        }
        return false;
    }

    private File writeInvocationFile(String paramInit, String callString, boolean isVoid, String constype) {
        String packageLine = this.pkgName.length() == 0 ? "" : "package " + this.pkgName + ";";
        StringBuffer buffer = new StringBuffer();
        String scopeId = Utility.quoteString(this.pkgScopeId);
        Iterator<? extends NamedValue> wrappers = this.objectBenchVars.getValueIterator();
        HashMap<String, String> objBenchVarsMap = new HashMap<String, String>();
        if (wrappers.hasNext() || this.localVars != null) {
            buffer.append("final bluej.runtime.BJMap __bluej_runtime_scope = getScope(\"" + scopeId + "\");" + Config.nl);
            while (wrappers.hasNext()) {
                NamedValue objBenchVar = wrappers.next();
                objBenchVarsMap.put(objBenchVar.getName(), this.getVarDeclString("", false, objBenchVar, this.nameTransform));
            }
        }
        if (this.localVars != null && constype == null) {
            Iterator<? extends NamedValue> i = this.localVars.getValueIterator();
            while (i.hasNext()) {
                NamedValue localVar = i.next();
                objBenchVarsMap.put(localVar.getName(), this.getVarDeclString("lv:", false, localVar, this.nameTransform));
            }
        }
        Iterator obVarsIterator = objBenchVarsMap.values().iterator();
        while (obVarsIterator.hasNext()) {
            buffer.append(((String)obVarsIterator.next()).toString());
        }
        String vardecl = buffer.toString();
        buffer.setLength(0);
        if (!isVoid) {
            if (constype == null) {
                buffer.append(paramInit);
                buffer.append("try {" + Config.nl);
                buffer.append("return makeObj(");
            } else {
                buffer.append("return new java.lang.Object() { ");
                buffer.append(constype + " result;" + Config.nl);
                buffer.append("{ ");
                buffer.append(paramInit);
                if (this.localVars != null) {
                    this.writeVariables("lv:", buffer, false, this.localVars.getValueIterator(), this.nameTransform);
                }
                buffer.append("try {" + Config.nl);
                buffer.append("result=(");
            }
            buffer.append(callString);
            buffer.append(Config.nl);
            buffer.append(");}");
            buffer.append(Config.nl);
            buffer.append("finally {" + Config.nl);
        } else {
            buffer.append(paramInit);
            buffer.append(callString);
            buffer.append(Config.nl);
        }
        String invocation = buffer.toString();
        buffer = new StringBuffer();
        if (this.localVars != null) {
            Iterator<? extends NamedValue> i = this.localVars.getValueIterator();
            while (i.hasNext()) {
                NamedValue wrapper = i.next();
                if (wrapper.isFinal() && wrapper.isInitialized()) continue;
                String instname = wrapper.getName();
                buffer.append("__bluej_runtime_scope.put(\"lv:" + instname + "\", ");
                this.wrapValue(buffer, instname, wrapper.getGenType());
                buffer.append(");" + Config.nl);
            }
        }
        String scopeSave = buffer.toString();
        File shellFile = new File(this.pkgPath, this.shellName + ".java");
        BufferedWriter shell = null;
        try {
            FileOutputStream fos = new FileOutputStream(shellFile);
            shell = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, this.sourceCharset));
            shell.write(packageLine);
            shell.newLine();
            if (this.imports != null) {
                shell.write(this.imports);
                shell.newLine();
            }
            shell.write("public class ");
            shell.write(this.shellName);
            shell.write(" extends bluej.runtime.Shell {");
            shell.newLine();
            shell.write("public static ");
            if (isVoid) {
                shell.write("void");
            } else {
                shell.write("java.lang.Object");
            }
            shell.write(" run() throws Throwable {");
            shell.newLine();
            shell.write(vardecl);
            shell.newLine();
            shell.write(invocation);
            shell.write(scopeSave);
            if (!isVoid) {
                shell.write("}");
                if (constype != null) {
                    shell.write("} };");
                }
            }
            shell.newLine();
            shell.write("}}");
            shell.newLine();
            shell.close();
        }
        catch (IOException e) {
            DialogManager.showError(this.pmf, "could-not-write-shell-file");
            if (shell != null) {
                try {
                    shell.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            shellFile.delete();
            return null;
        }
        return shellFile;
    }

    private void writeVariables(String scopePx, StringBuffer buffer, boolean isStatic, Iterator<?> i, NameTransform nt) {
        while (i.hasNext()) {
            NamedValue wrapper = (NamedValue)i.next();
            if (!wrapper.isInitialized()) continue;
            String type = wrapper.getGenType().toString(nt);
            String instname = wrapper.getName();
            if (wrapper.isFinal()) {
                buffer.append("final ");
            }
            if (isStatic) {
                buffer.append("static ");
            }
            buffer.append(type);
            buffer.append(" " + instname + " = ");
            this.extractValue(buffer, scopePx, instname, wrapper.getGenType(), type);
            buffer.append(Config.nl);
        }
    }

    private String getVarDeclString(String scopePx, boolean isStatic, NamedValue wrapper, NameTransform nt) {
        if (wrapper.isInitialized()) {
            String type = wrapper.getGenType().toString(nt);
            String instname = wrapper.getName();
            StringBuffer buffer = new StringBuffer();
            if (wrapper.isFinal()) {
                buffer.append("final ");
            }
            if (isStatic) {
                buffer.append("static ");
            }
            buffer.append(type);
            buffer.append(" " + instname + " = ");
            this.extractValue(buffer, scopePx, instname, wrapper.getGenType(), type);
            buffer.append(Config.nl);
            return buffer.toString();
        }
        return "";
    }

    private void extractValue(StringBuffer buffer, String scopePx, String instname, JavaType type, String typeStr) {
        if (type.isPrimitive()) {
            String extractMethod;
            String castType;
            if (type.typeIs(JavaType.JT_BOOLEAN)) {
                castType = "java.lang.Boolean";
                extractMethod = "booleanValue";
            } else if (type.typeIs(JavaType.JT_CHAR)) {
                castType = "java.lang.Character";
                extractMethod = "charValue";
            } else if (type.typeIs(JavaType.JT_BYTE)) {
                castType = "java.lang.Byte";
                extractMethod = "byteValue";
            } else if (type.typeIs(JavaType.JT_SHORT)) {
                castType = "java.lang.Short";
                extractMethod = "shortValue";
            } else if (type.typeIs(JavaType.JT_INT)) {
                castType = "java.lang.Integer";
                extractMethod = "intValue";
            } else if (type.typeIs(JavaType.JT_LONG)) {
                castType = "java.lang.Long";
                extractMethod = "longValue";
            } else if (type.typeIs(JavaType.JT_FLOAT)) {
                castType = "java.lang.Float";
                extractMethod = "floatValue";
            } else if (type.typeIs(JavaType.JT_DOUBLE)) {
                castType = "java.lang.Double";
                extractMethod = "doubleValue";
            } else {
                throw new UnsupportedOperationException("unhandled primitive type");
            }
            buffer.append("((" + castType + ")__bluej_runtime_scope.get(\"");
            buffer.append(scopePx + instname + "\"))." + extractMethod + "();");
        } else {
            buffer.append("(" + typeStr);
            buffer.append(")__bluej_runtime_scope.get(\"");
            buffer.append(scopePx + instname + "\");" + Config.nl);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void wrapValue(StringBuffer buffer, String name, JavaType type) {
        if (type.isPrimitive()) {
            if (type.typeIs(JavaType.JT_BOOLEAN)) {
                buffer.append("java.lang.Boolean.valueOf(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_BYTE)) {
                buffer.append("new java.lang.Byte(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_CHAR)) {
                buffer.append("new java.lang.Character(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_DOUBLE)) {
                buffer.append("new java.lang.Double(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_FLOAT)) {
                buffer.append("new java.lang.Float(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_LONG)) {
                buffer.append("new java.lang.Long(" + name + ")");
                return;
            } else if (type.typeIs(JavaType.JT_INT)) {
                buffer.append("new java.lang.Integer(" + name + ")");
                return;
            } else {
                if (!type.typeIs(JavaType.JT_SHORT)) throw new UnsupportedOperationException("unhandled primitive type.");
                buffer.append("new java.lang.Short(" + name + ")");
            }
            return;
        } else {
            buffer.append(name);
        }
    }

    private void compileInvocationFile(File shellFile) {
        File[] files = new File[]{shellFile};
        this.compiler.compile(files, new EventqueueCompileObserver(this));
    }

    @Override
    public void startCompile(File[] sources) {
    }

    @Override
    public boolean compilerMessage(Diagnostic diagnostic) {
        if (diagnostic.getType() == Diagnostic.ERROR && !this.gotError) {
            this.gotError = true;
            this.errorMessage(diagnostic.getFileName(), diagnostic.getStartLine(), diagnostic.getMessage());
            return true;
        }
        return false;
    }

    private void errorMessage(String filename, long lineNo, String message) {
        DataCollector.invokeCompileError(this.pkg, this.commandString, message);
        if (this.dialog != null) {
            this.dialog.setErrorMessage("Error: " + message);
        }
        this.watcher.putError(message, this.ir);
    }

    @Override
    public synchronized void endCompile(File[] sources, boolean successful) {
        if (this.dialog != null) {
            this.dialog.setWaitCursor(false);
            if (successful) {
                this.closeCallDialog();
            }
        }
        if (successful) {
            this.watcher.beginExecution(this.ir);
            this.startClass();
        } else {
            this.finishCall(false);
        }
    }

    private void finishCall(boolean successful) {
        this.deleteShellFiles();
        if (!successful && this.dialog != null) {
            this.dialog.setEnabled(true);
        }
    }

    private void closeCallDialog() {
        if (this.dialog != null) {
            this.dialog.setWaitCursor(false);
            this.dialog.setVisible(false);
            if (Config.isWinOS()) {
                this.dialog.dispose();
            }
            this.dialog.updateParameters();
        }
    }

    private void deleteShellFiles() {
        String[] innerClassFiles;
        File srcFile = new File(this.pkgPath, this.shellName + ".java");
        srcFile.delete();
        File classFile = new File(this.pkgPath, this.shellName + ".class");
        classFile.delete();
        for (String innerClassFile : innerClassFiles = this.pkgPath.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(Invoker.this.shellName + "$");
            }
        })) {
            new File(this.pkgPath, innerClassFile).delete();
        }
    }

    private void startClass() {
        final String shellClassName = JavaNames.combineNames(this.pkgName, this.shellName);
        new Thread(){

            @Override
            public void run() {
                try {
                    final DebuggerResult result = Invoker.this.debugger.runClassMain(shellClassName);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Invoker.this.handleResult(result, Invoker.this.constructing);
                            Invoker.this.finishCall(true);
                        }
                    });
                }
                catch (Throwable e) {
                    e.printStackTrace(System.err);
                }
            }
        }.start();
    }

    public void handleResult(DebuggerResult result, boolean unwrap) {
        try {
            int status = result.getExitStatus();
            switch (status) {
                case 0: {
                    DebuggerObject resultObj = result.getResultObject();
                    if (unwrap) {
                        resultObj = resultObj.getInstanceField(0).getValueObject(null);
                    }
                    if (!this.codepad) {
                        String resultType;
                        if (resultObj.getClassName().startsWith(Shell.class.getCanonicalName())) {
                            resultType = resultObj.getInstanceField(0).getType().isPrimitive() ? resultObj.getInstanceField(0).getType().toString() : resultObj.getInstanceField(0).getValueObject(null).getClassName();
                        } else {
                            resultType = resultObj.getClassName();
                            if (resultType.equals("")) {
                                resultType = "void";
                            }
                        }
                        PkgMgrFrame pmf = PkgMgrFrame.findFrame(this.pkg);
                        DataCollector.invokeMethodSuccess(this.pkg, this.commandString, this.benchName, resultType, pmf == null ? -1 : pmf.getTestIdentifier(), this.ir.getUniqueIdentifier());
                    }
                    this.ir.setResultObject(resultObj);
                    this.watcher.putResult(resultObj, this.objName, this.ir);
                    break;
                }
                case 2: {
                    ExceptionDescription exc = result.getException();
                    if (!this.codepad) {
                        DataCollector.invokeMethodException(this.pkg, this.commandString, exc);
                    }
                    this.watcher.putException(exc, this.ir);
                    break;
                }
                case 3: {
                    if (!this.codepad) {
                        DataCollector.invokeMethodTerminated(this.pkg, this.commandString);
                    }
                    this.watcher.putVMTerminated(this.ir);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
    }

    private static String cleverQualifyTypeName(Package p, String typeName) {
        int firstDollar;
        if (!p.isUnnamedPackage()) {
            String pkgName = p.getQualifiedName();
            int firstDot = pkgName.indexOf(".");
            if (firstDot >= 0) {
                pkgName = pkgName.substring(0, firstDot);
            }
            if (p.getTarget(pkgName) != null) {
                typeName = JavaNames.getBase(typeName);
            }
        }
        if ((firstDollar = typeName.indexOf(36)) != -1) {
            StringBuffer sb = new StringBuffer(typeName);
            for (int i = firstDollar; i < sb.length() - 1; ++i) {
                if (sb.charAt(i) != '$' || Character.isDigit(sb.charAt(i + 1))) continue;
                sb.setCharAt(i, '.');
            }
            typeName = sb.toString();
        }
        return JavaNames.typeName(typeName);
    }

    static class CleverQualifyTypeNameTransform
    implements NameTransform {
        Package mypackage;

        public CleverQualifyTypeNameTransform(Package p) {
            this.mypackage = p;
        }

        @Override
        public String transform(String n) {
            return Invoker.cleverQualifyTypeName(this.mypackage, n);
        }
    }
}

