/*
 * Decompiled with CFR 0.152.
 */
package bluej.groupwork.cvsnb;

import bluej.utility.Debug;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.InteractiveCallback;
import com.trilead.ssh2.Session;
import java.io.IOException;
import javax.net.SocketFactory;
import org.netbeans.lib.cvsclient.command.CommandAbortedException;
import org.netbeans.lib.cvsclient.connection.AbstractConnection;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.connection.ConnectionModifier;
import org.netbeans.lib.cvsclient.util.LoggedDataInputStream;
import org.netbeans.lib.cvsclient.util.LoggedDataOutputStream;

public class GSSHConnection
extends AbstractConnection {
    private static final String CVS_SERVER_COMMAND = System.getProperty("Env-CVS_SERVER", "cvs") + " server";
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private Session session;
    private Connection connection;

    public GSSHConnection(SocketFactory socketFactory, String host, int port, String username, String password) {
        this.host = host;
        this.port = port;
        this.username = username != null ? username : System.getProperty("user.name");
        this.password = password;
    }

    public void open() throws AuthenticationException, CommandAbortedException {
        try {
            this.connection = new Connection(this.host, this.port);
            this.connection.connect(null, 20000, 20000);
            boolean isPwAvailable = this.connection.isAuthMethodAvailable(this.username, "password");
            boolean isKIAvailable = this.connection.isAuthMethodAvailable(this.username, "keyboard-interactive");
            boolean auth = false;
            if (isPwAvailable) {
                auth = this.connection.authenticateWithPassword(this.username, this.password);
            }
            if (!auth && isKIAvailable) {
                auth = this.connection.authenticateWithKeyboardInteractive(this.username, new InteractiveCallback(){

                    public String[] replyToChallenge(String name, String instruction, int numPrompts, String[] prompt, boolean[] echo) throws Exception {
                        String[] result = new String[numPrompts];
                        for (int i = 0; i < numPrompts; ++i) {
                            result[i] = GSSHConnection.this.password;
                        }
                        return result;
                    }
                });
            }
            if (!auth) {
                String msg = "SSH authentication failed: Wrong username/password?";
                this.reset();
                throw new AuthenticationException(msg, msg);
            }
            this.session = this.connection.openSession();
            this.session.execCommand(CVS_SERVER_COMMAND);
            this.setInputStream(new LoggedDataInputStream(this.session.getStdout()));
            this.setOutputStream(new LoggedDataOutputStream(this.session.getStdin()));
        }
        catch (IOException ioe) {
            Debug.message("SSH connection: " + ioe.getMessage());
            this.reset();
            throw new AuthenticationException((Throwable)ioe, "SSH connection failure");
        }
    }

    public void verify() throws AuthenticationException {
        try {
            this.open();
            this.close();
        }
        catch (CommandAbortedException e) {
            throw new AuthenticationException(CVS_SERVER_COMMAND, "CommandAbortedException");
        }
        catch (IOException e) {
            throw new AuthenticationException(CVS_SERVER_COMMAND, "IOException");
        }
        finally {
            this.reset();
        }
    }

    private void reset() {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
        this.setInputStream(null);
        this.setOutputStream(null);
    }

    public void close() throws IOException {
        this.reset();
    }

    public boolean isOpen() {
        return this.session != null;
    }

    public int getPort() {
        return this.port;
    }

    public void modifyInputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyInputStream(this.getInputStream());
    }

    public void modifyOutputStream(ConnectionModifier modifier) throws IOException {
        modifier.modifyOutputStream(this.getOutputStream());
    }
}

