/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.MoeEditor;
import bluej.editor.moe.MoeEditorManager;
import bluej.prefmgr.PrefMgr;
import bluej.utility.BlueJFileReader;
import bluej.utility.DialogManager;
import bluej.utility.Utility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class Info
extends JPanel
implements ActionListener {
    static final ImageIcon helpImage = Config.getFixedImageAsIcon((String)"help.png");
    private static Font infoFont = new Font("SansSerif", 1, PrefMgr.getEditorFontSize() - 1);
    private JLabel line1;
    private JLabel line2;
    String originalMsg;
    boolean isClear;
    JButton helpButton;
    String helpGroup;

    public Info() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        JPanel body = new JPanel(new GridLayout(0, 1));
        body.setBackground(MoeEditor.infoColor);
        body.setBorder(new EmptyBorder(0, 6, 0, 4));
        this.line1 = new JLabel(){

            @Override
            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                if (Info.this.originalMsg != null) {
                    Info.this.rebreakLine();
                }
            }
        };
        this.line2 = new JLabel();
        body.add(this.line1);
        body.add(this.line2);
        if (!Config.isRaspberryPi()) {
            body.setOpaque(false);
        }
        this.add((Component)body, "Center");
        this.helpButton = new JButton(helpImage);
        if (!Config.isMacOS()) {
            this.helpButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            Utility.changeToMacButton((AbstractButton)this.helpButton);
        }
        this.helpButton.addActionListener(this);
        this.helpButton.setRequestFocusEnabled(false);
        this.add((Component)this.helpButton, "East");
        this.helpButton.setVisible(false);
        this.isClear = true;
        this.helpGroup = "";
        this.refresh();
    }

    public static void resetFont() {
        int fsize = Math.max(PrefMgr.getEditorFontSize() - 1, 1);
        infoFont = new Font("SansSerif", 1, fsize);
    }

    public void message(String msg) {
        this.originalMsg = msg;
        this.rebreakLine();
        this.isClear = false;
        this.hideHelp();
    }

    public void messageImportant(String msg) {
        this.message(msg);
        if (PrefMgr.getFlag((String)"bluej.accessibility.support")) {
            DialogManager.showTextWithCopyButton((Component)this.getTopLevelAncestor(), (String)msg, (String)"BlueJ");
        }
    }

    private void rebreakLine() {
        String secondLine;
        String firstLine;
        int newline = this.originalMsg.indexOf(10);
        if (newline == -1) {
            int ipos = this.breakLine(this.originalMsg);
            if (this.originalMsg.length() <= ipos) {
                firstLine = this.originalMsg;
                secondLine = "";
            } else {
                int tspace;
                int lspace = this.originalMsg.lastIndexOf(32, ipos);
                int space = Math.max(lspace, tspace = this.originalMsg.lastIndexOf(9, ipos));
                if (space > ipos / 2) {
                    ipos = space;
                }
                firstLine = this.originalMsg.substring(0, ipos);
                secondLine = this.originalMsg.substring(ipos);
            }
        } else {
            firstLine = this.originalMsg.substring(0, newline);
            secondLine = this.originalMsg.substring(newline + 1);
        }
        secondLine = secondLine.replace("\n", ";  ");
        this.line1.setText(firstLine);
        this.line2.setText(secondLine);
    }

    private int breakLine(String msg) {
        if (msg.length() <= 2) {
            return msg.length();
        }
        FontMetrics metrics = this.line1.getFontMetrics(this.line1.getFont());
        Insets insets = this.line1.getInsets();
        int hInsets = 0;
        if (insets != null) {
            hInsets = insets.left + insets.right;
        }
        int lineWidth = this.line1.getWidth() - hInsets;
        char[] charBuf = new char[msg.length()];
        msg.getChars(0, msg.length(), charBuf, 0);
        int curWidth = metrics.charsWidth(charBuf, 0, charBuf.length);
        if (curWidth < lineWidth) {
            return charBuf.length;
        }
        int lowerBound = 1;
        int upperBound = charBuf.length;
        while (lowerBound != upperBound) {
            int mid = (lowerBound + upperBound + 1) / 2;
            curWidth = metrics.charsWidth(charBuf, 0, mid);
            if (curWidth < lineWidth) {
                lowerBound = mid;
                continue;
            }
            upperBound = Math.min(mid, upperBound - 1);
        }
        return lowerBound;
    }

    public void message(String msg1, String msg2) {
        this.message(msg1 + '\n' + msg2);
    }

    public void warning(String msg) {
        this.message(msg);
        MoeEditorManager.beep();
    }

    public void warningImportant(String msg) {
        this.messageImportant(msg);
        MoeEditorManager.beep();
    }

    public void warning(String msg1, String msg2) {
        this.message(msg1, msg2);
        MoeEditorManager.beep();
    }

    public void clear() {
        if (!this.isClear) {
            this.message(" ", " ");
            this.isClear = true;
        }
    }

    public void refresh() {
        this.line1.setFont(infoFont);
        this.line2.setFont(infoFont);
    }

    public void setHelp(String helpGroup) {
        this.helpGroup = helpGroup;
        this.helpButton.setVisible(true);
    }

    private void hideHelp() {
        this.helpButton.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        this.displayHelp(this.helpGroup);
    }

    private void displayHelp(String helpGroup) {
        int i;
        String line;
        File fileName = Config.getLanguageFile((String)(helpGroup + ".help"));
        String helpText = BlueJFileReader.readHelpText((File)fileName, (String)(line = (i = this.originalMsg.indexOf(10)) < 0 ? this.originalMsg : this.originalMsg.substring(0, i)).trim(), (boolean)false);
        if (helpText == null) {
            DialogManager.showMessageWithText(null, (String)"no-help", (String)("\n" + this.originalMsg));
        } else {
            DialogManager.showText(null, (String)(this.originalMsg + "\n\n" + helpText));
        }
    }
}

