/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.reactfx.collection.ListIteratorImpl;
import org.reactfx.collection.SubList;

interface AccessorListMethods<E>
extends List<E> {
    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    default public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Objects.equals(o, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; ++i) {
            if (!Objects.equals(o, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    default public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    default public boolean containsAll(Collection<?> c) {
        return c.stream().allMatch(this::contains);
    }

    @Override
    default public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    default public ListIterator<E> listIterator() {
        return new ListIteratorImpl(this);
    }

    @Override
    default public ListIterator<E> listIterator(int index) {
        return new ListIteratorImpl(this, index);
    }

    @Override
    default public List<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    default public Object[] toArray() {
        Object[] res = new Object[this.size()];
        int i = 0;
        for (E elem : this) {
            res[i++] = elem;
        }
        return res;
    }

    @Override
    default public <T> T[] toArray(T[] a) {
        return new ArrayList(this).toArray(a);
    }
}

