/*
 * Decompiled with CFR 0.152.
 */
package bluej.doclet.doclets.internal.toolkit.util.links;

import bluej.doclet.doclets.internal.toolkit.util.links.LinkInfo;
import bluej.doclet.doclets.internal.toolkit.util.links.LinkOutput;
import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.javadoc.Type;
import com.sun.javadoc.TypeVariable;
import com.sun.javadoc.WildcardType;

public abstract class LinkFactory {
    protected abstract LinkOutput getOutputInstance();

    public LinkOutput getLinkOutput(LinkInfo linkInfo) {
        if (linkInfo.type != null) {
            Type type = linkInfo.type;
            LinkOutput linkOutput = this.getOutputInstance();
            if (type.isPrimitive()) {
                linkInfo.displayLength += type.typeName().length();
                linkOutput.append(type.typeName());
            } else if (type.asWildcardType() != null) {
                linkInfo.isTypeBound = true;
                ++linkInfo.displayLength;
                linkOutput.append("?");
                WildcardType wildcardType = type.asWildcardType();
                Type[] extendsBounds = wildcardType.extendsBounds();
                for (int i = 0; i < extendsBounds.length; ++i) {
                    linkInfo.displayLength = linkInfo.displayLength + (i > 0 ? 2 : 9);
                    linkOutput.append(i > 0 ? ", " : " extends ");
                    this.setBoundsLinkInfo(linkInfo, extendsBounds[i]);
                    linkOutput.append(this.getLinkOutput(linkInfo));
                }
                Type[] superBounds = wildcardType.superBounds();
                for (int i = 0; i < superBounds.length; ++i) {
                    linkInfo.displayLength = linkInfo.displayLength + (i > 0 ? 2 : 7);
                    linkOutput.append(i > 0 ? ", " : " super ");
                    this.setBoundsLinkInfo(linkInfo, superBounds[i]);
                    linkOutput.append(this.getLinkOutput(linkInfo));
                }
            } else if (type.asTypeVariable() != null) {
                linkInfo.isTypeBound = true;
                ProgramElementDoc owner = type.asTypeVariable().owner();
                if (!linkInfo.excludeTypeParameterLinks && owner instanceof ClassDoc) {
                    linkInfo.classDoc = (ClassDoc)owner;
                    linkInfo.label = type.typeName();
                    linkOutput.append(this.getClassLink(linkInfo));
                } else {
                    linkInfo.displayLength += type.typeName().length();
                    linkOutput.append(type.typeName());
                }
                Type[] bounds = type.asTypeVariable().bounds();
                if (!linkInfo.excludeTypeBounds) {
                    linkInfo.excludeTypeBounds = true;
                    for (int i = 0; i < bounds.length; ++i) {
                        linkInfo.displayLength = linkInfo.displayLength + (i > 0 ? 2 : 9);
                        linkOutput.append(i > 0 ? " & " : " extends ");
                        this.setBoundsLinkInfo(linkInfo, bounds[i]);
                        linkOutput.append(this.getLinkOutput(linkInfo));
                    }
                }
            } else if (type.asClassDoc() != null) {
                if (linkInfo.isTypeBound && linkInfo.excludeTypeBoundsLinks) {
                    linkInfo.displayLength += type.typeName().length();
                    linkOutput.append(type.typeName());
                    linkOutput.append(this.getTypeParameterLinks(linkInfo));
                    return linkOutput;
                }
                linkInfo.classDoc = type.asClassDoc();
                linkOutput = this.getClassLink(linkInfo);
                if (linkInfo.includeTypeAsSepLink) {
                    linkOutput.append(this.getTypeParameterLinks(linkInfo, false));
                }
            }
            if (linkInfo.isVarArg) {
                if (type.dimension().length() > 2) {
                    linkInfo.displayLength += type.dimension().length() - 2;
                    linkOutput.append(type.dimension().substring(2));
                }
                linkInfo.displayLength += 3;
                linkOutput.append("...");
            } else {
                linkInfo.displayLength += type.dimension().length();
                linkOutput.append(type.dimension());
            }
            return linkOutput;
        }
        if (linkInfo.classDoc != null) {
            LinkOutput linkOutput = this.getClassLink(linkInfo);
            if (linkInfo.includeTypeAsSepLink) {
                linkOutput.append(this.getTypeParameterLinks(linkInfo, false));
            }
            return linkOutput;
        }
        return null;
    }

    private void setBoundsLinkInfo(LinkInfo linkInfo, Type bound) {
        linkInfo.classDoc = null;
        linkInfo.label = null;
        linkInfo.type = bound;
    }

    protected abstract LinkOutput getClassLink(LinkInfo var1);

    protected abstract LinkOutput getTypeParameterLink(LinkInfo var1, Type var2);

    public LinkOutput getTypeParameterLinks(LinkInfo linkInfo) {
        return this.getTypeParameterLinks(linkInfo, true);
    }

    public LinkOutput getTypeParameterLinks(LinkInfo linkInfo, boolean isClassLabel) {
        TypeVariable[] vars;
        LinkOutput output = this.getOutputInstance();
        if (linkInfo.executableMemberDoc != null) {
            vars = linkInfo.executableMemberDoc.typeParameters();
        } else if (linkInfo.type != null && linkInfo.type.asParameterizedType() != null) {
            vars = linkInfo.type.asParameterizedType().typeArguments();
        } else if (linkInfo.classDoc != null) {
            vars = linkInfo.classDoc.typeParameters();
        } else {
            return output;
        }
        if ((linkInfo.includeTypeInClassLinkLabel && isClassLabel || linkInfo.includeTypeAsSepLink && !isClassLabel) && vars.length > 0) {
            ++linkInfo.displayLength;
            output.append(this.getLessThanString());
            for (int i = 0; i < vars.length; ++i) {
                if (i > 0) {
                    ++linkInfo.displayLength;
                    output.append(",");
                }
                output.append(this.getTypeParameterLink(linkInfo, (Type)vars[i]));
            }
            ++linkInfo.displayLength;
            output.append(this.getGreaterThanString());
        }
        return output;
    }

    protected String getLessThanString() {
        return "&lt;";
    }

    protected String getGreaterThanString() {
        return "&gt;";
    }
}

