/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.component.light.impl;

import com.pi4j.component.light.LEDBase;
import com.pi4j.component.light.LightStateChangeEvent;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import java.util.concurrent.Future;

public class GpioLEDComponent
extends LEDBase {
    GpioPinDigitalOutput pin = null;
    PinState onState = PinState.HIGH;
    PinState offState = PinState.LOW;
    private GpioPinListenerDigital listener = new GpioPinListenerDigital(){

        public void handleGpioPinDigitalStateChangeEvent(GpioPinDigitalStateChangeEvent event) {
            if (event.getState() == GpioLEDComponent.this.onState) {
                GpioLEDComponent.this.notifyListeners(new LightStateChangeEvent(GpioLEDComponent.this, true));
            }
            if (event.getState() == GpioLEDComponent.this.offState) {
                GpioLEDComponent.this.notifyListeners(new LightStateChangeEvent(GpioLEDComponent.this, false));
            }
        }
    };

    public GpioLEDComponent(GpioPinDigitalOutput pin, PinState onState, PinState offState) {
        this(pin);
        this.onState = onState;
        this.offState = offState;
    }

    public GpioLEDComponent(GpioPinDigitalOutput pin) {
        this.pin = pin;
        this.pin.addListener(new GpioPinListener[]{this.listener});
    }

    @Override
    public void on() {
        this.pin.setState(this.onState);
    }

    @Override
    public void off() {
        this.pin.setState(this.offState);
    }

    @Override
    public boolean isOn() {
        return this.pin.isState(this.onState);
    }

    @Override
    public Future<?> blink(long delay) {
        return this.pin.blink(delay, this.onState);
    }

    @Override
    public Future<?> blink(long delay, long duration) {
        return this.pin.blink(delay, duration, this.onState);
    }

    @Override
    public Future<?> pulse(long duration) {
        return this.pin.pulse(duration, this.onState);
    }

    @Override
    public Future<?> pulse(long duration, boolean blocking) {
        return this.pin.pulse(duration, this.onState, blocking);
    }
}

