/*
 * Decompiled with CFR 0.152.
 */
package bluej.collect;

import bluej.Config;
import bluej.collect.CodeAnonymiser;
import bluej.collect.CollectUtility;
import bluej.collect.DataCollector;
import bluej.collect.DataSubmitter;
import bluej.collect.DiagnosticWithShown;
import bluej.collect.Event;
import bluej.collect.EventName;
import bluej.collect.FileKey;
import bluej.collect.PlainEvent;
import bluej.compiler.Diagnostic;
import bluej.debugger.DebuggerTestResult;
import bluej.debugger.ExceptionDescription;
import bluej.debugger.SourceLocation;
import bluej.debugmgr.inspector.ClassInspector;
import bluej.debugmgr.inspector.Inspector;
import bluej.debugmgr.inspector.ObjectInspector;
import bluej.extmgr.ExtensionWrapper;
import bluej.groupwork.Repository;
import bluej.pkgmgr.Package;
import bluej.pkgmgr.Project;
import bluej.pkgmgr.target.ClassTarget;
import bluej.utility.Utility;
import difflib.Delta;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;

public class DataCollectorImpl {
    private static IdentityHashMap<Inspector, Package> inspectorPackages = new IdentityHashMap();

    private static void submitEventNoData(Project project, Package pkg, EventName eventName) {
        DataCollectorImpl.submitEvent(project, pkg, eventName, new PlainEvent(new MultipartEntity()));
    }

    private static void submitEventWithLocalLocation(Project project, Package pkg, EventName eventName, MultipartEntity mpe, File sourceFile, int lineNumber) {
        if (mpe == null) {
            mpe = new MultipartEntity();
        }
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(project, sourceFile));
        mpe.addPart("event[line_number]", (ContentBody)CollectUtility.toBody(lineNumber));
        DataCollectorImpl.submitEvent(project, pkg, eventName, new PlainEvent(mpe));
    }

    private static void submitDebuggerEventWithLocation(Project project, EventName eventName, MultipartEntity mpe, SourceLocation[] stack) {
        if (mpe == null) {
            mpe = new MultipartEntity();
        }
        DataCollectorImpl.addStackTrace(mpe, "event[stack]", stack);
        DataCollectorImpl.submitEvent(project, null, eventName, new PlainEvent(mpe));
    }

    private static synchronized void submitEvent(Project project, Package pkg, final EventName eventName, final Event evt) {
        final String projectName = project == null ? null : project.getProjectName();
        final String projectPathHash = project == null ? null : CollectUtility.md5Hash(project.getProjectDir().getAbsolutePath());
        final String packageName = pkg == null ? null : pkg.getQualifiedName();
        final String uuidCopy = DataCollector.getUserID();
        final String experimentCopy = DataCollector.getExperimentIdentifier();
        final String participantCopy = DataCollector.getParticipantIdentifier();
        DataSubmitter.submitEvent(new Event(){

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                evt.success(fileVersions);
            }

            @Override
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                MultipartEntity mpe = evt.makeData(sequenceNum, fileVersions);
                if (mpe == null) {
                    return null;
                }
                mpe.addPart("user[uuid]", (ContentBody)CollectUtility.toBody(uuidCopy));
                mpe.addPart("session[id]", (ContentBody)CollectUtility.toBody(DataCollector.getSessionUuid()));
                mpe.addPart("participant[experiment]", (ContentBody)CollectUtility.toBody(experimentCopy));
                mpe.addPart("participant[participant]", (ContentBody)CollectUtility.toBody(participantCopy));
                if (projectName != null) {
                    mpe.addPart("project[name]", (ContentBody)CollectUtility.toBody(projectName));
                    mpe.addPart("project[path_hash]", (ContentBody)CollectUtility.toBody(projectPathHash));
                    if (packageName != null) {
                        mpe.addPart("package[name]", (ContentBody)CollectUtility.toBody(packageName));
                    }
                }
                mpe.addPart("event[source_time]", (ContentBody)CollectUtility.toBody(DateFormat.getDateTimeInstance().format(new Date())));
                mpe.addPart("event[name]", (ContentBody)CollectUtility.toBody(eventName.getName()));
                mpe.addPart("event[sequence_id]", (ContentBody)CollectUtility.toBody(Integer.toString(sequenceNum)));
                return mpe;
            }
        });
    }

    public static void compiled(Project proj, Package pkg, File[] sources, List<DiagnosticWithShown> diagnostics, boolean success) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[compile_success]", (ContentBody)CollectUtility.toBody(success));
        for (File src : sources) {
            mpe.addPart("event[compile_input][][source_file_name]", (ContentBody)CollectUtility.toBody(CollectUtility.toPath(proj, src)));
        }
        for (DiagnosticWithShown dws : diagnostics) {
            Diagnostic d = dws.getDiagnostic();
            mpe.addPart("event[compile_output][][is_error]", (ContentBody)CollectUtility.toBody(d.getType() == Diagnostic.ERROR));
            mpe.addPart("event[compile_output][][shown]", (ContentBody)CollectUtility.toBody(dws.wasShownToUser()));
            mpe.addPart("event[compile_output][][message]", (ContentBody)CollectUtility.toBody(d.getMessage()));
            if (d.getFileName() == null) continue;
            mpe.addPart("event[compile_output][][start_line]", (ContentBody)CollectUtility.toBody(d.getStartLine()));
            mpe.addPart("event[compile_output][][end_line]", (ContentBody)CollectUtility.toBody(d.getEndLine()));
            mpe.addPart("event[compile_output][][start_column]", (ContentBody)CollectUtility.toBody(d.getStartColumn()));
            mpe.addPart("event[compile_output][][end_column]", (ContentBody)CollectUtility.toBody(d.getEndColumn()));
            String relative = CollectUtility.toPath(proj, new File(d.getFileName()));
            mpe.addPart("event[compile_output][][source_file_name]", (ContentBody)CollectUtility.toBody(relative));
        }
        DataCollectorImpl.submitEvent(proj, pkg, EventName.COMPILE, new PlainEvent(mpe));
    }

    public static void bluejOpened(String osVersion, String javaVersion, String bluejVersion, String interfaceLanguage, List<ExtensionWrapper> extensions) {
        if (Config.isGreenfoot()) {
            return;
        }
        DataSubmitter.initSequence();
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("installation[operating_system]", (ContentBody)CollectUtility.toBody(osVersion));
        mpe.addPart("installation[java_version]", (ContentBody)CollectUtility.toBody(javaVersion));
        mpe.addPart("installation[bluej_version]", (ContentBody)CollectUtility.toBody(bluejVersion));
        mpe.addPart("installation[interface_language]", (ContentBody)CollectUtility.toBody(interfaceLanguage));
        DataCollectorImpl.addExtensions(mpe, extensions);
        DataCollectorImpl.submitEvent(null, null, EventName.BLUEJ_START, new PlainEvent(mpe));
    }

    private static void addExtensions(MultipartEntity mpe, List<ExtensionWrapper> extensions) {
        for (ExtensionWrapper ext : extensions) {
            mpe.addPart("extensions[][name]", (ContentBody)CollectUtility.toBody(ext.safeGetExtensionName()));
            mpe.addPart("extensions[][version]", (ContentBody)CollectUtility.toBody(ext.safeGetExtensionVersion()));
        }
    }

    public static void projectOpened(Project proj, List<ExtensionWrapper> projectExtensions) {
        MultipartEntity mpe = new MultipartEntity();
        DataCollectorImpl.addExtensions(mpe, projectExtensions);
        DataCollectorImpl.submitEventNoData(proj, null, EventName.PROJECT_OPENING);
    }

    public static void projectClosed(Project proj) {
        DataCollectorImpl.submitEventNoData(proj, null, EventName.PROJECT_CLOSING);
    }

    public static void packageOpened(Package pkg) {
        Project proj = pkg.getProject();
        final MultipartEntity mpe = new MultipartEntity();
        final HashMap<FileKey, List<String>> versions = new HashMap<FileKey, List<String>>();
        for (ClassTarget ct : pkg.getClassTargets()) {
            String relative = CollectUtility.toPath(proj, ct.getSourceFile());
            mpe.addPart("project[source_files][][name]", (ContentBody)CollectUtility.toBody(relative));
            String anonymisedContent = CollectUtility.readFileAndAnonymise(proj, ct.getSourceFile());
            if (anonymisedContent == null) continue;
            mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody("complete"));
            mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBody(relative));
            mpe.addPart("source_histories[][content]", (ContentBody)CollectUtility.toBody(anonymisedContent));
            versions.put(new FileKey(proj, relative), Arrays.asList(Utility.splitLines(anonymisedContent)));
        }
        DataCollectorImpl.submitEvent(proj, pkg, EventName.PACKAGE_OPENING, new Event(){

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                fileVersions.putAll(versions);
            }

            @Override
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                return mpe;
            }
        });
    }

    public static void packageClosed(Package pkg) {
        DataCollectorImpl.submitEventNoData(pkg.getProject(), pkg, EventName.PACKAGE_CLOSING);
    }

    public static void bluejClosed() {
        DataCollectorImpl.submitEventNoData(null, null, EventName.BLUEJ_FINISH);
        DataSubmitter.waitForQueueFlush(1000);
    }

    public static void restartVM(Project project) {
        DataCollectorImpl.submitEventNoData(project, null, EventName.RESETTING_VM);
    }

    public static void edit(Package pkg, final File path, String source, final boolean includeOneLineEdits) {
        final Project proj = pkg.getProject();
        final FileKey key = new FileKey(proj, CollectUtility.toPath(proj, path));
        String anonSource = CodeAnonymiser.anonymise(source);
        final List<String> anonDoc = Arrays.asList(Utility.splitLines(anonSource));
        DataCollectorImpl.submitEvent(proj, pkg, EventName.EDIT, new Event(){
            private boolean dontReplace = false;

            private boolean isOneLineDiff(Patch patch) {
                if (patch.getDeltas().size() > 1) {
                    return false;
                }
                Delta theDelta = (Delta)patch.getDeltas().get(0);
                return theDelta.getOriginal().size() == 1 && theDelta.getRevised().size() == 1;
            }

            @Override
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                List<String> previousDoc = fileVersions.get(key);
                if (previousDoc == null) {
                    previousDoc = new ArrayList<String>();
                }
                MultipartEntity mpe = new MultipartEntity();
                Patch patch = DiffUtils.diff(previousDoc, (List)anonDoc);
                if (patch.getDeltas().isEmpty() || this.isOneLineDiff(patch) && !includeOneLineEdits) {
                    this.dontReplace = true;
                    return null;
                }
                String diff = DataCollectorImpl.makeDiff(patch);
                mpe.addPart("source_histories[][content]", (ContentBody)CollectUtility.toBody(diff));
                mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody("diff"));
                mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBody(CollectUtility.toPath(proj, path)));
                return mpe;
            }

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                if (!this.dontReplace) {
                    fileVersions.put(key, anonDoc);
                }
            }
        });
    }

    protected static String makeDiff(Patch patch) {
        StringBuilder diff = new StringBuilder();
        for (Delta delta : patch.getDeltas()) {
            int destLine;
            int srcLine;
            int srcSize = delta.getOriginal().size();
            int destSize = delta.getRevised().size();
            if (srcSize > 0) {
                srcLine = delta.getOriginal().getPosition() + 1;
                destLine = delta.getRevised().getPosition() + 1;
            } else {
                srcLine = delta.getOriginal().getPosition();
                destLine = delta.getRevised().getPosition();
            }
            diff.append("@@ -" + srcLine + "," + srcSize + " +" + destLine + "," + destSize + " @@\n");
            for (String l : delta.getOriginal().getLines()) {
                diff.append("-" + l + "\n");
            }
            for (String l : delta.getRevised().getLines()) {
                diff.append("+" + l + "\n");
            }
        }
        return diff.toString();
    }

    public static void debuggerTerminate(Project project) {
        DataCollectorImpl.submitEventNoData(project, null, EventName.DEBUGGER_TERMINATE);
    }

    public static void debuggerChangeVisible(Project project, boolean newVis) {
        DataCollectorImpl.submitEventNoData(project, null, newVis ? EventName.DEBUGGER_OPEN : EventName.DEBUGGER_CLOSE);
    }

    public static void debuggerBreakpointToggle(Package pkg, File sourceFile, int lineNumber, boolean newState) {
        DataCollectorImpl.submitEventWithLocalLocation(pkg.getProject(), pkg, newState ? EventName.DEBUGGER_BREAKPOINT_ADD : EventName.DEBUGGER_BREAKPOINT_REMOVE, null, sourceFile, lineNumber);
    }

    public static void debuggerContinue(Project project, String threadName) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitEvent(project, null, EventName.DEBUGGER_CONTINUE, new PlainEvent(mpe));
    }

    public static void debuggerHalt(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_HALT, mpe, stack);
    }

    public static void debuggerStepInto(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_STEP_INTO, mpe, stack);
    }

    public static void debuggerStepOver(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_STEP_OVER, mpe, stack);
    }

    public static void debuggerHitBreakpoint(Project project, String threadName, SourceLocation[] stack) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[thread_name]", (ContentBody)CollectUtility.toBody(threadName));
        DataCollectorImpl.submitDebuggerEventWithLocation(project, EventName.DEBUGGER_HIT_BREAKPOINT, mpe, stack);
    }

    public static void codePadSuccess(Package pkg, String command, String output) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[codepad][outcome]", (ContentBody)CollectUtility.toBody("success"));
        mpe.addPart("event[codepad][command]", (ContentBody)CollectUtility.toBody(command));
        mpe.addPart("event[codepad][result]", (ContentBody)CollectUtility.toBody(output));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CODEPAD, new PlainEvent(mpe));
    }

    public static void codePadError(Package pkg, String command, String error) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[codepad][outcome]", (ContentBody)CollectUtility.toBody("error"));
        mpe.addPart("event[codepad][command]", (ContentBody)CollectUtility.toBody(command));
        mpe.addPart("event[codepad][error]", (ContentBody)CollectUtility.toBody(error));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CODEPAD, new PlainEvent(mpe));
    }

    public static void codePadException(Package pkg, String command, String exception) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[codepad][outcome]", (ContentBody)CollectUtility.toBody("exception"));
        mpe.addPart("event[codepad][command]", (ContentBody)CollectUtility.toBody(command));
        mpe.addPart("event[codepad][exception]", (ContentBody)CollectUtility.toBody(exception));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CODEPAD, new PlainEvent(mpe));
    }

    public static void renamedClass(Package pkg, final File oldSourceFile, final File newSourceFile) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody("rename"));
        mpe.addPart("source_histories[][content]", (ContentBody)CollectUtility.toBodyLocal(pkg.getProject(), oldSourceFile));
        mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBodyLocal(pkg.getProject(), newSourceFile));
        final Project project = pkg.getProject();
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.RENAME, new PlainEvent(mpe){

            @Override
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                FileKey oldKey = new FileKey(project, CollectUtility.toPath(project, oldSourceFile));
                FileKey newKey = new FileKey(project, CollectUtility.toPath(project, newSourceFile));
                fileVersions.put(newKey, fileVersions.get(oldKey));
                fileVersions.remove(oldKey);
                return super.makeData(sequenceNum, fileVersions);
            }
        });
    }

    public static void removeClass(Package pkg, final File sourceFile) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody("file_delete"));
        mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBodyLocal(pkg.getProject(), sourceFile));
        final Project project = pkg.getProject();
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.DELETE, new PlainEvent(mpe){

            @Override
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                fileVersions.remove(new FileKey(project, CollectUtility.toPath(project, sourceFile)));
                return super.makeData(sequenceNum, fileVersions);
            }
        });
    }

    public static void addClass(Package pkg, File sourceFile) {
        final MultipartEntity mpe = new MultipartEntity();
        Project project = pkg.getProject();
        final String contents = CollectUtility.readFileAndAnonymise(project, sourceFile);
        mpe.addPart("project[source_files][][name]", (ContentBody)CollectUtility.toBodyLocal(project, sourceFile));
        mpe.addPart("source_histories[][source_history_type]", (ContentBody)CollectUtility.toBody("complete"));
        mpe.addPart("source_histories[][name]", (ContentBody)CollectUtility.toBodyLocal(project, sourceFile));
        mpe.addPart("source_histories[][content]", (ContentBody)CollectUtility.toBody(contents));
        final FileKey key = new FileKey(project, CollectUtility.toPath(project, sourceFile));
        DataCollectorImpl.submitEvent(project, pkg, EventName.ADD, new Event(){

            @Override
            public void success(Map<FileKey, List<String>> fileVersions) {
                fileVersions.put(key, Arrays.asList(Utility.splitLines(contents)));
            }

            @Override
            public MultipartEntity makeData(int sequenceNum, Map<FileKey, List<String>> fileVersions) {
                return mpe;
            }
        });
    }

    public static void teamShareProject(Project project, Repository repo) {
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_SHARE, new PlainEvent(DataCollectorImpl.getRepoMPE(repo)));
    }

    public static void teamCommitProject(Project project, Repository repo, Collection<File> committedFiles) {
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (File f : committedFiles) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(project, f));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_COMMIT, new PlainEvent(mpe));
    }

    public static void teamUpdateProject(Project project, Repository repo, Collection<File> updatedFiles) {
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (File f : updatedFiles) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(project, f));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_UPDATE, new PlainEvent(mpe));
    }

    public static void teamStatusProject(Project project, Repository repo, Map<File, String> status) {
        MultipartEntity mpe = DataCollectorImpl.getRepoMPE(repo);
        for (Map.Entry<File, String> s : status.entrySet()) {
            mpe.addPart("vcs_files[][file]", (ContentBody)CollectUtility.toBodyLocal(project, s.getKey()));
            mpe.addPart("vcs_files[][status]", (ContentBody)CollectUtility.toBody(s.getValue()));
        }
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_STATUS, new PlainEvent(mpe));
    }

    public static void teamHistoryProject(Project project, Repository repo) {
        DataCollectorImpl.submitEvent(project, null, EventName.VCS_HISTORY, new PlainEvent(DataCollectorImpl.getRepoMPE(repo)));
    }

    public static void showHideTerminal(Project project, boolean show) {
        DataCollectorImpl.submitEventNoData(project, null, show ? EventName.TERMINAL_OPEN : EventName.TERMINAL_CLOSE);
    }

    public static void invokeCompileError(Package pkg, String code, String compilationError) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("compile_error"));
        mpe.addPart("event[invoke][compile_error]", (ContentBody)CollectUtility.toBody(compilationError));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void invokeMethodSuccess(Package pkg, String code, String objName, String typeName, int testIdentifier, int invocationIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][type_name]", (ContentBody)CollectUtility.toBody(typeName));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("success"));
        mpe.addPart("event[invoke][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        mpe.addPart("event[invoke][invoke_identifier]", (ContentBody)CollectUtility.toBody(invocationIdentifier));
        if (objName != null) {
            mpe.addPart("event[invoke][bench_object][class_name]", (ContentBody)CollectUtility.toBody(typeName));
            mpe.addPart("event[invoke][bench_object][name]", (ContentBody)CollectUtility.toBody(objName));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void invokeMethodException(Package pkg, String code, ExceptionDescription ed) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("exception"));
        mpe.addPart("event[invoke][exception_class]", (ContentBody)CollectUtility.toBody(ed.getClassName()));
        mpe.addPart("event[invoke][exception_message]", (ContentBody)CollectUtility.toBody(ed.getText()));
        DataCollectorImpl.addStackTrace(mpe, "event[invoke][exception_stack]", ed.getStack().toArray(new SourceLocation[0]));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void invokeMethodTerminated(Package pkg, String code) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[invoke][code]", (ContentBody)CollectUtility.toBody(code));
        mpe.addPart("event[invoke][result]", (ContentBody)CollectUtility.toBody("terminated"));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INVOKE_METHOD, new PlainEvent(mpe));
    }

    public static void removeObject(Package pkg, String name) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[object_name]", (ContentBody)CollectUtility.toBody(name));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.REMOVE_OBJECT, new PlainEvent(mpe));
    }

    public static void inspectorClassShow(Package pkg, Inspector inspector, String className) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[inspect][unique]", (ContentBody)CollectUtility.toBody(inspector.getUniqueId()));
        mpe.addPart("event[inspect][static_class]", (ContentBody)CollectUtility.toBody(className));
        inspectorPackages.put(inspector, pkg);
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INSPECTOR_SHOW, new PlainEvent(mpe));
    }

    public static void inspectorObjectShow(Package pkg, Inspector inspector, String benchName, String className, String displayName) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[inspect][unique]", (ContentBody)CollectUtility.toBody(inspector.getUniqueId()));
        mpe.addPart("event[inspect][display_name]", (ContentBody)CollectUtility.toBody(displayName));
        mpe.addPart("event[inspect][class_name]", (ContentBody)CollectUtility.toBody(className));
        if (benchName != null) {
            mpe.addPart("event[inspect][bench_object_name]", (ContentBody)CollectUtility.toBody(benchName));
        }
        inspectorPackages.put(inspector, pkg);
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.INSPECTOR_SHOW, new PlainEvent(mpe));
    }

    public static void inspectorHide(Project project, Inspector inspector) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[inspect][unique]", (ContentBody)CollectUtility.toBody(inspector.getUniqueId()));
        if (inspector instanceof ClassInspector || inspector instanceof ObjectInspector) {
            DataCollectorImpl.submitEvent(project, inspectorPackages.get(inspector), EventName.INSPECTOR_HIDE, new PlainEvent(mpe));
        }
    }

    public static void benchGet(Package pkg, String benchName, String typeName, int testIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[bench_object][class_name]", (ContentBody)CollectUtility.toBody(typeName));
        mpe.addPart("event[bench_object][name]", (ContentBody)CollectUtility.toBody(benchName));
        mpe.addPart("event[test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.BENCH_GET, new PlainEvent(mpe));
    }

    public static void startTestMethod(Package pkg, int testIdentifier, File sourceFile, String testName) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[test][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        mpe.addPart("event[test][source_file]", (ContentBody)CollectUtility.toBodyLocal(pkg.getProject(), sourceFile));
        mpe.addPart("event[test][method_name]", (ContentBody)CollectUtility.toBody(testName));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.START_TEST, new PlainEvent(mpe));
    }

    public static void cancelTestMethod(Package pkg, int testIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[test][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.CANCEL_TEST, new PlainEvent(mpe));
    }

    public static void endTestMethod(Package pkg, int testIdentifier) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[test][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.END_TEST, new PlainEvent(mpe));
    }

    public static void assertTestMethod(Package pkg, int testIdentifier, int invocationIdentifier, String assertion, String param1, String param2) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[assert][test_identifier]", (ContentBody)CollectUtility.toBody(testIdentifier));
        mpe.addPart("event[assert][invoke_identifier]", (ContentBody)CollectUtility.toBody(invocationIdentifier));
        mpe.addPart("event[assert][assertion]", (ContentBody)CollectUtility.toBody(assertion));
        mpe.addPart("event[assert][param1]", (ContentBody)CollectUtility.toBody(param1));
        mpe.addPart("event[assert][param2]", (ContentBody)CollectUtility.toBody(param2));
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.ASSERTION, new PlainEvent(mpe));
    }

    public static void objectBenchToFixture(Package pkg, File sourceFile, List<String> benchNames) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(pkg.getProject(), sourceFile));
        for (String name : benchNames) {
            mpe.addPart("event[bench_objects][][name]", (ContentBody)CollectUtility.toBody(name));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.BENCH_TO_FIXTURE, new PlainEvent(mpe));
    }

    public static void fixtureToObjectBench(Package pkg, File sourceFile, List<DataCollector.NamedTyped> objects) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[source_file_name]", (ContentBody)CollectUtility.toBodyLocal(pkg.getProject(), sourceFile));
        for (DataCollector.NamedTyped obj : objects) {
            mpe.addPart("event[bench_objects][][name]", (ContentBody)CollectUtility.toBody(obj.getName()));
            mpe.addPart("event[bench_objects][][class_name]", (ContentBody)CollectUtility.toBody(obj.getType()));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.FIXTURE_TO_BENCH, new PlainEvent(mpe));
    }

    public static void testResult(Package pkg, DebuggerTestResult lastResult) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[class_name]", (ContentBody)CollectUtility.toBody(lastResult.getQualifiedClassName()));
        mpe.addPart("event[method_name]", (ContentBody)CollectUtility.toBody(lastResult.getMethodName()));
        mpe.addPart("event[run_time]", (ContentBody)CollectUtility.toBody(lastResult.getRunTimeMs()));
        String status = "unknown";
        if (lastResult.isSuccess()) {
            status = "success";
        } else if (lastResult.isFailure()) {
            status = "failure";
        } else if (lastResult.isError()) {
            status = "error";
        }
        mpe.addPart("event[result]", (ContentBody)CollectUtility.toBody(status));
        if (!lastResult.isSuccess()) {
            mpe.addPart("event[exception_message]", (ContentBody)CollectUtility.toBody(lastResult.getExceptionMessage()));
            mpe.addPart("event[exception_trace]", (ContentBody)CollectUtility.toBody(lastResult.getTrace()));
        }
        DataCollectorImpl.submitEvent(pkg.getProject(), pkg, EventName.RUN_TEST, new PlainEvent(mpe));
    }

    private static void addStackTrace(MultipartEntity mpe, String listName, SourceLocation[] stack) {
        for (int i = 0; i < stack.length; ++i) {
            mpe.addPart(listName + "[][entry]", (ContentBody)CollectUtility.toBody(i));
            mpe.addPart(listName + "[][class_name]", (ContentBody)CollectUtility.toBody(stack[i].getClassName()));
            mpe.addPart(listName + "[][class_source_name]", (ContentBody)CollectUtility.toBody(stack[i].getFileName()));
            mpe.addPart(listName + "[][line_number]", (ContentBody)CollectUtility.toBody(stack[i].getLineNumber()));
        }
    }

    private static MultipartEntity getRepoMPE(Repository repo) {
        MultipartEntity mpe = new MultipartEntity();
        mpe.addPart("event[vcs][vcs_type]", (ContentBody)CollectUtility.toBody(repo.getVCSType()));
        mpe.addPart("event[vcs][protocol]", (ContentBody)CollectUtility.toBody(repo.getVCSProtocol()));
        return mpe;
    }
}

