/*
 * Decompiled with CFR 0.152.
 */
package bluej.debugmgr;

import bluej.Config;
import bluej.debugmgr.CallDialog;
import bluej.debugmgr.CallHistory;
import bluej.debugmgr.objectbench.ObjectBenchInterface;
import bluej.utility.JavaNames;
import bluej.views.CallableView;
import bluej.views.ConstructorView;
import bluej.views.LabelPrintWriter;
import bluej.views.TypeParamView;
import bluej.views.View;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class ConstructorDialog
extends CallDialog {
    private static final String appName = Config.getApplicationName();
    private static final String wCreateTitle = appName + ":  " + Config.getString("pkgmgr.methodCall.titleCreate");
    static final String sNameOfInstance = Config.getString("pkgmgr.methodCall.namePrompt");
    static final String sTypeParameters = Config.getString("pkgmgr.methodCall.typeParametersPrompt");
    static final String sTypeParameter = Config.getString("pkgmgr.methodCall.typeParameterPrompt");
    static final String illegalNameMsg = Config.getString("error.methodCall.illegalName");
    static final String duplicateNameMsg = Config.getString("error.methodCall.duplicateName");
    private JTextField instanceNameText;
    private ConstructorView constructor;
    private boolean okCalled;

    public ConstructorDialog(JFrame parentFrame, ObjectBenchInterface ob, CallHistory callHistory, String initialName, ConstructorView constructor) {
        super(parentFrame, ob, "");
        this.history = callHistory;
        this.constructor = constructor;
        this.makeDialog(constructor.getClassName(), initialName);
        this.setInstanceInfo(initialName);
    }

    @Override
    protected void makeDialogInternal(String className, String instanceName, JPanel centerPanel) {
        this.makeCreateDialog(className, instanceName, this.constructor, centerPanel);
    }

    private void makeCreateDialog(String className, String instanceName, CallableView method, JPanel panel) {
        JLabel name;
        View clazz;
        this.setTitle(wCreateTitle);
        JLabel instName = new JLabel(sNameOfInstance);
        this.instanceNameText = new JTextField(instanceName, 16);
        instName.setLabelFor(this.instanceNameText);
        this.instanceNameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ConstructorDialog.this.doOk();
            }
        });
        this.instanceNameText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent fe) {
                ((JTextField)fe.getComponent()).selectAll();
            }

            @Override
            public void focusLost(FocusEvent fe) {
            }
        });
        JPanel tmpPanel = new JPanel();
        if (!Config.isRaspberryPi()) {
            tmpPanel.setOpaque(false);
        }
        GridBagLayout gridBag = new GridBagLayout();
        tmpPanel.setLayout(gridBag);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = INSETS;
        constraints.gridy = 0;
        constraints.gridx = 0;
        gridBag.setConstraints(instName, constraints);
        if (!Config.isGreenfoot()) {
            tmpPanel.add(instName);
        }
        constraints.gridx = 1;
        constraints.gridwidth = 1;
        constraints.anchor = 17;
        constraints.fill = 2;
        gridBag.setConstraints(this.instanceNameText, constraints);
        if (!Config.isGreenfoot()) {
            tmpPanel.add(this.instanceNameText);
        }
        if ((clazz = method.getDeclaringView()).isGeneric()) {
            name = null;
            name = ConstructorDialog.getFormalTypeParams(this.constructor).length > 1 ? new JLabel(sTypeParameters) : new JLabel(sTypeParameter);
            constraints.gridwidth = 1;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 18;
            constraints.fill = 0;
            this.setPreferredHeight(name, this.getComboBoxHeight());
            gridBag.setConstraints(name, constraints);
            tmpPanel.add(name);
            JPanel typeParameterPanel = this.createTypeParameterPanel();
            if (!Config.isRaspberryPi()) {
                typeParameterPanel.setOpaque(false);
            }
            constraints.gridwidth = 1;
            constraints.gridx = 1;
            constraints.anchor = 17;
            constraints.fill = 0;
            tmpPanel.add((Component)typeParameterPanel, constraints);
        }
        if (method.hasParameters()) {
            name = new JLabel("new " + className, 4);
            constraints.gridwidth = 1;
            constraints.gridx = 0;
            ++constraints.gridy;
            constraints.anchor = 12;
            constraints.fill = 0;
            this.setPreferredHeight(name, this.getComboBoxHeight());
            gridBag.setConstraints(name, constraints);
            tmpPanel.add(name);
            constraints.anchor = 17;
            constraints.gridx = 1;
            constraints.fill = 2;
            JPanel parameterPanel = this.createParameterPanel();
            if (!Config.isRaspberryPi()) {
                parameterPanel.setOpaque(false);
            }
            tmpPanel.add((Component)parameterPanel, constraints);
            constraints.gridx = 3;
            constraints.gridy = 0;
            constraints.weightx = 1.0;
            JPanel filler = new JPanel();
            if (!Config.isRaspberryPi()) {
                filler.setOpaque(false);
            }
            gridBag.setConstraints(filler, constraints);
            tmpPanel.add(filler);
        }
        tmpPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.add((Component)tmpPanel, "North");
    }

    public void setInstanceInfo(String instanceName) {
        this.instanceNameText.setText(instanceName);
        this.createDescription();
        this.setErrorMessage("");
        this.clearParameters();
        this.startObjectBenchListening();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!Config.isGreenfoot()) {
                    ConstructorDialog.this.instanceNameText.requestFocusInWindow();
                } else if (ConstructorDialog.this.typeParameterList != null) {
                    ConstructorDialog.this.typeParameterList.getParameter(0).getEditor().getEditorComponent().requestFocusInWindow();
                } else if (ConstructorDialog.this.parameterList != null) {
                    ConstructorDialog.this.parameterList.getParameter(0).getEditor().getEditorComponent().requestFocusInWindow();
                }
            }
        });
    }

    private void createDescription() {
        LabelPrintWriter writer = new LabelPrintWriter();
        this.constructor.print(writer);
        this.setDescription(writer.getLabel());
        this.setVisible(true);
    }

    private JPanel createTypeParameterPanel() {
        TypeParamView[] formalTypeParams = ConstructorDialog.getFormalTypeParams(this.constructor);
        this.typeParameterList = new CallDialog.ParameterList(formalTypeParams.length, this.defaultParamValue, false);
        for (int i = 0; i < formalTypeParams.length; ++i) {
            List<String> historyList = this.history.getHistory(formalTypeParams[i]);
            JComboBox component = this.createComboBox(historyList);
            this.typeParameterList.addParameter(i, component, formalTypeParams[i].toString());
        }
        String startString = "<";
        String endString = ">";
        CallDialog.ParameterList superParamList = this.typeParameterList;
        return this.createParameterPanel(startString, endString, superParamList);
    }

    @Override
    public void doOk() {
        if (!this.okCalled) {
            if (!JavaNames.isIdentifier(this.getNewInstanceName())) {
                this.setErrorMessage(illegalNameMsg);
                return;
            }
            ObjectBenchInterface ob = this.getObjectBench();
            if (ob != null && ob.hasObject(this.getNewInstanceName())) {
                this.setErrorMessage(duplicateNameMsg);
                return;
            }
            if (!this.parameterFieldsOk()) {
                this.setErrorMessage(emptyFieldMsg);
            } else if (!this.typeParameterFieldsOk()) {
                this.setErrorMessage(emptyTypeFieldMsg);
            } else {
                this.setWaitCursor(true);
                this.okButton.requestFocus();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ConstructorDialog.this.callWatcher(0);
                    }
                });
                this.okCalled = true;
            }
        }
    }

    @Override
    public void setEnabled(boolean state) {
        this.okButton.setEnabled(state);
        super.setEnabled(state);
        if (state) {
            this.okCalled = false;
        }
    }

    @Override
    public String getNewInstanceName() {
        if (this.instanceNameText == null) {
            return "";
        }
        return this.instanceNameText.getText().trim();
    }

    @Override
    protected CallableView getCallableView() {
        return this.constructor;
    }
}

