/*
 * Decompiled with CFR 0.152.
 */
package bluej.terminal;

import bluej.pkgmgr.Project;
import bluej.terminal.ExceptionSourceLocation;
import bluej.terminal.InputBuffer;
import bluej.terminal.Terminal;
import bluej.terminal.TerminalDocument;
import bluej.terminal.TerminalView;
import bluej.utility.Debug;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public final class TermTextArea
extends JEditorPane
implements MouseMotionListener,
MouseListener {
    private static final int BUFFER_LINES = 48;
    private boolean unlimitedBuffer = false;
    private InputBuffer buffer;
    private Terminal terminal;
    private int preferredRows;
    private int preferredColumns;

    public TermTextArea(int rows, int columns, InputBuffer buffer, final Project proj, Terminal terminal, final boolean isStderr) {
        this.preferredRows = rows;
        this.preferredColumns = columns;
        this.resetPreferredSize();
        this.buffer = buffer;
        this.terminal = terminal;
        this.setEditorKit(new DefaultEditorKit(){

            @Override
            public Document createDefaultDocument() {
                return new TerminalDocument(proj, isStderr);
            }

            @Override
            public ViewFactory getViewFactory() {
                return new ViewFactory(){

                    @Override
                    public View create(Element elem) {
                        return new TerminalView(elem, isStderr);
                    }
                };
            }
        });
        if (isStderr) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }
        this.setForeground(TerminalView.getDefaultColor(isStderr));
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.resetPreferredSize();
    }

    private void resetPreferredSize() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int mwidth = metrics.charWidth('m');
        int mheight = metrics.getHeight();
        this.setPreferredSize(new Dimension(mwidth * this.preferredColumns, mheight * this.preferredRows));
    }

    public void setUnlimitedBuffering(boolean arg) {
        this.unlimitedBuffer = arg;
    }

    public void append(String s) {
        this.append(s, null);
    }

    public void append(String s, AttributeSet attribs) {
        int lines;
        int length = this.getDocument().getLength();
        try {
            this.getDocument().insertString(length, s, attribs);
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
        if (!this.unlimitedBuffer && (lines = this.getLineCount()) > 48) {
            int linePos = this.getLineStartOffset(lines - 48);
            this.replaceRange(null, 0, linePos);
        }
    }

    public void appendMethodCall(String s) {
        int lineCount;
        int length = this.getDocument().getLength();
        if (length != this.getLineStartOffset((lineCount = this.getLineCount()) - 1)) {
            this.append("\n");
            ++lineCount;
        }
        this.append(s, null);
        TerminalDocument doc = (TerminalDocument)this.getDocument();
        doc.markLineAsMethodOutput(lineCount - 1);
    }

    public int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        return this.getDocument().getDefaultRootElement().getElement(line).getStartOffset();
    }

    public void replaceRange(String s, int startPos, int endPos) {
        try {
            this.getDocument().remove(startPos, endPos - startPos);
            if (s != null) {
                this.getDocument().insertString(startPos, s, null);
            }
        }
        catch (BadLocationException ble) {
            throw new RuntimeException(ble);
        }
    }

    @Override
    public void paste() {
        if (!this.terminal.checkActive()) {
            return;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            String result = null;
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                Debug.message(ex.getMessage());
            }
            catch (IOException ex) {
                Debug.message(ex.getMessage());
            }
            if (result != null) {
                for (char ch : result.toCharArray()) {
                    if (!this.buffer.putChar(ch)) continue;
                    this.terminal.writeToTerminal(String.valueOf(ch));
                }
            }
        } else {
            super.paste();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        ExceptionSourceLocation sel;
        TermTextArea editor = this;
        Point pt = new Point(e.getX(), e.getY());
        int pos = editor.getUI().viewToModel(editor, pt);
        Document doc = this.getDocument();
        int elementIndex = doc.getDefaultRootElement().getElementIndex(pos);
        Element el = doc.getDefaultRootElement().getElement(elementIndex);
        Cursor cursor = Cursor.getPredefinedCursor(0);
        AttributeSet attrs = el.getAttributes();
        if (attrs != null && attrs.getAttribute("source-location") != null && pos >= (sel = (ExceptionSourceLocation)attrs.getAttribute("source-location")).getStart() && pos < sel.getEnd()) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        editor.setCursor(cursor);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        ExceptionSourceLocation sel;
        TermTextArea editor = this;
        Point pt = new Point(e.getX(), e.getY());
        int pos = editor.getUI().viewToModel(editor, pt);
        Document doc = this.getDocument();
        int elementIndex = doc.getDefaultRootElement().getElementIndex(pos);
        Element el = doc.getDefaultRootElement().getElement(elementIndex);
        AttributeSet attrs = el.getAttributes();
        if (attrs != null && attrs.getAttribute("source-location") != null && pos >= (sel = (ExceptionSourceLocation)attrs.getAttribute("source-location")).getStart() && pos < sel.getEnd()) {
            sel.showInEditor();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

