/*
 * Decompiled with CFR 0.152.
 */
package bluej.testmgr.record;

import bluej.debugger.DebuggerObject;
import bluej.debugger.gentype.JavaType;
import bluej.debugmgr.objectbench.ObjectBench;
import bluej.debugmgr.objectbench.ObjectWrapper;
import bluej.pkgmgr.PkgMgrFrame;
import bluej.testmgr.record.VoidMethodInvokerRecord;
import bluej.utility.JavaNames;

public class MethodInvokerRecord
extends VoidMethodInvokerRecord {
    private JavaType returnType;
    private String benchType;
    protected String benchName;
    private int usageCount;
    private boolean methodCallInited = false;

    public MethodInvokerRecord(JavaType returnType, String command, String[] argumentValues) {
        super(command, argumentValues);
        this.returnType = returnType;
        this.benchType = returnType.toString(false);
        this.benchName = null;
    }

    @Override
    public boolean hasVoidResult() {
        return false;
    }

    @Override
    public void setBenchName(String name, String type) {
        this.benchName = name;
        this.benchType = type;
    }

    @Override
    public String toFixtureDeclaration(String firstIndent) {
        if (this.benchName == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(firstIndent);
        sb.append("private ");
        sb.append(this.benchDeclaration());
        sb.append(this.benchName);
        sb.append(";\n");
        return sb.toString();
    }

    @Override
    public String toFixtureSetup(String secondIndent) {
        if (this.benchName == null) {
            return secondIndent + this.command + ";\n";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(secondIndent);
        sb.append(this.benchAssignmentTypecast());
        sb.append(";\n");
        return sb.toString();
    }

    @Override
    public String toTestMethod(PkgMgrFrame pmf, String secondIndent) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toTestMethodInit(pmf, secondIndent));
        String resultRef = this.toExpression();
        if (this.getUsageCount() == 0) {
            sb.append(secondIndent + resultRef + ";\n");
        } else {
            for (int i = 0; i < this.getAssertionCount(); ++i) {
                sb.append(secondIndent);
                sb.append(MethodInvokerRecord.insertCommandIntoAssertionStatement(this.getAssertion(i), resultRef));
                sb.append(";\n");
            }
        }
        return sb.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String toTestMethodInit(PkgMgrFrame pkgMgrFrame, String secondIndent) {
        if (this.methodCallInited) {
            return "";
        }
        if (this.benchName == null) {
            if (this.getUsageCount() <= 1) return "";
            DebuggerObject result = this.getResultObject();
            ObjectBench bench = pkgMgrFrame.getObjectBench();
            ObjectWrapper wrapper = ObjectWrapper.getWrapper(pkgMgrFrame, bench, result, result.getGenType(), "result");
            bench.addObject(wrapper);
            this.benchName = wrapper.getName();
        } else {
            this.incUsageCount();
        }
        this.methodCallInited = true;
        return secondIndent + this.benchDeclaration() + this.benchAssignmentTypecast() + ";\n";
    }

    @Override
    public String toExpression() {
        assert (this.methodCallInited);
        if (this.benchName == null) {
            return this.command;
        }
        return this.benchName;
    }

    private String benchDeclaration() {
        return JavaNames.typeName(this.benchType) + " ";
    }

    protected String benchAssignmentTypecast() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.benchName);
        sb.append(" = ");
        if (!this.benchType.equals(this.returnType.toString(false))) {
            sb.append("(");
            sb.append(this.benchType);
            sb.append(")");
        }
        sb.append(this.command);
        return sb.toString();
    }

    @Override
    public void addAssertion(String assertion) {
        super.addAssertion(assertion);
        ++this.usageCount;
    }

    @Override
    public void incUsageCount() {
        ++this.usageCount;
    }

    private int getUsageCount() {
        return this.usageCount;
    }
}

