/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.netbeans.lib.cvsclient.connection.Connection;
import org.netbeans.lib.cvsclient.connection.ConnectionFactory;

public class CVSRoot {
    public static final String METHOD_LOCAL = "local";
    public static final String METHOD_FORK = "fork";
    public static final String METHOD_SERVER = "server";
    public static final String METHOD_PSERVER = "pserver";
    public static final String METHOD_EXT = "ext";
    private String method;
    private String username;
    private String password;
    private String hostname;
    private int port;
    private String repository;

    public static CVSRoot parse(String cvsroot) throws IllegalArgumentException {
        return new CVSRoot(cvsroot);
    }

    public static CVSRoot parse(Properties props) throws IllegalArgumentException {
        return new CVSRoot(props);
    }

    protected CVSRoot(Properties props) throws IllegalArgumentException {
        String r;
        String mtd = props.getProperty("method");
        if (mtd != null) {
            this.method = mtd.intern();
        }
        this.hostname = props.getProperty("hostname");
        if (this.hostname.length() == 0) {
            this.hostname = null;
        }
        if (this.hostname != null) {
            this.username = props.getProperty("username");
            this.password = props.getProperty("password");
            try {
                int p = Integer.parseInt(props.getProperty("port"));
                if (p <= 0) {
                    throw new IllegalArgumentException("The port is not a positive number.");
                }
                this.port = p;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("The port is not a number: '" + props.getProperty("port") + "'.");
            }
        }
        if ((r = props.getProperty("repository")) == null) {
            throw new IllegalArgumentException("Repository is obligatory.");
        }
        this.repository = r;
    }

    protected CVSRoot(String cvsroot) throws IllegalArgumentException {
        boolean localFormat;
        int colonPosition = 0;
        if (!cvsroot.startsWith(":")) {
            localFormat = cvsroot.startsWith("/");
            if (!localFormat) {
                if (cvsroot.indexOf(58) == 1 && cvsroot.indexOf(92) == 2) {
                    this.method = METHOD_LOCAL;
                    this.repository = cvsroot;
                    return;
                }
                colonPosition = cvsroot.indexOf(58);
                if (colonPosition < 0) {
                    int slash = cvsroot.indexOf(47);
                    if (slash < 0) {
                        throw new IllegalArgumentException("CVSROOT must be an absolute pathname.");
                    }
                    this.method = METHOD_SERVER;
                } else {
                    this.method = METHOD_EXT;
                }
                colonPosition = 0;
            } else {
                this.method = METHOD_LOCAL;
            }
        } else {
            colonPosition = cvsroot.indexOf(58, 1);
            if (colonPosition < 0) {
                throw new IllegalArgumentException("The connection method does not end with ':'.");
            }
            int methodNameEnd = colonPosition;
            int semicolonPosition = cvsroot.indexOf(";", 1);
            if (semicolonPosition != -1 && semicolonPosition < colonPosition) {
                methodNameEnd = semicolonPosition;
                String options = cvsroot.substring(semicolonPosition + 1, colonPosition);
                StringTokenizer tokenizer = new StringTokenizer(options, "=;");
                while (tokenizer.hasMoreTokens()) {
                    String option = tokenizer.nextToken();
                    if (!tokenizer.hasMoreTokens()) {
                        throw new IllegalArgumentException("Undefined " + option + " option value.");
                    }
                    String value = tokenizer.nextToken();
                    if ("hostname".equals(option)) {
                        this.hostname = value;
                    } else if ("username".equals(option)) {
                        this.username = value;
                    } else if ("password".equals(option)) {
                        this.password = value;
                    }
                    if (!"port".equals(option)) continue;
                    try {
                        this.port = Integer.parseInt(value, 10);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalArgumentException("Port option must be number.");
                    }
                }
            }
            this.method = cvsroot.substring(1, methodNameEnd).intern();
            if ("extssh".equals(this.method)) {
                this.method = METHOD_EXT;
            }
            if ("ssh".equals(this.method)) {
                this.method = METHOD_EXT;
            }
            ++colonPosition;
            localFormat = this.isLocalMethod(this.method);
        }
        if (localFormat) {
            this.repository = cvsroot.substring(colonPosition);
        } else {
            String userPasswdHost;
            int startSearch = cvsroot.indexOf(64, colonPosition);
            if (startSearch < 0) {
                startSearch = colonPosition;
            }
            int pathBegin = -1;
            int hostColon = cvsroot.indexOf(58, startSearch);
            if (hostColon == -1) {
                pathBegin = cvsroot.indexOf(47, startSearch);
                if (pathBegin < 0) {
                    throw new IllegalArgumentException("cvsroot " + cvsroot + " is malformed, host name is missing.");
                }
                userPasswdHost = cvsroot.substring(colonPosition, pathBegin);
            } else {
                userPasswdHost = cvsroot.substring(colonPosition, hostColon);
            }
            int at = userPasswdHost.indexOf(64);
            if (at == -1) {
                if (userPasswdHost.length() > 0) {
                    this.hostname = userPasswdHost;
                }
            } else {
                String up = userPasswdHost.substring(0, at);
                if (up.length() > 0) {
                    int upDivider = up.indexOf(58);
                    if (upDivider != -1) {
                        this.username = up.substring(0, upDivider);
                        this.password = up.substring(upDivider + 1);
                    } else {
                        this.username = up;
                    }
                }
                this.hostname = userPasswdHost.substring(at + 1);
            }
            if (this.hostname == null || this.hostname.length() == 0) {
                throw new IllegalArgumentException("Didn't specify hostname in CVSROOT '" + cvsroot + "'.");
            }
            if (hostColon > 0) {
                char c;
                String pr = cvsroot.substring(hostColon + 1);
                int index = 0;
                int port = 0;
                while (pr.length() > index && Character.isDigit(c = pr.charAt(index))) {
                    int d = Character.digit(c, 10);
                    port = port * 10 + d;
                    ++index;
                }
                this.port = port;
                if (index > 0) {
                    pr = pr.substring(index);
                }
                if (pr.startsWith(":")) {
                    pr = pr.substring(1);
                }
                this.repository = pr;
            } else {
                this.port = 0;
                this.repository = cvsroot.substring(pathBegin);
            }
        }
    }

    public boolean isLocal() {
        return this.hostname == null;
    }

    public String toString() {
        if (this.hostname == null) {
            if (this.method == null) {
                return this.repository;
            }
            return ":" + this.method + ":" + this.repository;
        }
        StringBuffer buf = new StringBuffer();
        if (this.method != null) {
            buf.append(':');
            buf.append(this.method);
            buf.append(':');
        }
        if (this.username != null) {
            buf.append(this.username);
            buf.append('@');
        }
        buf.append(this.hostname);
        buf.append(':');
        if (this.port > 0) {
            buf.append(this.port);
        }
        buf.append(this.repository);
        return buf.toString();
    }

    public int getCompatibilityLevel(CVSRoot compared) {
        if (this.equals(compared)) {
            return 0;
        }
        boolean sameRepository = this.isSameRepository(compared);
        boolean sameHost = this.isSameHost(compared);
        boolean sameMethod = this.isSameMethod(compared);
        boolean samePort = this.isSamePort(compared);
        boolean sameUser = this.isSameUser(compared);
        if (sameRepository && sameHost && sameMethod && samePort && sameUser) {
            return 1;
        }
        if (sameRepository && sameHost && sameMethod) {
            return 2;
        }
        if (sameRepository && sameHost) {
            return 3;
        }
        return -1;
    }

    private boolean isSameRepository(CVSRoot compared) {
        if (this.repository.equals(compared.repository)) {
            return true;
        }
        try {
            return new File(this.repository).getCanonicalFile().equals(new File(compared.repository).getCanonicalFile());
        }
        catch (IOException ioe) {
            return false;
        }
    }

    private boolean isSameHost(CVSRoot compared) {
        String comparedHostName = compared.getHostName();
        if (this.hostname == comparedHostName) {
            return true;
        }
        if (this.hostname != null) {
            return this.hostname.equalsIgnoreCase(comparedHostName);
        }
        return false;
    }

    private boolean isSameMethod(CVSRoot compared) {
        if (this.method == null) {
            return compared.getMethod() == null;
        }
        return this.method.equals(compared.getMethod());
    }

    private boolean isSamePort(CVSRoot compared) {
        if (this.isLocal() == compared.isLocal()) {
            if (this.isLocal()) {
                return true;
            }
            if (this.port == compared.getPort()) {
                return true;
            }
            try {
                Connection c1 = ConnectionFactory.getConnection(this);
                Connection c2 = ConnectionFactory.getConnection(compared);
                return c1.getPort() == c2.getPort();
            }
            catch (IllegalArgumentException iaex) {
                return false;
            }
        }
        return false;
    }

    private boolean isSameUser(CVSRoot compared) {
        String user = compared.getUserName();
        if (user == this.getUserName()) {
            return true;
        }
        if (user != null) {
            return user.equals(this.getUserName());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CVSRoot)) {
            return false;
        }
        CVSRoot compared = (CVSRoot)o;
        return this.toString().equals(compared.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getMethod() {
        return this.method;
    }

    protected void setMethod(String method) {
        if (method != null) {
            this.method = method.intern();
        } else {
            method = null;
        }
        if (this.isLocalMethod(method)) {
            this.username = null;
            this.password = null;
            this.hostname = null;
            this.port = 0;
        } else if (this.hostname == null) {
            throw new IllegalArgumentException("Hostname must not be null when setting a remote method.");
        }
    }

    private boolean isLocalMethod(String method) {
        return METHOD_LOCAL == method || METHOD_FORK == method;
    }

    public String getUserName() {
        return this.username;
    }

    protected void setUserName(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    public String getHostName() {
        return this.hostname;
    }

    protected void setHostName(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRepository() {
        return this.repository;
    }

    protected void setRepository(String repository) {
        if (repository == null) {
            throw new IllegalArgumentException("The repository must not be null.");
        }
        this.repository = repository;
    }
}

