/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormBindingGroup;
import com.jformdesigner.model.FormBindingVisitor;
import com.jformdesigner.model.FormModelEventProvider;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormReference;
import java.util.Iterator;
import java.util.Map;

public class FormBinding
extends FormObject {
    public static final String PROP_SOURCE = "source";
    public static final String PROP_SOURCE_PATH = "sourcePath";
    public static final String PROP_TARGET = "target";
    public static final String PROP_TARGET_PATH = "targetPath";
    private FormBindingGroup bindingGroup;

    public FormBinding() {
    }

    public FormBinding(String source, String sourcePath, String target, String targetPath) {
        this.setProperty(PROP_SOURCE, source);
        this.setProperty(PROP_SOURCE_PATH, sourcePath);
        this.setProperty(PROP_TARGET, target);
        this.setProperty(PROP_TARGET_PATH, targetPath);
    }

    FormBinding(FormBinding obj) {
        super(obj, 0);
    }

    public Object clone() {
        return new FormBinding(this);
    }

    public String getSource() {
        return this.getPropertyString(PROP_SOURCE);
    }

    public String getSourcePath() {
        return this.getPropertyString(PROP_SOURCE_PATH);
    }

    public String getTarget() {
        return this.getPropertyString(PROP_TARGET);
    }

    public String getTargetPath() {
        return this.getPropertyString(PROP_TARGET_PATH);
    }

    public FormBindingGroup getBindingGroup() {
        return this.bindingGroup;
    }

    void setBindingGroup(FormBindingGroup bindingGroup) {
        if (this.bindingGroup != null && bindingGroup != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.bindingGroup + "\", new=\"" + bindingGroup + "\").");
        }
        this.bindingGroup = bindingGroup;
    }

    public boolean accept(FormBindingVisitor visitor) {
        return visitor.visit(this);
    }

    private FormModelEventProvider getEventProvider() {
        return this.bindingGroup != null ? this.bindingGroup.getEventProvider() : null;
    }

    void firePropertyChanged(String name, int index, Object oldValue, Object newValue) {
        FormModelEventProvider eventProvider = this.getEventProvider();
        if (eventProvider != null) {
            eventProvider.fireBindingPropertyChanged(this, name, index, oldValue, newValue);
        }
    }

    void updateReferences(String oldName, String newName) {
        super.updateReferences(oldName, newName);
        if (oldName.equals(this.getSource())) {
            this.setProperty(PROP_SOURCE, newName);
        }
        if (oldName.equals(this.getTarget())) {
            this.setProperty(PROP_TARGET, newName);
        }
        Iterator<Map.Entry<String, Object>> i$ = this.properties().iterator();
        while (i$.hasNext()) {
            Map.Entry<String, Object> entry = i$.next();
            Object value = entry.getValue();
            if (!(value instanceof FormBinding[])) continue;
            this.updateReferencesInSubBindings(entry.getKey(), (FormBinding[])value, oldName, newName);
        }
    }

    private void updateReferencesInSubBindings(String name, FormBinding[] subBindings, String oldName, String newName) {
        FormBinding[] newSubBindings = null;
        block0: for (int i = 0; i < subBindings.length; ++i) {
            FormBinding subBinding = subBindings[i];
            int refCount = subBinding.getReferenceCount();
            if (refCount == 0) continue;
            Iterator<Map.Entry<String, Object>> i$ = subBinding.properties().iterator();
            while (i$.hasNext()) {
                Map.Entry<String, Object> subEntry = i$.next();
                Object subValue = subEntry.getValue();
                if (!(subValue instanceof FormReference)) continue;
                if (oldName.equals(((FormReference)subValue).getName())) {
                    if (newSubBindings == null) {
                        newSubBindings = FormBinding.clone(subBindings);
                    }
                    newSubBindings[i].setProperty(subEntry.getKey(), newName != null ? new FormReference(newName) : null);
                }
                if (--refCount > 0) continue;
                continue block0;
            }
        }
        if (newSubBindings != null) {
            this.setProperty(name, newSubBindings);
        }
    }

    public static FormBinding[] clone(FormBinding[] bindings) {
        FormBinding[] newBindings = new FormBinding[bindings.length];
        for (int i = 0; i < bindings.length; ++i) {
            newBindings[i] = (FormBinding)bindings[i].clone();
        }
        return newBindings;
    }

    public String toString() {
        return FormBinding.unqualifiedClassName(this.getClass()) + " " + super.toString();
    }
}

