/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormAuxiliaryProperties;
import com.jformdesigner.model.FormComponentVisitor;
import com.jformdesigner.model.FormContainer;
import com.jformdesigner.model.FormEvent;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.model.FormModel;
import com.jformdesigner.model.FormObject;
import com.jformdesigner.model.FormSelectable;
import java.util.ArrayList;

public class FormComponent
extends FormObject
implements FormSelectable {
    public static final String FIELD_NAME = "name";
    private String name;
    private final String className;
    private FormContainer parent;
    FormModel model;
    private ArrayList<FormEvent> events;
    private FormAuxiliaryProperties auxiliaryProperties;

    public FormComponent(String className) {
        this.className = className;
    }

    FormComponent(FormComponent obj, int dummy) {
        super(obj, dummy);
        this.name = obj.name;
        this.className = obj.className;
        if (obj.hasAuxiliary()) {
            this.auxiliaryProperties = new FormAuxiliaryProperties(this, obj.auxiliaryProperties);
        }
        int eventCount = obj.getEventCount();
        for (int i = 0; i < eventCount; ++i) {
            this.addEvent(new FormEvent(obj.getEvent(i)));
        }
    }

    public Object clone() {
        return new FormComponent(this, 0);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        this.name = name;
        if (this.model != null) {
            if (this.model.nameRegistry != null) {
                this.model.nameRegistry.componentFieldChanged(this, FIELD_NAME, oldName, name);
            }
            if (this.model.eventProvider != null) {
                this.model.eventProvider.fireComponentFieldChanged(this, FIELD_NAME, oldName, name);
            }
            if (oldName != null) {
                this.model.updateReferences(oldName, name);
            }
        } else if (oldName != null) {
            FormComponent root = this;
            while (root.parent != null) {
                root = root.parent;
            }
            root.updateReferences(oldName, name);
        }
    }

    public String getClassName() {
        return this.className;
    }

    public FormContainer getParent() {
        return this.parent;
    }

    void setParent(FormContainer parent) {
        this.parent = parent;
    }

    public FormModel getModel() {
        return this.model;
    }

    void setModel(FormModel model) {
        if (this.model != null && model != null) {
            throw new IllegalStateException("Already attached (current=\"" + this.model + "\", new=\"" + model + "\").");
        }
        this.model = model;
    }

    public FormObject auxiliary() {
        if (this.auxiliaryProperties == null) {
            this.auxiliaryProperties = new FormAuxiliaryProperties(this);
        }
        return this.auxiliaryProperties;
    }

    public boolean hasAuxiliary() {
        return this.auxiliaryProperties != null && this.auxiliaryProperties.getPropertyCount() > 0;
    }

    public String getAuxiliaryPropertyString(String name, String def) {
        if (this.auxiliaryProperties == null) {
            return def;
        }
        return this.auxiliaryProperties.getPropertyString(name, def);
    }

    public int getAuxiliaryPropertyInt(String name, int def) {
        if (this.auxiliaryProperties == null) {
            return def;
        }
        return this.auxiliaryProperties.getPropertyInt(name, def);
    }

    public boolean getAuxiliaryPropertyBoolean(String name, boolean def) {
        if (this.auxiliaryProperties == null) {
            return def;
        }
        return this.auxiliaryProperties.getPropertyBoolean(name, def);
    }

    void firePropertyChanged(String name, int index, Object oldValue, Object newValue) {
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireComponentPropertyChanged(this, name, index, oldValue, newValue);
        }
    }

    public FormLayoutConstraints getConstraints() {
        FormLayoutManager layout;
        if (this.parent != null && (layout = this.parent.getLayout()) != null) {
            return layout.getConstraints(this);
        }
        return null;
    }

    public boolean accept(FormComponentVisitor visitor) {
        return visitor.visit(this);
    }

    public int getEventCount() {
        return this.events != null ? this.events.size() : 0;
    }

    public FormEvent getEvent(int index) {
        return this.events.get(index);
    }

    public FormEvent[] getEvents() {
        return this.events != null ? this.events.toArray(new FormEvent[this.events.size()]) : FormEvent.EMPTY_EVENTS;
    }

    public void addEvent(FormEvent event) {
        this.addEvent(event, -1);
    }

    public void addEvent(FormEvent event, int index) {
        if (this.events == null) {
            this.events = new ArrayList();
        }
        if (index < 0 || index == this.events.size()) {
            index = this.events.size();
            this.events.add(event);
        } else {
            this.events.add(index, event);
        }
        event.setComponent(this);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireEventAdded(this, event, index);
        }
    }

    public void removeEvent(FormEvent event) {
        if (this.events == null) {
            return;
        }
        int index = this.events.indexOf(event);
        if (index >= 0) {
            this.removeEvent(index);
        }
    }

    public void removeEvent(int index) {
        if (this.events == null) {
            return;
        }
        FormEvent event = this.events.remove(index);
        event.setComponent(null);
        if (this.model != null && this.model.eventProvider != null) {
            this.model.eventProvider.fireEventRemoved(this, event, index);
        }
    }

    public String toString() {
        return FormComponent.unqualifiedClassName(this.getClass()) + "[name=" + this.name + ",className=" + this.className + "] " + super.toString();
    }
}

