/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.model.FormModel;
import com.jformdesigner.runtime.FormXMLPersistence;
import com.jformdesigner.runtime.MultiException;
import com.jformdesigner.runtime.XMLExceptionListener;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;

public class FormSaver {
    private FormSaver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(FormModel model, OutputStream out) throws MultiException {
        if (!(out instanceof ByteArrayOutputStream) && !(out instanceof BufferedOutputStream)) {
            out = new BufferedOutputStream(out);
        }
        if ("IBM J9 VM".equals(System.getProperty("java.vm.name"))) {
            out = new FixCharOutputStream(out);
        }
        if (model.fileHeader != null) {
            out = new FileHeaderOutputStream(out, model.fileHeader);
        }
        XMLExceptionListener exceptionListener = new XMLExceptionListener();
        final ClassLoader modelClassLoader = model.getClassLoader();
        Thread currentThread = Thread.currentThread();
        ClassLoader oldContextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(modelClassLoader);
        try {
            FormXMLPersistence.initialize();
            try {
                FormXMLPersistence.initializePropertyPersistenceDelegates(model.getRoot(), modelClassLoader);
            }
            catch (Throwable ex) {
                Exception ex2 = ex instanceof Exception ? (Exception)ex : new InvocationTargetException(ex);
                throw new MultiException("Failed to initialize property persistence delegates for encoding.", new Exception[]{ex2});
            }
            XMLEncoder encoder = new XMLEncoder(out){

                @Override
                public PersistenceDelegate getPersistenceDelegate(Class<?> type) {
                    PersistenceDelegate persistenceDelegate = FormXMLPersistence.getPersistenceDelegate(type, modelClassLoader);
                    if (persistenceDelegate == null) {
                        persistenceDelegate = super.getPersistenceDelegate(type);
                    }
                    return persistenceDelegate;
                }
            };
            encoder.setExceptionListener(exceptionListener);
            encoder.writeObject(model);
            encoder.close();
        }
        finally {
            currentThread.setContextClassLoader(oldContextClassLoader);
            try {
                out.close();
            }
            catch (IOException ex) {}
        }
        if (exceptionListener.getExceptionCount() > 0) {
            throw new MultiException("Failed to encode.", exceptionListener.getExceptions());
        }
    }

    static class FixCharOutputStream
    extends ByteArrayOutputStream {
        private final OutputStream out;

        FixCharOutputStream(OutputStream out) {
            super(20480);
            this.out = out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            byte[] b;
            String s;
            super.close();
            try {
                s = this.toString("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                s = this.toString();
            }
            s = s.replaceAll("<char>&</char>", "<char>&amp;</char>");
            s = s.replaceAll("<char><</char>", "<char>&lt;</char>");
            s = s.replaceAll("<char>></char>", "<char>&gt;</char>");
            s = s.replaceAll("<char>\"</char>", "<char>&quot;</char>");
            s = s.replaceAll("<char>'</char>", "<char>&apos;</char>");
            s = s.replaceAll("<char>\r</char>", "<char>&#13;</char>");
            s = s.replaceAll("<object class=\"([^\"]+)\" method=\"getField\">[\\s]*<string>([^<]+)</string>[\\s]*</object>", "<object class=\"$1\" field=\"$2\"/>");
            try {
                b = s.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                b = s.getBytes();
            }
            try {
                this.out.write(b);
            }
            finally {
                this.out.close();
            }
        }
    }

    private static class FileHeaderOutputStream
    extends FilterOutputStream {
        private String fileHeader;

        FileHeaderOutputStream(OutputStream out, String fileHeader) {
            super(out);
            this.fileHeader = fileHeader;
        }

        public void write(int b) throws IOException {
            super.write(b);
            if (this.fileHeader != null && b == 10) {
                this.out.write("<!--\n".getBytes("UTF-8"));
                this.out.write(this.fileHeader.getBytes("UTF-8"));
                this.out.write("\n-->\n".getBytes("UTF-8"));
                this.fileHeader = null;
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (this.fileHeader != null) {
                super.write(b, off, len);
            } else {
                this.out.write(b, off, len);
            }
        }
    }
}

