/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.BeanInfoEx;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntrospectorEx {
    private static Hook hook;
    private static Map<Class<?>, BeanInfoEx> beanInfoCache;

    public static Hook getHook() {
        return hook;
    }

    public static void setHook(Hook hook) {
        IntrospectorEx.hook = hook;
    }

    public static void useHardRefCache() {
        beanInfoCache = Collections.synchronizedMap(new HashMap(100));
    }

    public static BeanInfoEx getBeanInfoEx(Class<?> beanClass) throws IntrospectionException {
        BeanInfoEx beanInfoEx = beanInfoCache.get(beanClass);
        if (beanInfoEx == null) {
            BeanInfo beanInfo = hook != null ? hook.getBeanInfo(beanClass) : Introspector.getBeanInfo(beanClass);
            beanInfoEx = new BeanInfoEx(beanInfo);
            beanInfoCache.put(beanClass, beanInfoEx);
        }
        return beanInfoEx;
    }

    public static void flushCaches() {
        beanInfoCache.clear();
        if (hook != null) {
            hook.flushCaches();
        } else {
            Introspector.flushCaches();
        }
    }

    public static void flushFromCaches(Class<?> beanClass) {
        beanInfoCache.remove(beanClass);
        if (hook != null) {
            hook.flushFromCaches(beanClass);
        } else {
            Introspector.flushFromCaches(beanClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void flushCaches(ClassLoader classLoader) {
        Map<Class<?>, BeanInfoEx> map = beanInfoCache;
        synchronized (map) {
            Iterator<Class<?>> it = beanInfoCache.keySet().iterator();
            while (it.hasNext()) {
                Class<?> cls = it.next();
                if (cls.getClassLoader() != classLoader) continue;
                it.remove();
                do {
                    if (hook != null) {
                        hook.flushFromCaches(cls);
                        continue;
                    }
                    Introspector.flushFromCaches(cls);
                } while ((cls = cls.getSuperclass()) != null && cls.getClassLoader() == classLoader);
            }
        }
        if (hook != null) {
            hook.flushCaches(classLoader);
        }
    }

    static {
        beanInfoCache = Collections.synchronizedMap(new WeakHashMap(100));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Hook {
        public BeanInfo getBeanInfo(Class<?> var1) throws IntrospectionException;

        public void flushCaches();

        public void flushFromCaches(Class<?> var1);

        public void flushCaches(ClassLoader var1);
    }
}

