/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.jformdesigner.runtime.FormLoader$JFDMLException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

class FormLoader$FileHeaderInputStream
extends FilterInputStream {
    private static final byte[] HEADER_END_MARKER = "\n<java".getBytes();
    private byte[] buffer;
    private int count;
    private int endMarkerIndex;
    private boolean finished;
    private boolean jfdmlChecked;
    private byte[] firstBytes = new byte["JFDML".length()];
    private int firstBytesIndex;

    FormLoader$FileHeaderInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() {
        int n2 = super.read();
        if (!this.finished && n2 != -1) {
            this.record(n2);
        }
        if (!this.jfdmlChecked) {
            if (this.firstBytesIndex < this.firstBytes.length) {
                this.firstBytes[this.firstBytesIndex++] = (byte)n2;
            } else {
                this.checkJFDML();
            }
        }
        return n2;
    }

    public int read(byte[] byArray, int n2, int n3) {
        int n4;
        int n5 = super.read(byArray, n2, n3);
        if (!this.finished) {
            for (n4 = 0; n4 < n5; ++n4) {
                if (this.finished) continue;
                this.record(byArray[n4]);
            }
        }
        if (!this.jfdmlChecked && n5 > 0) {
            n4 = Math.min(n5, this.firstBytes.length - this.firstBytesIndex);
            System.arraycopy(byArray, n2, this.firstBytes, this.firstBytesIndex, n4);
            this.firstBytesIndex += n4;
            if (this.firstBytesIndex >= this.firstBytes.length) {
                this.checkJFDML();
            }
        }
        return n5;
    }

    private void record(int n2) {
        if (this.buffer != null) {
            if (this.count >= this.buffer.length) {
                int n3 = this.buffer.length < 100 ? 512 : this.buffer.length * 2;
                byte[] byArray = new byte[n3];
                System.arraycopy(this.buffer, 0, byArray, 0, this.buffer.length);
                this.buffer = byArray;
            }
            this.buffer[this.count++] = (byte)n2;
            if (n2 == HEADER_END_MARKER[this.endMarkerIndex]) {
                ++this.endMarkerIndex;
                if (this.endMarkerIndex == HEADER_END_MARKER.length) {
                    this.finished = true;
                    this.count -= HEADER_END_MARKER.length;
                }
            } else {
                this.endMarkerIndex = 0;
            }
        } else if (n2 == 10) {
            this.buffer = new byte[HEADER_END_MARKER.length];
            if (n2 == HEADER_END_MARKER[0]) {
                ++this.endMarkerIndex;
                this.buffer[this.count++] = (byte)n2;
            }
        }
    }

    public String getFileHeader() {
        if (this.count == 0) {
            return null;
        }
        try {
            String string = new String(this.buffer, 0, this.count, "UTF-8");
            string = string.trim();
            if (string.startsWith("<!--") && string.endsWith("-->")) {
                int n2 = "<!--".length();
                int n3 = string.length() - "-->".length();
                if (string.charAt(n2) == '\n') {
                    ++n2;
                }
                if (string.charAt(n3 - 1) == '\n') {
                    --n3;
                }
                return string.substring(n2, n3);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return null;
    }

    private void checkJFDML() {
        this.jfdmlChecked = true;
        if (Arrays.equals(this.firstBytes, "JFDML".getBytes())) {
            throw new FormLoader$JFDMLException(null);
        }
    }
}

