/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.AbstractFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ComponentFactory;
import com.jgoodies.forms.factories.ComponentFactory2;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;

public class PanelBuilder
extends AbstractFormBuilder {
    private static final String LABELED_BY_PROPERTY = "labeledBy";
    private static boolean labelForFeatureEnabledDefault = false;
    private ComponentFactory componentFactory;
    private boolean labelForFeatureEnabled = labelForFeatureEnabledDefault;
    private WeakReference mostRecentlyAddedLabelReference = null;

    public PanelBuilder(FormLayout formLayout) {
        this(formLayout, new JPanel(null));
    }

    public PanelBuilder(FormLayout formLayout, JPanel jPanel) {
        super(formLayout, jPanel);
    }

    public static boolean getLabelForFeatureEnabledDefault() {
        return labelForFeatureEnabledDefault;
    }

    public static void setLabelForFeatureEnabledDefault(boolean bl2) {
        labelForFeatureEnabledDefault = bl2;
    }

    public boolean isLabelForFeatureEnabled() {
        return this.labelForFeatureEnabled;
    }

    public void setLabelForFeatureEnabled(boolean bl2) {
        this.labelForFeatureEnabled = bl2;
    }

    public final JPanel getPanel() {
        return (JPanel)this.getContainer();
    }

    public final void setBackground(Color color) {
        this.getPanel().setBackground(color);
    }

    public final void setBorder(Border border) {
        this.getPanel().setBorder(border);
    }

    public final void setDefaultDialogBorder() {
        this.setBorder(Borders.DIALOG_BORDER);
    }

    public final void setOpaque(boolean bl2) {
        this.getPanel().setOpaque(bl2);
    }

    public final JLabel addLabel(String string) {
        return this.addLabel(string, this.cellConstraints());
    }

    public final JLabel addLabel(String string, CellConstraints cellConstraints) {
        JLabel jLabel = this.getComponentFactory().createLabel(string);
        this.add((Component)jLabel, cellConstraints);
        return jLabel;
    }

    public final JLabel addLabel(String string, String string2) {
        return this.addLabel(string, new CellConstraints(string2));
    }

    public final JLabel addLabel(String string, CellConstraints cellConstraints, Component component, CellConstraints cellConstraints2) {
        if (cellConstraints == cellConstraints2) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        JLabel jLabel = this.addLabel(string, cellConstraints);
        this.add(component, cellConstraints2);
        jLabel.setLabelFor(component);
        return jLabel;
    }

    public final JLabel addROLabel(String string) {
        return this.addROLabel(string, this.cellConstraints());
    }

    public final JLabel addROLabel(String string, CellConstraints cellConstraints) {
        ComponentFactory componentFactory = this.getComponentFactory();
        ComponentFactory2 componentFactory2 = componentFactory instanceof ComponentFactory2 ? (ComponentFactory2)componentFactory : DefaultComponentFactory.getInstance();
        JLabel jLabel = componentFactory2.createReadOnlyLabel(string);
        this.add((Component)jLabel, cellConstraints);
        return jLabel;
    }

    public final JLabel addROLabel(String string, String string2) {
        return this.addROLabel(string, new CellConstraints(string2));
    }

    public final JLabel addROLabel(String string, CellConstraints cellConstraints, Component component, CellConstraints cellConstraints2) {
        if (cellConstraints == cellConstraints2) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        JLabel jLabel = this.addROLabel(string, cellConstraints);
        this.add(component, cellConstraints2);
        jLabel.setLabelFor(component);
        return jLabel;
    }

    public final JLabel addTitle(String string) {
        return this.addTitle(string, this.cellConstraints());
    }

    public final JLabel addTitle(String string, CellConstraints cellConstraints) {
        JLabel jLabel = this.getComponentFactory().createTitle(string);
        this.add((Component)jLabel, cellConstraints);
        return jLabel;
    }

    public final JLabel addTitle(String string, String string2) {
        return this.addTitle(string, new CellConstraints(string2));
    }

    public final JComponent addSeparator(String string) {
        return this.addSeparator(string, this.getLayout().getColumnCount());
    }

    public final JComponent addSeparator(String string, CellConstraints cellConstraints) {
        int n2 = this.isLeftToRight() ? 2 : 4;
        JComponent jComponent = this.getComponentFactory().createSeparator(string, n2);
        this.add((Component)jComponent, cellConstraints);
        return jComponent;
    }

    public final JComponent addSeparator(String string, String string2) {
        return this.addSeparator(string, new CellConstraints(string2));
    }

    public final JComponent addSeparator(String string, int n2) {
        return this.addSeparator(string, this.createLeftAdjustedConstraints(n2));
    }

    public final JLabel add(JLabel jLabel, CellConstraints cellConstraints, Component component, CellConstraints cellConstraints2) {
        if (cellConstraints == cellConstraints2) {
            throw new IllegalArgumentException("You must provide two CellConstraints instances, one for the label and one for the component.\nConsider using #clone(). See the JavaDocs for details.");
        }
        this.add((Component)jLabel, cellConstraints);
        this.add(component, cellConstraints2);
        jLabel.setLabelFor(component);
        return jLabel;
    }

    public final ComponentFactory getComponentFactory() {
        if (this.componentFactory == null) {
            this.componentFactory = DefaultComponentFactory.getInstance();
        }
        return this.componentFactory;
    }

    public final void setComponentFactory(ComponentFactory componentFactory) {
        this.componentFactory = componentFactory;
    }

    public Component add(Component component, CellConstraints cellConstraints) {
        Component component2 = super.add(component, cellConstraints);
        if (!this.isLabelForFeatureEnabled()) {
            return component2;
        }
        JLabel jLabel = this.getMostRecentlyAddedLabel();
        if (jLabel != null && this.isLabelForApplicable(jLabel, component)) {
            this.setLabelFor(jLabel, component);
            this.clearMostRecentlyAddedLabel();
        }
        if (component instanceof JLabel) {
            this.setMostRecentlyAddedLabel((JLabel)component);
        }
        return component2;
    }

    protected boolean isLabelForApplicable(JLabel jLabel, Component component) {
        if (jLabel.getLabelFor() != null) {
            return false;
        }
        if (!component.isFocusable()) {
            return false;
        }
        if (!(component instanceof JComponent)) {
            return true;
        }
        JComponent jComponent = (JComponent)component;
        return jComponent.getClientProperty(LABELED_BY_PROPERTY) == null;
    }

    protected void setLabelFor(JLabel jLabel, Component component) {
        Component component2;
        if (component instanceof JScrollPane) {
            JScrollPane jScrollPane = (JScrollPane)component;
            component2 = jScrollPane.getViewport().getView();
        } else {
            component2 = component;
        }
        jLabel.setLabelFor(component2);
    }

    private JLabel getMostRecentlyAddedLabel() {
        if (this.mostRecentlyAddedLabelReference == null) {
            return null;
        }
        JLabel jLabel = (JLabel)this.mostRecentlyAddedLabelReference.get();
        if (jLabel == null) {
            return null;
        }
        return jLabel;
    }

    private void setMostRecentlyAddedLabel(JLabel jLabel) {
        this.mostRecentlyAddedLabelReference = new WeakReference<JLabel>(jLabel);
    }

    private void clearMostRecentlyAddedLabel() {
        this.mostRecentlyAddedLabelReference = null;
    }
}

