/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.layout;

import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormSpecParser$FormLayoutParseException;
import com.jgoodies.forms.layout.FormSpecParser$Multiplier;
import com.jgoodies.forms.layout.LayoutMap;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.FormUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormSpecParser {
    private static final Pattern MULTIPLIER_PREFIX_PATTERN = Pattern.compile("\\d+\\s*\\*\\s*\\(");
    private static final Pattern DIGIT_PATTERN = Pattern.compile("\\d+");
    private final String source;
    private final LayoutMap layoutMap;

    private FormSpecParser(String string, String string2, LayoutMap layoutMap, boolean bl2) {
        FormUtils.assertNotNull(string, string2);
        FormUtils.assertNotNull(layoutMap, "LayoutMap");
        this.layoutMap = layoutMap;
        this.source = this.layoutMap.expand(string, bl2);
    }

    static ColumnSpec[] parseColumnSpecs(String string, LayoutMap layoutMap) {
        FormSpecParser formSpecParser = new FormSpecParser(string, "encoded column specifications", layoutMap, true);
        return formSpecParser.parseColumnSpecs();
    }

    static RowSpec[] parseRowSpecs(String string, LayoutMap layoutMap) {
        FormSpecParser formSpecParser = new FormSpecParser(string, "encoded column specifications", layoutMap, false);
        return formSpecParser.parseRowSpecs();
    }

    private ColumnSpec[] parseColumnSpecs() {
        List list = this.split(this.source, 0);
        int n2 = list.size();
        ColumnSpec[] columnSpecArray = new ColumnSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)list.get(i2);
            columnSpecArray[i2] = ColumnSpec.decodeExpanded(string);
        }
        return columnSpecArray;
    }

    private RowSpec[] parseRowSpecs() {
        List list = this.split(this.source, 0);
        int n2 = list.size();
        RowSpec[] rowSpecArray = new RowSpec[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = (String)list.get(i2);
            rowSpecArray[i2] = RowSpec.decodeExpanded(string);
        }
        return rowSpecArray;
    }

    private List split(String string, int n2) {
        ArrayList arrayList = new ArrayList();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        int n7 = 0;
        boolean bl2 = true;
        for (int i2 = 0; i2 < n6; ++i2) {
            char c2 = string.charAt(i2);
            if (bl2 && Character.isWhitespace(c2)) {
                ++n7;
                continue;
            }
            bl2 = false;
            if (c2 == ',' && n3 == 0 && n4 == 0 && n5 == 0) {
                String string2 = string.substring(n7, i2);
                this.addSpec(arrayList, string2, n2 + n7);
                n7 = i2 + 1;
                bl2 = true;
                continue;
            }
            if (c2 == '(') {
                if (n4 > 0) {
                    this.fail(n2 + i2, "illegal '(' in [...]");
                }
                ++n3;
                continue;
            }
            if (c2 == ')') {
                if (n4 > 0) {
                    this.fail(n2 + i2, "illegal ')' in [...]");
                }
                if (--n3 >= 0) continue;
                this.fail(n2 + i2, "missing '('");
                continue;
            }
            if (c2 == '[') {
                if (n4 > 0) {
                    this.fail(n2 + i2, "too many '['");
                }
                ++n4;
                continue;
            }
            if (c2 == ']') {
                if (--n4 >= 0) continue;
                this.fail(n2 + i2, "missing '['");
                continue;
            }
            if (c2 != '\'') continue;
            if (n5 == 0) {
                ++n5;
                continue;
            }
            if (n5 != 1) continue;
            --n5;
        }
        if (n3 > 0) {
            this.fail(n2 + n6, "missing ')'");
        }
        if (n4 > 0) {
            this.fail(n2 + n6, "missing ']");
        }
        if (n7 < n6) {
            String string3 = string.substring(n7);
            this.addSpec(arrayList, string3, n2 + n7);
        }
        return arrayList;
    }

    private void addSpec(List list, String string, int n2) {
        String string2 = string.trim();
        FormSpecParser$Multiplier formSpecParser$Multiplier = this.multiplier(string2, n2);
        if (formSpecParser$Multiplier == null) {
            list.add(string2);
            return;
        }
        List list2 = this.split(formSpecParser$Multiplier.expression, n2 + formSpecParser$Multiplier.offset);
        for (int i2 = 0; i2 < formSpecParser$Multiplier.multiplier; ++i2) {
            list.addAll(list2);
        }
    }

    private FormSpecParser$Multiplier multiplier(String string, int n2) {
        Matcher matcher;
        Matcher matcher2 = MULTIPLIER_PREFIX_PATTERN.matcher(string);
        if (!matcher2.find()) {
            return null;
        }
        if (matcher2.start() > 0) {
            this.fail(n2 + matcher2.start(), "illegal multiplier position");
        }
        if (!(matcher = DIGIT_PATTERN.matcher(string)).find()) {
            return null;
        }
        String string2 = string.substring(0, matcher.end());
        int n3 = 0;
        try {
            n3 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            this.fail(n2, numberFormatException);
        }
        if (n3 <= 0) {
            this.fail(n2, "illegal 0 multiplier");
        }
        String string3 = string.substring(matcher2.end(), string.length() - 1);
        return new FormSpecParser$Multiplier(n3, string3, matcher2.end());
    }

    public static void fail(String string, int n2, String string2) {
        throw new FormSpecParser$FormLayoutParseException(FormSpecParser.message(string, n2, string2));
    }

    private void fail(int n2, String string) {
        throw new FormSpecParser$FormLayoutParseException(FormSpecParser.message(this.source, n2, string));
    }

    private void fail(int n2, NumberFormatException numberFormatException) {
        throw new FormSpecParser$FormLayoutParseException(FormSpecParser.message(this.source, n2, "Invalid multiplier"), numberFormatException);
    }

    private static String message(String string, int n2, String string2) {
        StringBuffer stringBuffer = new StringBuffer(10);
        stringBuffer.append('\n');
        stringBuffer.append(string);
        stringBuffer.append('\n');
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(' ');
        }
        stringBuffer.append('^');
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        throw new FormSpecParser$FormLayoutParseException(string3);
    }
}

