/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticBumps;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.plastic.PlasticUtils;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalInternalFrameTitlePane;

public final class PlasticInternalFrameTitlePane
extends MetalInternalFrameTitlePane {
    private PlasticBumps paletteBumps;
    private final PlasticBumps activeBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlDarkShadow(), PlasticLookAndFeel.getPrimaryControl());
    private final PlasticBumps inactiveBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getControlHighlight(), PlasticLookAndFeel.getControlDarkShadow(), PlasticLookAndFeel.getControl());

    public PlasticInternalFrameTitlePane(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public void paintPalette(Graphics graphics) {
        boolean bl2 = PlasticUtils.isLeftToRight(this.frame);
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.paletteBumps == null) {
            this.paletteBumps = new PlasticBumps(0, 0, PlasticLookAndFeel.getPrimaryControlHighlight(), PlasticLookAndFeel.getPrimaryControlInfo(), PlasticLookAndFeel.getPrimaryControlShadow());
        }
        ColorUIResource colorUIResource = PlasticLookAndFeel.getPrimaryControlShadow();
        ColorUIResource colorUIResource2 = PlasticLookAndFeel.getControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n2, n3);
        graphics.setColor(colorUIResource2);
        graphics.drawLine(0, n3 - 1, n2, n3 - 1);
        int n4 = this.getButtonsWidth();
        int n5 = bl2 ? 4 : n4 + 4;
        int n6 = n2 - n4 - 8;
        int n7 = this.getHeight() - 4;
        this.paletteBumps.setBumpArea(n6, n7);
        this.paletteBumps.paintIcon(this, graphics, n5, 2);
    }

    public void paintComponent(Graphics graphics) {
        int n2;
        int n3;
        int n4;
        int n5;
        PlasticBumps plasticBumps;
        if (this.isPalette) {
            this.paintPalette(graphics);
            return;
        }
        boolean bl2 = PlasticUtils.isLeftToRight(this.frame);
        boolean bl3 = this.frame.isSelected();
        int n6 = this.getWidth();
        int n7 = this.getHeight();
        ColorUIResource colorUIResource = null;
        ColorUIResource colorUIResource2 = null;
        ColorUIResource colorUIResource3 = null;
        if (bl3) {
            colorUIResource = PlasticLookAndFeel.getWindowTitleBackground();
            colorUIResource2 = PlasticLookAndFeel.getWindowTitleForeground();
            plasticBumps = this.activeBumps;
        } else {
            colorUIResource = PlasticLookAndFeel.getWindowTitleInactiveBackground();
            colorUIResource2 = PlasticLookAndFeel.getWindowTitleInactiveForeground();
            plasticBumps = this.inactiveBumps;
        }
        colorUIResource3 = PlasticLookAndFeel.getControlDarkShadow();
        graphics.setColor(colorUIResource);
        graphics.fillRect(0, 0, n6, n7);
        graphics.setColor(colorUIResource3);
        graphics.drawLine(0, n7 - 1, n6, n7 - 1);
        graphics.drawLine(0, 0, 0, 0);
        graphics.drawLine(n6 - 1, 0, n6 - 1, 0);
        int n8 = 0;
        int n9 = bl2 ? 5 : n6 - 5;
        String string = this.frame.getTitle();
        Icon icon = this.frame.getFrameIcon();
        if (icon != null) {
            if (!bl2) {
                n9 -= icon.getIconWidth();
            }
            n5 = n7 / 2 - icon.getIconHeight() / 2;
            icon.paintIcon(this.frame, graphics, n9, n5);
            n9 += bl2 ? icon.getIconWidth() + 5 : -5;
        }
        if (string != null) {
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.setColor(colorUIResource2);
            n4 = (n7 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
            Rectangle rectangle = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                rectangle = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                rectangle = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                rectangle = this.closeButton.getBounds();
            }
            if (bl2) {
                if (rectangle.x == 0) {
                    rectangle.x = this.frame.getWidth() - this.frame.getInsets().right - 2;
                }
                n3 = rectangle.x - n9 - 4;
                string = this.getTitle(string, fontMetrics, n3);
            } else {
                n3 = n9 - rectangle.x - rectangle.width - 4;
                string = this.getTitle(string, fontMetrics, n3);
                n9 -= SwingUtilities.computeStringWidth(fontMetrics, string);
            }
            n8 = SwingUtilities.computeStringWidth(fontMetrics, string);
            graphics.drawString(string, n9, n4);
            n9 += bl2 ? n8 + 5 : -5;
        }
        n4 = this.getButtonsWidth();
        if (bl2) {
            n2 = n6 - n4 - n9 - 5;
            n5 = n9;
        } else {
            n2 = n9 - n4 - 5;
            n5 = n4 + 5;
        }
        int n10 = 3;
        n3 = this.getHeight() - 2 * n10;
        plasticBumps.setBumpArea(n2, n3);
        plasticBumps.paintIcon(this, graphics, n5, n10);
    }

    protected String getTitle(String string, FontMetrics fontMetrics, int n2) {
        if (string == null || string.equals("")) {
            return "";
        }
        int n3 = SwingUtilities.computeStringWidth(fontMetrics, string);
        String string2 = "\u2026";
        if (n3 > n2) {
            int n4;
            int n5 = SwingUtilities.computeStringWidth(fontMetrics, string2);
            for (n4 = 0; n4 < string.length() && (n5 += fontMetrics.charWidth(string.charAt(n4))) <= n2; ++n4) {
            }
            string = string.substring(0, n4) + string2;
        }
        return string;
    }

    private int getButtonsWidth() {
        int n2;
        boolean bl2 = PlasticUtils.isLeftToRight(this.frame);
        int n3 = this.getWidth();
        int n4 = bl2 ? n3 : 0;
        int n5 = this.closeButton.getIcon().getIconWidth();
        if (this.frame.isClosable()) {
            if (this.isPalette) {
                n2 = 3;
                n4 += bl2 ? -n2 - (n5 + 2) : n2;
                if (!bl2) {
                    n4 += n5 + 2;
                }
            } else {
                n2 = 4;
                n4 += bl2 ? -n2 - n5 : n2;
                if (!bl2) {
                    n4 += n5;
                }
            }
        }
        if (this.frame.isMaximizable() && !this.isPalette) {
            n2 = this.frame.isClosable() ? 10 : 4;
            n4 += bl2 ? -n2 - n5 : n2;
            if (!bl2) {
                n4 += n5;
            }
        }
        if (this.frame.isIconifiable() && !this.isPalette) {
            n2 = this.frame.isMaximizable() ? 2 : (this.frame.isClosable() ? 10 : 4);
            n4 += bl2 ? -n2 - n5 : n2;
            if (!bl2) {
                n4 += n5;
            }
        }
        return bl2 ? n3 - n4 : n4;
    }
}

