/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.LookSwitchUtils;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.windows.WindowsArrowButton;
import com.jgoodies.looks.windows.WindowsComboBoxEditor$UIResource;
import com.jgoodies.looks.windows.WindowsComboBoxUI$TableCellEditorPropertyChangeHandler;
import com.jgoodies.looks.windows.WindowsComboBoxUI$WindowsComboBoxLayoutManager;
import com.jgoodies.looks.windows.WindowsComboBoxUI$WindowsComboPopup;
import com.jgoodies.looks.windows.WindowsUtils;
import com.sun.java.swing.plaf.windows.WindowsTextFieldUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.plaf.basic.ComboPopup;

public class WindowsComboBoxUI
extends com.sun.java.swing.plaf.windows.WindowsComboBoxUI {
    private static final String CELL_EDITOR_KEY = "JComboBox.isTableCellEditor";
    private static final JTextField PHANTOM = new JTextField("Phantom");
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    private static final Border EMPTY_BORDER = new EmptyBorder(EMPTY_INSETS);
    private boolean tableCellEditor;
    private Insets editorInsets;
    private Color background;
    private Color disabledForeground;
    private Color disabledBackground;
    private PropertyChangeListener propertyChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        WindowsComboBoxUI.ensurePhantomHasWindowsUI();
        return new WindowsComboBoxUI();
    }

    private static void ensurePhantomHasWindowsUI() {
        if (!(PHANTOM.getUI() instanceof WindowsTextFieldUI)) {
            PHANTOM.updateUI();
        }
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.tableCellEditor = this.isTableCellEditor();
        this.editorInsets = UIManager.getInsets("ComboBox.editorInsets");
        this.background = UIManager.getColor("ComboBox.background");
        this.disabledForeground = UIManager.getColor("ComboBox.disabledForeground");
        this.disabledBackground = UIManager.getColor("ComboBox.disabledBackground");
    }

    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = new WindowsComboBoxUI$TableCellEditorPropertyChangeHandler(this, null);
        this.comboBox.addPropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removePropertyChangeListener(CELL_EDITOR_KEY, this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected JButton createArrowButton() {
        return LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? super.createArrowButton() : new WindowsArrowButton(5);
    }

    protected ComboBoxEditor createEditor() {
        return new WindowsComboBoxEditor$UIResource(this.tableCellEditor);
    }

    protected LayoutManager createLayoutManager() {
        return new WindowsComboBoxUI$WindowsComboBoxLayoutManager(this, null);
    }

    protected void configureEditor() {
        super.configureEditor();
        if (!this.comboBox.isEnabled()) {
            this.editor.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
        }
    }

    protected ComboPopup createPopup() {
        return new WindowsComboBoxUI$WindowsComboPopup(this.comboBox, null);
    }

    protected ListCellRenderer createRenderer() {
        if (this.tableCellEditor) {
            return super.createRenderer();
        }
        BasicComboBoxRenderer.UIResource uIResource = new BasicComboBoxRenderer.UIResource();
        uIResource.setBorder(UIManager.getBorder("ComboBox.rendererBorder"));
        return uIResource;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Serializable serializable;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        Dimension dimension = this.getDisplaySize();
        Insets insets = this.getInsets();
        dimension.height += insets.top + insets.bottom;
        int n2 = this.getEditableButtonWidth();
        dimension.width += insets.left + insets.right + n2;
        ++dimension.width;
        ListCellRenderer listCellRenderer = this.comboBox.getRenderer();
        if (listCellRenderer instanceof JComponent) {
            serializable = (JComponent)((Object)listCellRenderer);
            Insets insets2 = ((JComponent)serializable).getInsets();
            int n3 = Math.max(0, this.editorInsets.left - insets2.left);
            int n4 = Math.max(0, this.editorInsets.right - insets2.right);
            dimension.width += n3 + n4;
        }
        serializable = PHANTOM.getMinimumSize();
        dimension.height = LookUtils.IS_OS_WINDOWS_6_OR_LATER && !LookUtils.IS_LAF_WINDOWS_XP_ENABLED ? ((Dimension)serializable).height : Math.max(((Dimension)serializable).height, dimension.height);
        this.cachedMinimumSize.setSize(dimension.width, dimension.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(dimension);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getMinimumSize(jComponent);
    }

    public void paintCurrentValue(Graphics graphics, Rectangle rectangle, boolean bl2) {
        int n2;
        Serializable serializable;
        Component component;
        ListCellRenderer<Object> listCellRenderer = this.comboBox.getRenderer();
        boolean bl3 = this.isVistaXPStyleReadOnlyCombo();
        if (bl2 && !this.isPopupVisible(this.comboBox)) {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, true, false);
        } else {
            component = listCellRenderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, false, false);
            component.setBackground(this.background);
        }
        Border border = null;
        Rectangle rectangle2 = new Rectangle(rectangle);
        if (component instanceof JComponent && !this.tableCellEditor) {
            JComponent jComponent = (JComponent)component;
            if (this.isRendererBorderRemovable(jComponent)) {
                border = jComponent.getBorder();
                jComponent.setBorder(EMPTY_BORDER);
            }
            serializable = jComponent.getInsets();
            int n3 = Math.max(0, this.editorInsets.left - ((Insets)serializable).left);
            n2 = Math.max(0, this.editorInsets.right - ((Insets)serializable).right);
            int n4 = Math.max(0, this.editorInsets.top - ((Insets)serializable).top);
            int n5 = Math.max(0, this.editorInsets.bottom - ((Insets)serializable).bottom);
            rectangle.x += n3;
            rectangle.y += n4;
            rectangle.width -= n3 + n2 - 1;
            rectangle.height -= n4 + n5;
        }
        component.setFont(this.comboBox.getFont());
        if (bl2 && !this.isPopupVisible(this.comboBox) && !bl3) {
            component.setForeground(this.listBox.getSelectionForeground());
            component.setBackground(this.listBox.getSelectionBackground());
        } else if (this.comboBox.isEnabled()) {
            component.setForeground(this.comboBox.getForeground());
            component.setBackground(this.comboBox.getBackground());
        } else {
            component.setForeground(this.disabledForeground);
            component.setBackground(this.disabledBackground);
        }
        boolean bl4 = component instanceof JPanel;
        serializable = null;
        if (bl3 && component instanceof JComponent && !(component instanceof DefaultListCellRenderer)) {
            serializable = Boolean.valueOf(component.isOpaque());
            ((JComponent)component).setOpaque(false);
        }
        this.currentValuePane.paintComponent(graphics, component, this.comboBox, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl4);
        if (bl2) {
            Color color = graphics.getColor();
            graphics.setColor(this.comboBox.getForeground());
            if (bl3) {
                n2 = rectangle2.width - 2;
                if (n2 % 2 == 0) {
                    ++n2;
                }
                WindowsUtils.drawRoundedDashedRect(graphics, rectangle2.x + 1, rectangle2.y + 1, n2, rectangle2.height - 2);
            }
            graphics.setColor(color);
        }
        if (serializable != null) {
            ((JComponent)component).setOpaque((Boolean)serializable);
        }
        if (border != null) {
            ((JComponent)component).setBorder(border);
        }
    }

    protected boolean isRendererBorderRemovable(JComponent jComponent) {
        if (jComponent instanceof BasicComboBoxRenderer.UIResource) {
            return true;
        }
        Object object = jComponent.getClientProperty("isBorderRemovable");
        if (object != null) {
            return Boolean.TRUE.equals(object);
        }
        Border border = jComponent.getBorder();
        return border instanceof EmptyBorder;
    }

    private boolean isVistaXPStyleReadOnlyCombo() {
        return LookUtils.IS_OS_WINDOWS_6_OR_LATER && LookUtils.IS_LAF_WINDOWS_XP_ENABLED && !this.comboBox.isEditable();
    }

    protected Rectangle rectangleForCurrentValue() {
        int n2 = this.comboBox.getWidth();
        int n3 = this.comboBox.getHeight();
        Insets insets = this.getInsets();
        int n4 = this.getEditableButtonWidth();
        if (this.arrowButton != null) {
            n4 = this.arrowButton.getWidth();
        }
        if (this.comboBox.getComponentOrientation().isLeftToRight()) {
            return new Rectangle(insets.left, insets.top, n2 - (insets.left + insets.right + n4), n3 - (insets.top + insets.bottom));
        }
        return new Rectangle(insets.left + n4, insets.top, n2 - (insets.left + insets.right + n4), n3 - (insets.top + insets.bottom));
    }

    private int getEditableButtonWidth() {
        return LookSwitchUtils.getInt("ScrollBar.width");
    }

    private boolean isTableCellEditor() {
        return Boolean.TRUE.equals(this.comboBox.getClientProperty(CELL_EDITOR_KEY));
    }

    static /* synthetic */ Insets access$300(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.getInsets();
    }

    static /* synthetic */ int access$400(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.getEditableButtonWidth();
    }

    static /* synthetic */ JButton access$500(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.arrowButton;
    }

    static /* synthetic */ JButton access$600(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.arrowButton;
    }

    static /* synthetic */ JButton access$700(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.arrowButton;
    }

    static /* synthetic */ Component access$800(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.editor;
    }

    static /* synthetic */ Component access$900(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.editor;
    }

    static /* synthetic */ boolean access$1002(WindowsComboBoxUI windowsComboBoxUI, boolean bl2) {
        windowsComboBoxUI.tableCellEditor = bl2;
        return windowsComboBoxUI.tableCellEditor;
    }

    static /* synthetic */ boolean access$1100(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.isTableCellEditor();
    }

    static /* synthetic */ JComboBox access$1200(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static /* synthetic */ JComboBox access$1300(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static /* synthetic */ JComboBox access$1400(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static /* synthetic */ JComboBox access$1500(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static /* synthetic */ JComboBox access$1600(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }

    static /* synthetic */ JComboBox access$1700(WindowsComboBoxUI windowsComboBoxUI) {
        return windowsComboBoxUI.comboBox;
    }
}

