/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.FontPolicies;
import com.jgoodies.looks.FontPolicy;
import com.jgoodies.looks.FontSet;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.looks.MicroLayout;
import com.jgoodies.looks.MicroLayoutPolicies;
import com.jgoodies.looks.MicroLayoutPolicy;
import com.jgoodies.looks.Options;
import com.jgoodies.looks.common.MinimumSizedIcon;
import com.jgoodies.looks.common.RGBGrayFilter;
import com.jgoodies.looks.common.ShadowPopupFactory;
import com.jgoodies.looks.windows.WindowsBorders;
import com.jgoodies.looks.windows.WindowsIconFactory;
import com.jgoodies.looks.windows.WindowsLookAndFeel$SimpleProxyLazyValue;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;

public class WindowsLookAndFeel
extends com.sun.java.swing.plaf.windows.WindowsLookAndFeel {
    public static final String BORDER_STYLE_KEY = "jgoodies.windows.borderStyle";

    public String getName() {
        return "JGoodies Windows";
    }

    public String getDescription() {
        return "The JGoodies Windows Look and Feel - \u00a9 2001-2009 JGoodies Karsten Lentzsch";
    }

    public static FontPolicy getFontPolicy() {
        FontPolicy fontPolicy = (FontPolicy)UIManager.get("Windows.fontPolicy");
        if (fontPolicy != null) {
            return fontPolicy;
        }
        FontPolicy fontPolicy2 = FontPolicies.getDefaultWindowsPolicy();
        return FontPolicies.customSettingsPolicy(fontPolicy2);
    }

    public static void setFontPolicy(FontPolicy fontPolicy) {
        UIManager.put("Windows.fontPolicy", fontPolicy);
    }

    public static MicroLayoutPolicy getMicroLayoutPolicy() {
        MicroLayoutPolicy microLayoutPolicy = (MicroLayoutPolicy)UIManager.get("Windows.MicroLayoutPolicy");
        return microLayoutPolicy != null ? microLayoutPolicy : MicroLayoutPolicies.getDefaultWindowsPolicy();
    }

    public static void setMicroLayoutPolicy(MicroLayout microLayout) {
        UIManager.put("Windows.MicroLayoutPolicy", microLayout);
    }

    public void initialize() {
        super.initialize();
        ShadowPopupFactory.install();
    }

    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
    }

    public Icon getDisabledIcon(JComponent jComponent, Icon icon) {
        Icon icon2 = RGBGrayFilter.getDisabledIcon(jComponent, icon);
        return icon2 != null ? new IconUIResource(icon2) : null;
    }

    protected void initClassDefaults(UIDefaults uIDefaults) {
        super.initClassDefaults(uIDefaults);
        String string = "com.jgoodies.looks.windows.Windows";
        String string2 = "com.jgoodies.looks.common.ExtBasic";
        Object[] objectArray = new Object[]{"ComboBoxUI", "com.jgoodies.looks.windows.WindowsComboBoxUI", "ButtonUI", "com.jgoodies.looks.windows.WindowsButtonUI", "ScrollPaneUI", "com.jgoodies.looks.windows.WindowsScrollPaneUI", "MenuBarUI", "com.jgoodies.looks.windows.WindowsMenuBarUI", "PopupMenuUI", "com.jgoodies.looks.windows.WindowsPopupMenuUI", "OptionPaneUI", "com.jgoodies.looks.windows.WindowsOptionPaneUI", "SplitPaneUI", "com.jgoodies.looks.windows.WindowsSplitPaneUI", "TabbedPaneUI", "com.jgoodies.looks.windows.WindowsTabbedPaneUI", "TextFieldUI", "com.jgoodies.looks.windows.WindowsTextFieldUI", "FormattedTextFieldUI", "com.jgoodies.looks.windows.WindowsFormattedTextFieldUI", "PasswordFieldUI", "com.jgoodies.looks.windows.WindowsPasswordFieldUI", "TextAreaUI", "com.jgoodies.looks.windows.WindowsTextAreaUI", "TreeUI", "com.jgoodies.looks.windows.WindowsTreeUI", "SeparatorUI", "com.jgoodies.looks.windows.WindowsSeparatorUI"};
        if (LookUtils.IS_JAVA_1_4_2_OR_LATER) {
            objectArray = WindowsLookAndFeel.append(objectArray, "SpinnerUI", "com.jgoodies.looks.windows.WindowsSpinnerUI");
        }
        if (!(LookUtils.IS_JAVA_5_OR_LATER && LookUtils.IS_OS_WINDOWS_6_OR_LATER && LookUtils.IS_LAF_WINDOWS_XP_ENABLED)) {
            objectArray = WindowsLookAndFeel.append(objectArray, "MenuItemUI", "com.jgoodies.looks.windows.WindowsMenuItemUI");
            objectArray = WindowsLookAndFeel.append(objectArray, "CheckBoxMenuItemUI", "com.jgoodies.looks.common.ExtBasicCheckBoxMenuItemUI");
            objectArray = WindowsLookAndFeel.append(objectArray, "RadioButtonMenuItemUI", "com.jgoodies.looks.common.ExtBasicRadioButtonMenuItemUI");
            objectArray = WindowsLookAndFeel.append(objectArray, "PopupMenuSeparatorUI", "com.jgoodies.looks.common.ExtBasicPopupMenuSeparatorUI");
        }
        if (LookUtils.IS_LAF_WINDOWS_XP_ENABLED) {
            if (!LookUtils.IS_JAVA_5_OR_LATER || !LookUtils.IS_OS_WINDOWS_6_OR_LATER) {
                objectArray = WindowsLookAndFeel.append(objectArray, "MenuUI", "com.jgoodies.looks.windows.WindowsXPMenuUI");
            }
            objectArray = WindowsLookAndFeel.append(objectArray, "ToolBarUI", "com.jgoodies.looks.windows.WindowsXPToolBarUI");
            objectArray = WindowsLookAndFeel.append(objectArray, "TableHeaderUI", "com.jgoodies.looks.windows.WindowsXPTableHeaderUI");
        } else {
            objectArray = WindowsLookAndFeel.append(objectArray, "MenuUI", "com.jgoodies.looks.common.ExtBasicMenuUI");
            objectArray = WindowsLookAndFeel.append(objectArray, "ToolBarUI", "com.jgoodies.looks.windows.WindowsToolBarUI");
            objectArray = WindowsLookAndFeel.append(objectArray, "ScrollBarUI", "com.jgoodies.looks.windows.WindowsScrollBarUI");
            if (!LookUtils.IS_JAVA_1_4_2_OR_LATER) {
                objectArray = WindowsLookAndFeel.append(objectArray, "ToolBarSeparatorUI", "com.jgoodies.looks.windows.WindowsToolBarSeparatorUI");
            }
        }
        uIDefaults.putDefaults(objectArray);
    }

    protected void initComponentDefaults(UIDefaults uIDefaults) {
        super.initComponentDefaults(uIDefaults);
        boolean bl2 = LookUtils.IS_LAF_WINDOWS_XP_ENABLED;
        boolean bl3 = !bl2;
        boolean bl4 = LookUtils.IS_OS_WINDOWS_6_OR_LATER;
        this.initFontDefaults(uIDefaults);
        if (bl3) {
            this.initComponentDefaultsClassic(uIDefaults);
        }
        if (bl2 && LookUtils.IS_JAVA_1_4) {
            this.initComponentDefaultsXP14(uIDefaults);
        }
        MicroLayout microLayout = WindowsLookAndFeel.getMicroLayoutPolicy().getMicroLayout("Windows", uIDefaults);
        if (!(bl4 && LookUtils.IS_JAVA_6_OR_LATER && LookUtils.IS_LAF_WINDOWS_XP_ENABLED)) {
            this.initMenuItemDefaults(uIDefaults, microLayout);
        }
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder();
        InsetsUIResource insetsUIResource = microLayout.getCheckBoxMargin();
        UIDefaults.ProxyLazyValue proxyLazyValue = new UIDefaults.ProxyLazyValue("javax.swing.plaf.BorderUIResource", "getEtchedBorderUIResource");
        WindowsLookAndFeel$SimpleProxyLazyValue windowsLookAndFeel$SimpleProxyLazyValue = new WindowsLookAndFeel$SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getButtonBorder");
        Border border = bl2 ? WindowsBorders.getXPMenuBorder() : WindowsBorders.getMenuBorder();
        BasicBorders.MarginBorder marginBorder2 = marginBorder;
        Border border2 = WindowsBorders.getSeparatorBorder();
        Border border3 = WindowsBorders.getEtchedBorder();
        Border border4 = WindowsBorders.getMenuBarHeaderBorder();
        BasicBorders.MarginBorder marginBorder3 = marginBorder;
        Border border5 = WindowsBorders.getSeparatorBorder();
        Border border6 = WindowsBorders.getEtchedBorder();
        Border border7 = WindowsBorders.getToolBarHeaderBorder();
        InsetsUIResource insetsUIResource2 = microLayout.getButtonMargin();
        DimensionUIResource dimensionUIResource = LookUtils.IS_JAVA_1_4_2_OR_LATER ? null : new DimensionUIResource(6, Options.getDefaultIconSize().height);
        InsetsUIResource insetsUIResource3 = microLayout.getTextInsets();
        InsetsUIResource insetsUIResource4 = microLayout.getWrappedTextInsets();
        InsetsUIResource insetsUIResource5 = microLayout.getComboBoxEditorInsets();
        int n2 = microLayout.getComboBorderSize();
        int n3 = microLayout.getComboPopupBorderSize();
        int n4 = insetsUIResource5.left + n2 - n3;
        EmptyBorder emptyBorder = new EmptyBorder(1, n4, 1, n4);
        Insets insets = new Insets(0, 0, 0, 0);
        InsetsUIResource insetsUIResource6 = microLayout.getPopupMenuSeparatorMargin();
        int n5 = uIDefaults.getFont("Tree.font").getSize();
        Integer n6 = new Integer(n5 + 6);
        Class<?> clazz = ((Object)((Object)this)).getClass().getSuperclass();
        Color color = uIDefaults.getColor("control");
        Color color2 = uIDefaults.getColor("TextField.disabledBackground");
        Color color3 = uIDefaults.getColor("TextField.inactiveBackground");
        Color color4 = bl4 && bl2 ? uIDefaults.getColor("ComboBox.background") : color2;
        Object object = bl2 ? uIDefaults.get("control") : uIDefaults.get("menu");
        Object object2 = bl2 ? uIDefaults.get("MenuItem.selectionBackground") : uIDefaults.get("Menu.background");
        Object object3 = bl2 ? uIDefaults.get("MenuItem.selectionForeground") : uIDefaults.get("Menu.foreground");
        Character c2 = new Character(bl2 ? (char)'\u25cf' : '*');
        Object[] objectArray = new Object[]{"Button.border", windowsLookAndFeel$SimpleProxyLazyValue, "Button.margin", insetsUIResource2, "CheckBox.border", marginBorder, "CheckBox.margin", insetsUIResource, "ComboBox.disabledBackground", color4, "ComboBox.editorBorder", marginBorder, "ComboBox.editorColumns", new Integer(5), "ComboBox.editorInsets", insetsUIResource5, "ComboBox.tableEditorInsets", insets, "ComboBox.rendererBorder", emptyBorder, "EditorPane.margin", insetsUIResource4, "Menu.border", border, "Menu.borderPainted", Boolean.TRUE, "Menu.background", object, "Menu.selectionForeground", object3, "Menu.selectionBackground", object2, "MenuBar.background", object, "MenuBar.border", border2, "MenuBar.emptyBorder", marginBorder2, "MenuBar.separatorBorder", border2, "MenuBar.etchedBorder", border3, "MenuBar.headerBorder", border4, "FormattedTextField.disabledBackground", color2, "FormattedTextField.inactiveBackground", color3, "FormattedTextField.margin", insetsUIResource3, "PasswordField.margin", insetsUIResource3, "PasswordField.echoChar", c2, "PopupMenu.border", WindowsBorders.getPopupMenuBorder(), "PopupMenu.noMarginBorder", WindowsBorders.getNoMarginPopupMenuBorder(), "PopupMenuSeparator.margin", insetsUIResource6, "ScrollPane.etchedBorder", proxyLazyValue, "Spinner.defaultEditorInsets", insetsUIResource3, "RadioButton.border", marginBorder, "RadioButton.margin", insetsUIResource, "Table.gridColor", color, "TextArea.margin", insetsUIResource4, "TextArea.disabledBackground", color2, "TextArea.inactiveBackground", color3, "TextField.margin", insetsUIResource3, "ToggleButton.margin", insetsUIResource2, "ToolBar.emptyBorder", marginBorder3, "ToolBar.separatorBorder", border5, "ToolBar.etchedBorder", border6, "ToolBar.headerBorder", border7, "ToolBar.separatorSize", dimensionUIResource, "ToolBar.margin", new InsetsUIResource(0, 10, 0, 0), "Tree.selectionBorderColor", color, "Tree.rowHeight", n6};
        if (LookUtils.IS_JAVA_1_4) {
            objectArray = WindowsLookAndFeel.append(objectArray, new Object[]{"InternalFrame.icon", WindowsLookAndFeel.makeIcon(clazz, (String)"icons/JavaCup.gif"), "OptionPane.errorIcon", bl2 ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Error.png") : WindowsLookAndFeel.makeIcon(clazz, (String)"icons/Error.gif"), "OptionPane.informationIcon", bl2 ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Inform.png") : WindowsLookAndFeel.makeIcon(clazz, (String)"icons/Inform.gif"), "OptionPane.warningIcon", bl2 ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Warn.png") : WindowsLookAndFeel.makeIcon(clazz, (String)"icons/Warn.gif"), "OptionPane.questionIcon", bl2 ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/Inform.png") : WindowsLookAndFeel.makeIcon(clazz, (String)"icons/Question.gif")});
        }
        if (LookUtils.IS_JAVA_1_4 || LookUtils.IS_JAVA_5) {
            objectArray = WindowsLookAndFeel.append(objectArray, new Object[]{"Tree.openIcon", bl2 ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeOpen.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeOpen.gif"), "Tree.closedIcon", bl2 ? WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/xp/TreeClosed.png") : WindowsLookAndFeel.makeIcon(((Object)((Object)this)).getClass(), (String)"icons/TreeClosed.gif")});
        }
        if (LookUtils.IS_JAVA_6_OR_LATER) {
            objectArray = WindowsLookAndFeel.append(objectArray, new Object[]{"Spinner.border", uIDefaults.get("TextField.border")});
        }
        uIDefaults.putDefaults(objectArray);
    }

    private void initComponentDefaultsClassic(UIDefaults uIDefaults) {
        WindowsLookAndFeel$SimpleProxyLazyValue windowsLookAndFeel$SimpleProxyLazyValue = new WindowsLookAndFeel$SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getCheckBoxIcon");
        WindowsLookAndFeel$SimpleProxyLazyValue windowsLookAndFeel$SimpleProxyLazyValue2 = new WindowsLookAndFeel$SimpleProxyLazyValue("com.jgoodies.looks.windows.WindowsLookAndFeel", "getRadioButtonIcon");
        BasicBorders.FieldBorder fieldBorder = new BasicBorders.FieldBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight"));
        Object[] objectArray = new Object[]{"CheckBox.checkColor", uIDefaults.get("controlText"), "CheckBox.icon", windowsLookAndFeel$SimpleProxyLazyValue, "RadioButton.checkColor", uIDefaults.get("controlText"), "RadioButton.icon", windowsLookAndFeel$SimpleProxyLazyValue2, "Table.scrollPaneBorder", fieldBorder};
        uIDefaults.putDefaults(objectArray);
    }

    private void initComponentDefaultsXP14(UIDefaults uIDefaults) {
        Object[] objectArray = new Object[]{"TitledBorder.titleColor", uIDefaults.getColor("activeCaption")};
        uIDefaults.putDefaults(objectArray);
    }

    private void initFontDefaults(UIDefaults uIDefaults) {
        FontPolicy fontPolicy = WindowsLookAndFeel.getFontPolicy();
        FontSet fontSet = fontPolicy.getFontSet("Windows", uIDefaults);
        WindowsLookAndFeel.initFontDefaults(uIDefaults, fontSet);
    }

    private void initMenuItemDefaults(UIDefaults uIDefaults, MicroLayout microLayout) {
        InsetsUIResource insetsUIResource = microLayout.getMenuMargin();
        InsetsUIResource insetsUIResource2 = microLayout.getMenuItemMargin();
        MinimumSizedIcon minimumSizedIcon = new MinimumSizedIcon();
        Object[] objectArray = new Object[]{"Menu.margin", insetsUIResource, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.checkIcon", minimumSizedIcon, "MenuItem.margin", insetsUIResource2, "CheckBoxMenuItem.margin", insetsUIResource2, "RadioButtonMenuItem.margin", insetsUIResource2};
        uIDefaults.putDefaults(objectArray);
    }

    private static void initFontDefaults(UIDefaults uIDefaults, FontSet fontSet) {
        FontUIResource fontUIResource = fontSet.getControlFont();
        FontUIResource fontUIResource2 = fontSet.getMenuFont();
        FontUIResource fontUIResource3 = fontSet.getMessageFont();
        FontUIResource fontUIResource4 = fontSet.getSmallFont();
        FontUIResource fontUIResource5 = fontSet.getTitleFont();
        FontUIResource fontUIResource6 = fontSet.getWindowTitleFont();
        Object[] objectArray = new Object[]{"Button.font", fontUIResource, "CheckBox.font", fontUIResource, "ColorChooser.font", fontUIResource, "ComboBox.font", fontUIResource, "EditorPane.font", fontUIResource, "FormattedTextField.font", fontUIResource, "Label.font", fontUIResource, "List.font", fontUIResource, "Panel.font", fontUIResource, "PasswordField.font", fontUIResource, "ProgressBar.font", fontUIResource, "RadioButton.font", fontUIResource, "ScrollPane.font", fontUIResource, "Spinner.font", fontUIResource, "TabbedPane.font", fontUIResource, "Table.font", fontUIResource, "TableHeader.font", fontUIResource, "TextArea.font", fontUIResource, "TextField.font", fontUIResource, "TextPane.font", fontUIResource, "ToolBar.font", fontUIResource, "ToggleButton.font", fontUIResource, "Tree.font", fontUIResource, "Viewport.font", fontUIResource, "InternalFrame.titleFont", fontUIResource6, "OptionPane.font", fontUIResource3, "OptionPane.messageFont", fontUIResource3, "OptionPane.buttonFont", fontUIResource3, "TitledBorder.font", fontUIResource5, "ToolTip.font", fontUIResource4, "CheckBoxMenuItem.font", fontUIResource2, "CheckBoxMenuItem.acceleratorFont", fontUIResource2, "Menu.font", fontUIResource2, "Menu.acceleratorFont", fontUIResource2, "MenuBar.font", fontUIResource2, "MenuItem.font", fontUIResource2, "MenuItem.acceleratorFont", fontUIResource2, "PopupMenu.font", fontUIResource2, "RadioButtonMenuItem.font", fontUIResource2, "RadioButtonMenuItem.acceleratorFont", fontUIResource2};
        uIDefaults.putDefaults(objectArray);
    }

    public static Border getButtonBorder() {
        return WindowsBorders.getButtonBorder();
    }

    public static Icon getCheckBoxIcon() {
        return WindowsIconFactory.getCheckBoxIcon();
    }

    public static Icon getRadioButtonIcon() {
        return WindowsIconFactory.getRadioButtonIcon();
    }

    private static Object[] append(Object[] objectArray, String string, Object object) {
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + 2];
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        objectArray2[n2] = string;
        objectArray2[n2 + 1] = object;
        return objectArray2;
    }

    private static Object[] append(Object[] objectArray, Object[] objectArray2) {
        int n2 = objectArray.length;
        Object[] objectArray3 = new Object[n2 + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, n2);
        for (int i2 = 0; i2 < objectArray2.length; ++i2) {
            objectArray3[n2 + i2] = objectArray2[i2];
        }
        return objectArray3;
    }
}

