/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.model;

import com.jformdesigner.model.FormObject;
import java.awt.Font;

public class SwingDerivedFont
extends Font {
    private final String nameChange;
    private final int styleChange;
    private final int sizeChange;
    private final boolean absoluteSize;

    public SwingDerivedFont(String nameChange, int styleChange, int sizeChange, boolean absoluteSize) {
        super("Dialog", 0, 12);
        this.nameChange = nameChange;
        this.styleChange = styleChange;
        this.sizeChange = sizeChange;
        this.absoluteSize = absoluteSize;
    }

    public SwingDerivedFont(Font font, String nameChange, int styleChange, int sizeChange, boolean absoluteSize) {
        super(nameChange != null ? nameChange : font.getName(), font.getStyle() & ~(styleChange >> 16 & 0xFFFF) | styleChange & 0xFFFF, absoluteSize ? sizeChange : font.getSize() + sizeChange);
        this.nameChange = nameChange;
        this.styleChange = styleChange;
        this.sizeChange = sizeChange;
        this.absoluteSize = absoluteSize;
    }

    public String getNameChange() {
        return this.nameChange;
    }

    public int getStyleChange() {
        return this.styleChange;
    }

    public int getSizeChange() {
        return this.sizeChange;
    }

    public boolean isAbsoluteSize() {
        return this.absoluteSize;
    }

    public Font derive(Font font) {
        int size;
        if (font == null) {
            return this;
        }
        int style = font.getStyle() & ~(this.styleChange >> 16 & 0xFFFF) | this.styleChange & 0xFFFF;
        int n = size = this.absoluteSize ? this.sizeChange : font.getSize() + this.sizeChange;
        if (this.nameChange != null) {
            return new Font(this.nameChange, style, size);
        }
        if (this.styleChange != 0 && this.sizeChange != 0) {
            return font.deriveFont(style, size);
        }
        if (this.styleChange != 0) {
            return font.deriveFont(style);
        }
        if (this.sizeChange != 0) {
            return font.deriveFont((float)size);
        }
        return font;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SwingDerivedFont)) {
            return false;
        }
        SwingDerivedFont f = (SwingDerivedFont)obj;
        return FormObject.safeEquals(this.nameChange, f.nameChange) && this.styleChange == f.styleChange && this.sizeChange == f.sizeChange && this.absoluteSize == f.absoluteSize;
    }

    public int hashCode() {
        int hash = this.styleChange + this.sizeChange * 31;
        if (this.absoluteSize) {
            hash += 61;
        }
        if (this.nameChange != null) {
            hash += this.nameChange.hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if ((this.styleChange & 1) != 0) {
            buf.append("+BOLD ");
        }
        if ((this.styleChange & 2) != 0) {
            buf.append("+ITALIC ");
        }
        if ((this.styleChange >> 16 & 1) != 0) {
            buf.append("-BOLD ");
        }
        if ((this.styleChange >> 16 & 2) != 0) {
            buf.append("-ITALIC ");
        }
        buf.append('(').append(Integer.toHexString(this.styleChange)).append(')');
        return FormObject.unqualifiedClassName(this.getClass()) + "[nameChange=" + this.nameChange + ",styleChange=" + buf + ",sizeChange=" + this.sizeChange + ",absoluteSize=" + this.absoluteSize + "]";
    }
}

