/*
 * Decompiled with CFR 0.152.
 */
package com.jformdesigner.runtime;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.jformdesigner.model.FormLayoutConstraints;
import com.jformdesigner.model.FormLayoutManager;
import com.jformdesigner.runtime.AbstractLayoutCreator;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class IntelliJGridLayoutCreator
extends AbstractLayoutCreator {
    private static final Insets DEFAULT_MARGIN = new Insets(0, 0, 0, 0);
    private static final int DEFAULT_SIZE_POLICY = 3;
    private static final int DEFAULT_SPACER_SIZE_POLICY = 6;
    private static final int DEFAULT_SPACER_SIZE_POLICY2 = 1;

    public LayoutManager createLayoutManager(Container container, FormLayoutManager formLayout) throws InstantiationException, IllegalAccessException {
        int columnCount = formLayout.getPropertyInt("$columnCount", 0);
        int rowCount = formLayout.getPropertyInt("$rowCount", 0);
        Insets margin = (Insets)formLayout.getProperty("margin", DEFAULT_MARGIN);
        int hGap = formLayout.getPropertyInt("hGap", -1);
        int vGap = formLayout.getPropertyInt("vGap", -1);
        boolean sameSizeHorizontally = formLayout.getPropertyBoolean("sameSizeHorizontally", false);
        boolean sameSizeVertically = formLayout.getPropertyBoolean("sameSizeVertically", false);
        return new GridLayoutManager(Math.max(rowCount, 1), Math.max(columnCount, 1), margin, hGap, vGap, sameSizeHorizontally, sameSizeVertically);
    }

    public Object createLayoutConstraints(FormLayoutConstraints formConstraints) {
        return IntelliJGridLayoutCreator.createConstraints(formConstraints);
    }

    public static GridConstraints createConstraints(FormLayoutConstraints formConstraints) {
        int defaultFill = 0;
        int defaultHSizePolicy = 3;
        int defaultVSizePolicy = 3;
        String beanClassName = formConstraints.getComponent().getClassName();
        if (beanClassName.equals("com.jformdesigner.designer.wrapper.HSpacer")) {
            defaultFill = 1;
            defaultHSizePolicy = 6;
            defaultVSizePolicy = 1;
        } else if (beanClassName.equals("com.jformdesigner.designer.wrapper.VSpacer")) {
            defaultFill = 2;
            defaultHSizePolicy = 1;
            defaultVSizePolicy = 6;
        }
        int row = formConstraints.getPropertyInt("row", 0);
        int column = formConstraints.getPropertyInt("column", 0);
        int rowSpan = formConstraints.getPropertyInt("rowSpan", 1);
        int colSpan = formConstraints.getPropertyInt("colSpan", 1);
        int anchor = formConstraints.getPropertyInt("anchor", 0);
        int fill = formConstraints.getPropertyInt("fill", defaultFill);
        int indent = formConstraints.getPropertyInt("indent", 0);
        boolean useParentLayout = formConstraints.getPropertyBoolean("useParentLayout", false);
        int hSizePolicy = formConstraints.getPropertyInt("hSizePolicy", defaultHSizePolicy);
        int vSizePolicy = formConstraints.getPropertyInt("vSizePolicy", defaultVSizePolicy);
        Dimension minimumSize = (Dimension)formConstraints.getProperty("minimumSize");
        Dimension preferredSize = (Dimension)formConstraints.getProperty("preferredSize");
        Dimension maximumSize = (Dimension)formConstraints.getProperty("maximumSize");
        return new GridConstraints(row, column, rowSpan, colSpan, anchor, fill, hSizePolicy, vSizePolicy, minimumSize, preferredSize, maximumSize, indent, useParentLayout);
    }
}

