/*
 * Copyright (C) 2003-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.model;

import java.awt.Font;
import javax.swing.UIManager;

/**
 * Used to specify fonts from the Swing font palette.
 * Invokes <code>UIManager.getFont(key)</code> to get the real font.
 * <p>
 * This class extends java.awt.Font so that it can be used everywhere,
 * but especially as title font in TitledBorder.
 *
 * @author Karl Tauber
 * @since 3.0
 */
public class SwingFont
	extends Font
	implements SwingResource
{
	private String key;

	/**
	 * Constructs a font from the Swing font palette.
	 *
	 * @param key The name of the Swing font.
	 */
	public SwingFont( String key ) {
		this( UIManager.getFont( key ) );
		this.key = key;
	}

	private SwingFont( Font font ) {
		super( (font != null) ? font.getName() : "Dialog",
			   (font != null) ? font.getStyle() : Font.PLAIN,
			   (font != null) ? font.getSize() : 12 );
	}

	/**
	 * Returns The name of the Swing font.
	 */
	public String getKey() {
		return key;
	}

	/**
	 * Determines whether another object is equal to this object.
	 */
	@Override
	public boolean equals( Object obj ) {
		if( !(obj instanceof SwingFont) )
			return false;
		return key.equals( ((SwingFont)obj).key );
	}

	/**
	 * Returns the hash code for this object.
	 */
	@Override
	public int hashCode() {
		return key.hashCode();
	}

	/**
	 * Returns a string representation of the object.
	 */
	@Override
	public String toString() {
		return FormObject.unqualifiedClassName( getClass() ) + "[key=" + key + "]";
	}
}
