/*
 * Copyright (C) 2003-2011 Karl Tauber <karl at jformdesigner dot com>
 * All Rights Reserved
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 *  o Neither the name of JFormDesigner or Karl Tauber nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jformdesigner.runtime;

import info.clearthought.layout.TableLayoutConstraints;

/**
 * @author Karl Tauber
 */
public class TableConstraints
	extends TableLayoutConstraints
{
	public static final int DEFAULT = -1;

	public TableConstraints() {
		hAlign = vAlign = DEFAULT;
	}

	public TableConstraints( String constraints ) {
		super( constraints );
	}

	public TableConstraints( int col1, int row1, int col2, int row2, int hAlign, int vAlign ) {
		this.col1 = col1;
		this.row1 = row1;
		this.col2 = col2;
		this.row2 = row2;
		this.hAlign = hAlign;
		this.vAlign = vAlign;
	}

	public TableConstraints( TableConstraints cons ) {
		col1 = cons.col1;
		row1 = cons.row1;
		col2 = cons.col2;
		row2 = cons.row2;
		hAlign = cons.hAlign;
		vAlign = cons.vAlign;
	}

	public int getGridX() {
		return col1;
	}

	public void setGridX( int gridX ) {
		int diff = gridX - col1;
		col1 = gridX;
		col2 += diff;
	}

	public int getGridY() {
		return row1;
	}

	public void setGridY( int gridY ) {
		int diff = gridY - row1;
		row1 = gridY;
		row2 += diff;
	}

	public int getGridWidth() {
		return col2 - col1 + 1;
	}

	public void setGridWidth( int gridWidth ) {
		col2 = col1 + (gridWidth - 1);
	}

	public int getGridHeight() {
		return row2 - row1 + 1;
	}

	public void setGridHeight( int gridHeight ) {
		row2 = row1 + (gridHeight - 1);
	}

	public int getHAlign() {
		return hAlign;
	}

	public void setHAlign( int hAlign ) {
		this.hAlign = hAlign;
	}

	public int getVAlign() {
		return vAlign;
	}

	public void setVAlign( int vAlign ) {
		this.vAlign = vAlign;
	}
}
