/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveException;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.ArchiveInputBusyException;
import de.schlichtherle.io.ArchiveInputBusyWarningException;
import de.schlichtherle.io.ArchiveOutputBusyException;
import de.schlichtherle.io.ArchiveOutputBusyWarningException;
import de.schlichtherle.io.ArchiveWarningException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.InputArchiveMetaData;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.OutputArchiveMetaData;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

final class UpdatingArchiveController
extends ArchiveController {
    private static final String CLASS_NAME;
    private static final Logger logger;
    static final String TEMP_FILE_PREFIX = "tzp";
    static final String TEMP_FILE_SUFFIX = ".tmp";
    private java.io.File inFile;
    private InputArchive inArchive;
    private ArchiveFileSystem fileSystem;
    private java.io.File outFile;
    private OutputArchive outArchive;
    private boolean needsReassembly;
    static final /* synthetic */ boolean $assertionsDisabled;

    UpdatingArchiveController(java.io.File file, ArchiveController archiveController, String string, ArchiveDriver archiveDriver) {
        super(file, archiveController, string, archiveDriver);
    }

    protected ArchiveFileSystem getFileSystem(final boolean bl) throws IOException {
        if (!($assertionsDisabled || this.readLock().isLocked() || this.writeLock().isLocked())) {
            throw new AssertionError();
        }
        if (this.fileSystem == null) {
            this.runWriteLocked(new ArchiveController.IORunnable(){

                public void run() throws IOException {
                    if (UpdatingArchiveController.this.fileSystem == null) {
                        UpdatingArchiveController.this.mount(bl);
                    }
                }
            });
        }
        return this.fileSystem;
    }

    private void mount(boolean bl) throws IOException {
        logger.log(Level.FINER, "mountFileSystem.entering", new Object[]{this.getPath(), bl});
        try {
            try {
                this.mountImpl(bl);
            }
            catch (Throwable throwable) {
                logger.log(Level.FINER, "mountFileSystem.throwing", throwable);
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw (Error)throwable;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            logger.log(Level.FINER, "mountFileSystem.finally", new Object[]{this.getPath(), bl});
            throw throwable;
        }
        logger.log(Level.FINER, "mountFileSystem.finally", new Object[]{this.getPath(), bl});
    }

    private void mountImpl(boolean bl) throws FileNotFoundException, IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fileSystem != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outFile != null) {
            throw new AssertionError();
        }
        if (this.usesNativeTargetFile()) {
            long l;
            if (this.inFile == null) {
                this.inFile = this.getTarget();
            }
            if ((l = this.inFile.lastModified()) != 0L) {
                boolean bl2 = !UpdatingArchiveController.isWritableOrCreatable(this.inFile);
                try {
                    this.initInArchive(this.inFile);
                }
                catch (IOException iOException) {
                    throw (ArchiveController)this.new ArchiveController.FalsePositiveNativeException(iOException);
                }
                this.fileSystem = new ArchiveFileSystem(this, this.inArchive, l, bl2);
            } else {
                if (!bl) {
                    throw new ArchiveNotFoundException();
                }
                this.ensureOutArchive();
                this.fileSystem = new ArchiveFileSystem(this);
            }
        } else if (this.inFile == null) {
            this.unwrap(this.getEnclController(), this.getEnclEntryName(), bl);
        } else {
            try {
                this.initInArchive(this.inFile);
            }
            catch (IOException iOException) {
                throw new ArchiveController.FalsePositiveFileEntryException(this.getEnclController(), this.getEnclEntryName(), iOException);
            }
            this.fileSystem = new ArchiveFileSystem(this, this.inArchive, this.inFile.lastModified(), false);
        }
        if (!$assertionsDisabled && this.fileSystem == null) {
            throw new AssertionError();
        }
    }

    /*
     * Exception decompiling
     */
    static boolean isWritableOrCreatable(java.io.File var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void unwrap(ArchiveController archiveController, String string, boolean bl) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "" == string) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fileSystem != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inFile != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outFile != null) {
            throw new AssertionError();
        }
        try {
            class Unwrapper
            implements ArchiveController.IORunnable {
                static final /* synthetic */ boolean $assertionsDisabled;
                private final /* synthetic */ ArchiveController val$controller;
                private final /* synthetic */ boolean val$autoCreate;
                private final /* synthetic */ String val$entryName;

                Unwrapper(ArchiveController archiveController, boolean bl, String string) {
                    this.val$controller = archiveController;
                    this.val$autoCreate = bl;
                    this.val$entryName = string;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() throws IOException {
                    ArchiveFileSystem archiveFileSystem;
                    try {
                        archiveFileSystem = this.val$controller.getFileSystem(this.val$autoCreate && File.isLenient());
                    }
                    catch (ArchiveController.FalsePositiveNativeException falsePositiveNativeException) {
                        throw (IOException)falsePositiveNativeException.getCause();
                    }
                    if (archiveFileSystem.isFile(this.val$entryName)) {
                        java.io.File file = File.createTempFile(UpdatingArchiveController.TEMP_FILE_PREFIX, UpdatingArchiveController.TEMP_FILE_SUFFIX);
                        try {
                            File.cp(this.val$controller.getInputStream(this.val$entryName), new FileOutputStream(file));
                            try {
                                UpdatingArchiveController.this.initInArchive(file);
                            }
                            catch (IOException iOException) {
                                throw new ArchiveController.FalsePositiveFileEntryException(this.val$controller, this.val$entryName, iOException);
                            }
                        }
                        catch (Throwable throwable) {
                            if (!file.delete()) {
                                throw new IOException(file.getPath() + ": Couldn't delete corrupted input file!");
                            }
                            if (throwable instanceof IOException) {
                                throw (IOException)throwable;
                            }
                            if (!(throwable instanceof RuntimeException)) throw (Error)throwable;
                            throw (RuntimeException)throwable;
                        }
                        UpdatingArchiveController.this.inFile = file;
                        UpdatingArchiveController.this.fileSystem = new ArchiveFileSystem(UpdatingArchiveController.this, UpdatingArchiveController.this.inArchive, archiveFileSystem.lastModified(this.val$entryName), archiveFileSystem.isReadOnly());
                        return;
                    }
                    if (archiveFileSystem.isDirectory(this.val$entryName)) {
                        throw new ArchiveController.FalsePositiveDirectoryEntryException(this.val$controller, this.val$entryName);
                    }
                    if (!this.val$autoCreate) {
                        throw new ArchiveNotFoundException();
                    }
                    if (!$assertionsDisabled && !this.val$autoCreate) {
                        throw new AssertionError();
                    }
                    ArchiveFileSystem.Delta delta = archiveFileSystem.beginCreateAndLink(this.val$entryName, File.isLenient());
                    UpdatingArchiveController.this.ensureOutArchive();
                    try {
                        delta.commit();
                    }
                    catch (IOException iOException) {
                        block22: {
                            try {
                                try {
                                    UpdatingArchiveController.this.outArchive.close();
                                }
                                finally {
                                    UpdatingArchiveController.this.outArchive = null;
                                }
                                Object var6_9 = null;
                                boolean bl = UpdatingArchiveController.this.outFile.delete();
                                if ($assertionsDisabled || bl) break block22;
                                throw new AssertionError();
                            }
                            catch (Throwable throwable) {
                                Object var6_10 = null;
                                boolean bl = UpdatingArchiveController.this.outFile.delete();
                                if (!$assertionsDisabled && !bl) {
                                    throw new AssertionError();
                                }
                                UpdatingArchiveController.this.outFile = null;
                                throw throwable;
                            }
                        }
                        UpdatingArchiveController.this.outFile = null;
                        throw iOException;
                    }
                    UpdatingArchiveController.this.fileSystem = new ArchiveFileSystem(UpdatingArchiveController.this);
                }

                static {
                    $assertionsDisabled = !(class$de$schlichtherle$io$UpdatingArchiveController == null ? (class$de$schlichtherle$io$UpdatingArchiveController = UpdatingArchiveController.class$("de.schlichtherle.io.UpdatingArchiveController")) : class$de$schlichtherle$io$UpdatingArchiveController).desiredAssertionStatus();
                }
            }
            archiveController.runWriteLocked(new Unwrapper(archiveController, bl, string));
        }
        catch (ArchiveController.FalsePositiveDirectoryEntryException falsePositiveDirectoryEntryException) {
            if (falsePositiveDirectoryEntryException.getTarget() == archiveController) {
                throw falsePositiveDirectoryEntryException;
            }
            this.unwrap(archiveController.getEnclController(), archiveController.enclEntryName(string), bl);
        }
        if (!$assertionsDisabled && this.fileSystem == null) {
            throw new AssertionError();
        }
    }

    private void initInArchive(java.io.File file) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null) {
            throw new AssertionError();
        }
        logger.log(Level.FINEST, "initInArchive.entering", file);
        try {
            try {
                SimpleReadOnlyFile simpleReadOnlyFile = this.usesNativeTargetFile() ? new ArchiveController.CountingReadOnlyFile(file) : new SimpleReadOnlyFile(file);
                try {
                    this.inArchive = this.getDriver().createInputArchive(this, simpleReadOnlyFile);
                    this.inArchive.setMetaData(new InputArchiveMetaData(this.inArchive));
                }
                catch (Throwable throwable) {
                    simpleReadOnlyFile.close();
                    if (throwable instanceof IOException) {
                        throw (IOException)throwable;
                    }
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    if (throwable instanceof Error) {
                        throw (Error)throwable;
                    }
                    throw new AssertionError((Object)throwable);
                }
                Object var5_5 = null;
            }
            catch (IOException iOException) {
                if (!$assertionsDisabled && this.inArchive != null) {
                    throw new AssertionError();
                }
                logger.log(Level.FINEST, "initInArchive.throwing", iOException);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            logger.log(Level.FINEST, "initInArchive.finally", new Object[]{file, new Integer(this.inArchive != null ? this.inArchive.getNumArchiveEntries() : 0)});
            throw throwable;
        }
        logger.log(Level.FINEST, "initInArchive.finally", new Object[]{file, new Integer(this.inArchive != null ? this.inArchive.getNumArchiveEntries() : 0)});
        if (!$assertionsDisabled && this.inArchive == null) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(final String string) throws IOException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        this.readLock().lock();
        try {
            ArchiveEntry archiveEntry;
            if (this.hasNewData(string)) {
                this.runWriteLocked(new ArchiveController.IORunnable(){

                    public void run() throws IOException {
                        if (UpdatingArchiveController.this.hasNewData(string)) {
                            UpdatingArchiveController.this.update();
                        }
                    }
                });
            }
            if ((archiveEntry = this.getFileSystem(false).get(string)) == null) {
                throw new ArchiveEntryNotFoundException(string, "No such entry!");
            }
            InputStream inputStream = this.getInputStream(archiveEntry, null);
            return inputStream;
        }
        finally {
            this.readLock().unlock();
        }
    }

    protected InputStream getInputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!($assertionsDisabled || this.readLock().isLocked() || this.writeLock().isLocked())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.hasNewData(archiveEntry.getName())) {
            throw new AssertionError();
        }
        if (archiveEntry.isDirectory()) {
            throw new ArchiveEntryNotFoundException(archiveEntry.getName(), "Cannot read directory entry!");
        }
        InputStream inputStream = this.inArchive.getMetaData().getStream(archiveEntry, archiveEntry2);
        if (inputStream == null) {
            throw new ArchiveEntryNotFoundException(archiveEntry.getName(), "Illegal access to archive file!");
        }
        return inputStream;
    }

    protected OutputStream getOutputStream(String string) throws IOException {
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        class OutputStreamGetter
        implements ArchiveController.IORunnable {
            OutputStream out;
            private final /* synthetic */ String val$entryName;

            OutputStreamGetter(String string) {
                this.val$entryName = string;
            }

            public void run() throws IOException {
                if (UpdatingArchiveController.this.hasNewData(this.val$entryName)) {
                    UpdatingArchiveController.this.update();
                }
                boolean bl = File.isLenient();
                ArchiveFileSystem archiveFileSystem = UpdatingArchiveController.this.getFileSystem(bl);
                ArchiveFileSystem.Delta delta = archiveFileSystem.beginCreateAndLink(this.val$entryName, bl);
                this.out = UpdatingArchiveController.this.getOutputStream(delta.getEntry(), null);
                delta.commit();
            }
        }
        OutputStreamGetter outputStreamGetter = new OutputStreamGetter(string);
        this.runWriteLocked(outputStreamGetter);
        return outputStreamGetter.out;
    }

    protected OutputStream getOutputStream(ArchiveEntry archiveEntry, ArchiveEntry archiveEntry2) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.hasNewData(archiveEntry.getName())) {
            throw new AssertionError();
        }
        this.ensureOutArchive();
        return this.outArchive.getMetaData().getStream(archiveEntry, archiveEntry2);
    }

    protected void onFileSystemTouch() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        this.ensureOutArchive();
        this.schedule(true);
    }

    private void ensureOutArchive() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (this.outArchive != null) {
            return;
        }
        java.io.File file = this.outFile;
        if (file == null) {
            file = this.usesNativeTargetFile() && !this.getTarget().isFile() ? this.getTarget() : File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX);
        }
        this.initOutArchive(file);
        this.outFile = file;
    }

    private void initOutArchive(java.io.File file) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null) {
            throw new AssertionError();
        }
        logger.log(Level.FINEST, "initOutArchive.entering", file);
        try {
            OutputStream outputStream = new FileOutputStream(file);
            if (file == this.getTarget()) {
                outputStream = new ArchiveController.CountingOutputStream(outputStream);
            }
            try {
                this.outArchive = this.getDriver().createOutputArchive(this, outputStream, this.inArchive);
                this.outArchive.setMetaData(new OutputArchiveMetaData(this.outArchive));
            }
            catch (Throwable throwable) {
                ((OutputStream)outputStream).close();
                if (!file.delete()) {
                    IOException iOException = new IOException(file.getPath() + " (couldn't delete corrupted output file)");
                    iOException.initCause(throwable);
                    throw iOException;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw new AssertionError((Object)throwable);
            }
        }
        catch (IOException iOException) {
            if (!$assertionsDisabled && this.outArchive != null) {
                throw new AssertionError();
            }
            logger.log(Level.FINEST, "initOutArchive.throwing", iOException);
            throw iOException;
        }
        finally {
            logger.log(Level.FINEST, "initOutArchive.finally", file);
        }
        if (!$assertionsDisabled && this.outArchive == null) {
            throw new AssertionError();
        }
    }

    protected boolean hasNewData(String string) {
        if (!($assertionsDisabled || this.readLock().isLocked() || this.writeLock().isLocked())) {
            throw new AssertionError();
        }
        return this.outArchive != null && this.outArchive.getArchiveEntry(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void update(ArchiveException archiveException, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws ArchiveException {
        if (!$assertionsDisabled && !bl2 && bl4) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bl5 && !bl6) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.inArchive != null && this.inFile == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive != null && this.outFile == null) {
            throw new AssertionError();
        }
        logger.log(Level.FINER, "update.entering", new Object[]{this.getPath(), archiveException, bl, bl2, bl3, bl4, bl5, bl6});
        try {
            ArchiveException archiveException2;
            block44: {
                int n;
                Object object;
                archiveException2 = archiveException;
                Thread.interrupted();
                if (this.numInputStreams() > 0 || this.numOutputStreams() > 0) {
                    System.gc();
                    System.runFinalization();
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.outArchive != null) {
                    object = this.outArchive.getMetaData();
                    if (bl3) {
                        ((OutputArchiveMetaData)object).waitAllStreamsInOtherThreads();
                    }
                    if ((n = ((OutputArchiveMetaData)object).getNumStreams()) > 0) {
                        if (!bl4) {
                            throw new ArchiveOutputBusyException(archiveException, this.getPath(), n);
                        }
                        archiveException = new ArchiveOutputBusyWarningException(archiveException, this.getPath(), n);
                    }
                }
                if (this.inArchive != null) {
                    object = this.inArchive.getMetaData();
                    if (bl) {
                        ((InputArchiveMetaData)object).waitAllStreamsInOtherThreads();
                    }
                    if ((n = ((InputArchiveMetaData)object).getNumStreams()) > 0) {
                        if (!bl2) {
                            throw new ArchiveInputBusyException(archiveException, this.getPath(), n);
                        }
                        archiveException = new ArchiveInputBusyWarningException(archiveException, this.getPath(), n);
                    }
                }
                try {
                    if (this.isTouched()) {
                        block43: {
                            this.needsReassembly = true;
                            try {
                                archiveException = this.updateOutArchive(archiveException);
                                if (!$assertionsDisabled && this.fileSystem != null) {
                                    throw new AssertionError();
                                }
                                if (!$assertionsDisabled && this.inArchive != null) {
                                    throw new AssertionError();
                                }
                                Object var12_14 = null;
                                if ($assertionsDisabled || this.outArchive == null) break block43;
                                throw new AssertionError();
                            }
                            catch (Throwable throwable) {
                                Object var12_15 = null;
                                if ($assertionsDisabled || this.outArchive == null) throw throwable;
                                throw new AssertionError();
                            }
                        }
                        try {
                            if (bl6) {
                                archiveException = this.reassembleTargetFile(archiveException);
                                this.needsReassembly = false;
                            }
                            this.shutdownStep3(bl5 && !this.needsReassembly);
                            break block44;
                        }
                        catch (Throwable throwable) {
                            this.shutdownStep3(bl5 && !this.needsReassembly);
                            throw throwable;
                        }
                    }
                    if (bl6 && this.needsReassembly) {
                        if (!$assertionsDisabled && this.outFile != null) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.inFile == null) {
                            throw new AssertionError();
                        }
                        this.shutdownStep2(archiveException);
                        this.outFile = this.inFile;
                        this.inFile = null;
                        try {
                            archiveException = this.reassembleTargetFile(archiveException);
                            this.needsReassembly = false;
                            this.shutdownStep3(bl5 && !this.needsReassembly);
                            break block44;
                        }
                        catch (Throwable throwable) {
                            this.shutdownStep3(bl5 && !this.needsReassembly);
                            throw throwable;
                        }
                    }
                    if (bl5) {
                        if (!$assertionsDisabled && !bl6) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && this.needsReassembly) {
                            throw new AssertionError();
                        }
                        this.shutdownStep2(archiveException);
                        this.shutdownStep3(true);
                    } else if (!$assertionsDisabled && this.outArchive != null) {
                        throw new AssertionError();
                    }
                }
                catch (IOException iOException) {
                    throw new ArchiveException(archiveException, iOException);
                }
                finally {
                    this.schedule(this.needsReassembly);
                }
            }
            if (archiveException != archiveException2) {
                logger.log(Level.FINER, "update.warning", archiveException);
                throw archiveException;
            }
        }
        catch (ArchiveException archiveException3) {
            logger.log(Level.FINE, "update.throwing", archiveException3);
            throw archiveException3;
        }
        logger.log(Level.FINEST, "update.exiting");
    }

    private final int numInputStreams() {
        return this.inArchive != null ? this.inArchive.getMetaData().getNumStreams() : 0;
    }

    private final int numOutputStreams() {
        return this.outArchive != null ? this.outArchive.getMetaData().getNumStreams() : 0;
    }

    protected final boolean isTouched() {
        return this.fileSystem != null && this.fileSystem.isTouched();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArchiveException updateOutArchive(ArchiveException archiveException) throws ArchiveException {
        long l;
        Object object;
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.isTouched()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.outArchive == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.fileSystem == null) {
            throw new AssertionError();
        }
        OutputArchive outputArchive = this.outArchive;
        synchronized (outputArchive) {
            Enumeration enumeration = this.outArchive.getArchiveEntries();
            while (enumeration.hasMoreElements()) {
                object = ((ArchiveEntry)enumeration.nextElement()).getName();
                if (this.fileSystem.isFile((String)object)) continue;
                archiveException = new ArchiveWarningException(archiveException, this.getPath() + ": Couldn't remove archive entry: " + (String)object);
            }
        }
        try {
            try {
                object = this.outArchive;
                synchronized (object) {
                    try {
                        archiveException = this.shutdownStep1(archiveException);
                        ArchiveWarningException archiveWarningException = null;
                        ArchiveWarningException archiveWarningException2 = null;
                        Enumeration enumeration = this.fileSystem.getReversedEntries();
                        while (enumeration.hasMoreElements()) {
                            ArchiveEntry archiveEntry = (ArchiveEntry)enumeration.nextElement();
                            String string = archiveEntry.getName();
                            if (this.hasNewData(string)) continue;
                            if (archiveEntry.isDirectory()) {
                                if (string.equals("/") || archiveEntry.getTime() < 0L) continue;
                                this.outArchive.storeDirectory(archiveEntry);
                                continue;
                            }
                            if (this.inArchive != null && this.inArchive.getArchiveEntry(string) != null) {
                                InputStream inputStream;
                                if (!$assertionsDisabled && archiveEntry != this.inArchive.getArchiveEntry(string)) {
                                    throw new AssertionError();
                                }
                                try {
                                    inputStream = this.inArchive.getInputStream(archiveEntry, archiveEntry);
                                }
                                catch (IOException iOException) {
                                    if (archiveWarningException != null) continue;
                                    archiveWarningException = new ArchiveWarningException(archiveException, this.getPath() + ": Skipped one or more corrupted archive entries from the input!", iOException);
                                    archiveException = archiveWarningException;
                                    continue;
                                }
                                try {
                                    OutputStream outputStream = this.outArchive.getOutputStream(archiveEntry, archiveEntry);
                                    try {
                                        File.cat(inputStream, outputStream);
                                        continue;
                                    }
                                    catch (InputIOException inputIOException) {
                                        if (archiveWarningException2 != null) continue;
                                        archiveWarningException2 = new ArchiveWarningException(archiveException, this.getPath() + ": One or more archive entries in the output may be corrupted!", (IOException)inputIOException);
                                        archiveException = archiveWarningException2;
                                        continue;
                                    }
                                    finally {
                                        outputStream.close();
                                        continue;
                                    }
                                }
                                finally {
                                    inputStream.close();
                                    continue;
                                }
                            }
                            this.outArchive.getOutputStream(archiveEntry, null).close();
                        }
                    }
                    finally {
                        l = this.fileSystem.lastModified("/");
                        this.shutdownStep2(archiveException);
                    }
                }
            }
            catch (IOException iOException) {
                boolean bl = this.outFile.delete();
                this.outFile = null;
                if (!$assertionsDisabled && !bl) {
                    throw new AssertionError();
                }
                throw iOException;
            }
        }
        catch (ArchiveException archiveException2) {
            throw archiveException2;
        }
        catch (IOException iOException) {
            throw new ArchiveException(archiveException, this.getPath() + ": Could not update archive file - all changes are lost!", iOException);
        }
        if (!this.outFile.setLastModified(l)) {
            archiveException = new ArchiveWarningException(archiveException, this.getPath() + ": Couldn't preserve last modification time!");
        }
        return archiveException;
    }

    private ArchiveException reassembleTargetFile(ArchiveException archiveException) throws ArchiveException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (this.usesNativeTargetFile()) {
            if (this.outFile != this.getTarget()) {
                try {
                    FileInputStream fileInputStream;
                    ArchiveController.CountingOutputStream countingOutputStream = new ArchiveController.CountingOutputStream(new FileOutputStream(this.getTarget()));
                    try {
                        fileInputStream = new FileInputStream(this.outFile);
                    }
                    catch (IOException iOException) {
                        ((OutputStream)countingOutputStream).close();
                        throw iOException;
                    }
                    File.cp(fileInputStream, countingOutputStream);
                }
                catch (IOException iOException) {
                    throw new ArchiveException(archiveException, this.getPath() + " (could not update archive file - all changes are lost)", iOException);
                }
                long l = this.outFile.lastModified();
                if (l != 0L && !this.getTarget().setLastModified(l)) {
                    archiveException = new ArchiveWarningException(archiveException, this.getPath() + " (couldn't preserve last modification time)");
                }
            }
        } else {
            try {
                this.wrap(this.getEnclController(), this.getEnclEntryName());
            }
            catch (IOException iOException) {
                throw new ArchiveException(archiveException, this.getEnclController().getPath() + "/" + this.getEnclEntryName() + " (could not update archive entry - all changes are lost)", iOException);
            }
        }
        return archiveException;
    }

    private void wrap(ArchiveController archiveController, String string) throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && archiveController == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && string == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && "" == string) {
            throw new AssertionError();
        }
        class Wrapper
        implements ArchiveController.IORunnable {
            private final /* synthetic */ ArchiveController val$controller;
            private final /* synthetic */ String val$entryName;

            Wrapper(ArchiveController archiveController, String string) {
                this.val$controller = archiveController;
                this.val$entryName = string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileInputStream fileInputStream = new FileInputStream(UpdatingArchiveController.this.outFile);
                try {
                    ArchiveController.cp(UpdatingArchiveController.this.outFile, fileInputStream, null, this.val$controller, this.val$entryName, true);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
        }
        archiveController.runWriteLocked(new Wrapper(archiveController, string));
    }

    protected void reset() throws IOException {
        if (!$assertionsDisabled && !this.writeLock().isLocked()) {
            throw new AssertionError();
        }
        ArchiveException archiveException = this.shutdownStep1(null);
        this.shutdownStep2(archiveException);
        this.shutdownStep3(true);
        this.schedule(false);
        if (archiveException != null) {
            throw archiveException;
        }
    }

    protected void finalize() throws Throwable {
        logger.log(Level.FINEST, "finalize.entering", this.getPath());
        if (this.isTouched()) {
            logger.log(Level.WARNING, "finalize.hasUpdatedEntries", this.getPath());
        }
        this.shutdownStep1(null);
        this.shutdownStep2(null);
        this.shutdownStep3(true);
        super.finalize();
    }

    private ArchiveException shutdownStep1(ArchiveException archiveException) {
        if (this.outArchive != null) {
            archiveException = this.outArchive.getMetaData().closeAllStreams(archiveException);
        }
        if (this.inArchive != null) {
            archiveException = this.inArchive.getMetaData().closeAllStreams(archiveException);
        }
        return archiveException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdownStep2(ArchiveException archiveException) throws ArchiveException {
        ArchiveException archiveException2 = archiveException;
        this.fileSystem = null;
        if (this.outArchive != null) {
            try {
                this.outArchive.close();
            }
            catch (IOException iOException) {
                archiveException = new ArchiveException(archiveException, iOException);
            }
            finally {
                this.outArchive = null;
            }
        }
        if (this.inArchive != null) {
            try {
                this.inArchive.close();
            }
            catch (IOException iOException) {
                archiveException = new ArchiveException(archiveException, iOException);
            }
            finally {
                this.inArchive = null;
            }
        }
        if (archiveException != archiveException2) {
            throw archiveException;
        }
    }

    private void shutdownStep3(boolean bl) {
        boolean bl2;
        if (this.inFile != null) {
            if (this.inFile != this.getTarget()) {
                bl2 = this.inFile.delete();
                if (!$assertionsDisabled && !bl2) {
                    throw new AssertionError();
                }
            }
            this.inFile = null;
        }
        if (this.outFile != null) {
            if (bl) {
                if (this.outFile != this.getTarget()) {
                    bl2 = this.outFile.delete();
                    if (!$assertionsDisabled && !bl2) {
                        throw new AssertionError();
                    }
                }
            } else {
                if (!$assertionsDisabled && !this.outFile.isFile()) {
                    throw new AssertionError();
                }
                this.inFile = this.outFile;
            }
            this.outFile = null;
        }
        if (bl) {
            this.needsReassembly = false;
        }
    }

    static {
        $assertionsDisabled = !UpdatingArchiveController.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/io/UpdatingArchiveController".replace('/', '.');
        logger = Logger.getLogger(CLASS_NAME, CLASS_NAME);
    }

    private class ArchiveEntryNotFoundException
    extends FileNotFoundException {
        private final String entry;
        private final String msg;

        private ArchiveEntryNotFoundException(String string, String string2) {
            this.entry = string;
            this.msg = string2;
        }

        public String getMessage() {
            return UpdatingArchiveController.this.getPath() + this.entry + ": " + this.msg;
        }
    }

    private class ArchiveNotFoundException
    extends FileNotFoundException {
        private ArchiveNotFoundException() {
        }

        public String getMessage() {
            return UpdatingArchiveController.this.getPath();
        }
    }
}

