/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.spi;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.ArchiveDriver;
import java.io.CharConversionException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import javax.swing.Icon;

public abstract class AbstractArchiveDriver
implements ArchiveDriver {
    private final String encoding;
    private final ThreadLocal tl = new ThreadLocal(){

        protected Object initialValue() {
            return Charset.forName(AbstractArchiveDriver.this.getEncoding()).newEncoder();
        }
    };
    private final Icon openIcon;
    private final Icon closedIcon;

    protected AbstractArchiveDriver(String string, Icon icon, Icon icon2) {
        this.encoding = string;
        this.openIcon = icon;
        this.closedIcon = icon2;
        this.tl.get();
    }

    public final String getEncoding() {
        return this.encoding;
    }

    protected final void ensureEncodable(String string) throws CharConversionException {
        CharsetEncoder charsetEncoder = (CharsetEncoder)this.tl.get();
        if (!charsetEncoder.canEncode(string)) {
            throw new CharConversionException(string + ": Illegal characters in entry name!");
        }
    }

    public Icon getOpenIcon(Archive archive) {
        return this.openIcon;
    }

    public Icon getClosedIcon(Archive archive) {
        return this.closedIcon;
    }
}

