/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.archive.zip;

import de.schlichtherle.io.archive.Archive;
import de.schlichtherle.io.archive.spi.AbstractArchiveDriver;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.InputArchive;
import de.schlichtherle.io.archive.spi.OutputArchive;
import de.schlichtherle.io.archive.zip.Zip32Entry;
import de.schlichtherle.io.archive.zip.Zip32InputArchive;
import de.schlichtherle.io.archive.zip.Zip32OutputArchive;
import de.schlichtherle.io.rof.ReadOnlyFile;
import java.io.CharConversionException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.ZipException;
import javax.swing.Icon;

public class Zip32Driver
extends AbstractArchiveDriver {
    private final boolean preambled;
    private final boolean postambled;

    public Zip32Driver() {
        this("CP437", false, false, null, null);
    }

    public Zip32Driver(String string) {
        this(string, false, false, null, null);
    }

    public Zip32Driver(String string, boolean bl, boolean bl2, Icon icon, Icon icon2) {
        super(string, icon, icon2);
        this.preambled = bl;
        this.postambled = bl2;
    }

    public boolean getPreambled() {
        return this.preambled;
    }

    public boolean getPostambled() {
        return this.postambled;
    }

    public ArchiveEntry createArchiveEntry(Archive archive, String string, ArchiveEntry archiveEntry) throws CharConversionException {
        Zip32Entry zip32Entry;
        this.ensureEncodable(string);
        if (archiveEntry != null) {
            if (archiveEntry instanceof Zip32Entry) {
                zip32Entry = new Zip32Entry(string, (Zip32Entry)archiveEntry);
            } else {
                zip32Entry = new Zip32Entry(string);
                zip32Entry.setTime(archiveEntry.getTime());
            }
        } else {
            zip32Entry = new Zip32Entry(string);
        }
        return zip32Entry;
    }

    public InputArchive createInputArchive(Archive archive, ReadOnlyFile readOnlyFile) throws UnsupportedEncodingException, FileNotFoundException, IOException {
        return this.createZip32InputArchive(readOnlyFile, this.getEncoding(), this.getPreambled(), this.getPostambled());
    }

    protected Zip32InputArchive createZip32InputArchive(ReadOnlyFile readOnlyFile, String string, boolean bl, boolean bl2) throws NullPointerException, UnsupportedEncodingException, FileNotFoundException, ZipException, IOException {
        return new Zip32InputArchive(readOnlyFile, string, bl, bl2);
    }

    public OutputArchive createOutputArchive(Archive archive, OutputStream outputStream, InputArchive inputArchive) throws UnsupportedEncodingException, IOException {
        return this.createZip32OutputArchive(outputStream, this.getEncoding(), (Zip32InputArchive)inputArchive);
    }

    protected Zip32OutputArchive createZip32OutputArchive(OutputStream outputStream, String string, Zip32InputArchive zip32InputArchive) throws NullPointerException, UnsupportedEncodingException, IOException {
        return new Zip32OutputArchive(outputStream, string, zip32InputArchive);
    }
}

