/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.KeyPromptingCancelledException;
import de.schlichtherle.key.KeyProvider;
import de.schlichtherle.key.PromptingKeyManager;
import de.schlichtherle.key.PromptingKeyProviderUI;
import de.schlichtherle.key.SharedKeyProvider;
import de.schlichtherle.key.UnknownKeyException;

public class PromptingKeyProvider
extends SharedKeyProvider
implements KeyProvider {
    private String resourceID;
    private PromptingKeyProviderUI ui;
    private FlyweightState state;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getResourceID() {
        return this.resourceID;
    }

    final void setResourceID(String string) {
        this.resourceID = string;
    }

    protected KeyProvider addToKeyManager(String string) throws NullPointerException, IllegalStateException {
        String string2 = this.getResourceID();
        if (string2 != null && !string2.equals(string)) {
            throw new IllegalStateException("PromptingKeyProvider instances cannot be shared!");
        }
        KeyProvider keyProvider = super.addToKeyManager(string);
        this.setResourceID(string);
        return keyProvider;
    }

    protected KeyProvider removeFromKeyManager(String string) throws NullPointerException, IllegalStateException {
        if (!$assertionsDisabled && this.getResourceID() != string) {
            throw new AssertionError();
        }
        KeyProvider keyProvider = super.removeFromKeyManager(string);
        this.setResourceID(null);
        return keyProvider;
    }

    protected String getUIClassID() {
        return "de.schlichtherle.key.PromptingKeyProvider";
    }

    private final PromptingKeyProviderUI getUI() {
        return this.ui;
    }

    final void setUI(PromptingKeyProviderUI promptingKeyProviderUI) {
        this.ui = promptingKeyProviderUI;
    }

    private final FlyweightState getState() {
        return this.state;
    }

    private final void setState(FlyweightState flyweightState) {
        this.state = flyweightState;
    }

    public final synchronized Object getCreateKey() throws UnknownKeyException {
        return this.getState().getCreateKey(this);
    }

    private Object promptCreateKey() throws UnknownKeyException {
        PromptingKeyManager.ensurePrompting();
        Object object = this.getKey();
        PromptingKeyProviderUI promptingKeyProviderUI = this.getUI();
        promptingKeyProviderUI.promptCreateKey(this);
        this.resetKey(object);
        if (this.getKey() != null) {
            this.setState(KeyChanged.STATE);
            return this.cloneKey();
        }
        this.setState(Cancelled.STATE);
        throw new KeyPromptingCancelledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKey(Object object) {
        if (object != null && this.getKey() != object) {
            Object object2 = this.getKey();
            try {
                this.setKey(object);
                this.resetKey();
            }
            finally {
                this.setKey(object2);
            }
        }
    }

    public final synchronized Object getOpenKey() throws UnknownKeyException {
        return this.getState().getOpenKey(this);
    }

    private Object promptOpenKey(boolean bl) throws UnknownKeyException {
        PromptingKeyManager.ensurePrompting();
        Object object = this.getKey();
        PromptingKeyProviderUI promptingKeyProviderUI = this.getUI();
        boolean bl2 = bl ? promptingKeyProviderUI.promptInvalidOpenKey(this) : promptingKeyProviderUI.promptUnknownOpenKey(this);
        this.resetKey(object);
        if (this.getKey() != null) {
            if (bl2) {
                this.setState(KeyChangeRequested.STATE);
            } else {
                this.setState(KeyProvided.STATE);
            }
            return this.cloneKey();
        }
        this.setState(Cancelled.STATE);
        throw new KeyPromptingCancelledException();
    }

    public final synchronized void invalidOpenKey() {
        this.getState().invalidOpenKey(this);
    }

    final synchronized void resetCancelledPrompt() {
        this.getState().resetCancelledPrompt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.setState(Reset.STATE);
        try {
            this.resetKey();
        }
        finally {
            this.onReset();
        }
    }

    protected void onReset() {
    }

    static {
        $assertionsDisabled = !PromptingKeyProvider.class.desiredAssertionStatus();
    }

    private static class Cancelled
    extends FlyweightState {
        private static final FlyweightState STATE = new Cancelled();

        private Cancelled() {
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            throw new KeyPromptingCancelledException();
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            throw new KeyPromptingCancelledException();
        }

        public void resetCancelledPrompt(PromptingKeyProvider promptingKeyProvider) {
            promptingKeyProvider.reset();
        }
    }

    private static class KeyChanged
    extends KeyProvided {
        private static final FlyweightState STATE = new KeyChanged();

        private KeyChanged() {
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }
    }

    private static class KeyChangeRequested
    extends KeyProvided {
        private static final FlyweightState STATE = new KeyChangeRequested();

        private KeyChangeRequested() {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptCreateKey();
        }
    }

    private static class KeyProvided
    extends FlyweightState {
        private static final FlyweightState STATE = new KeyProvided();

        private KeyProvided() {
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) {
            return promptingKeyProvider.cloneKey();
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
            promptingKeyProvider.setState(KeyInvalidated.STATE);
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.cloneKey();
        }
    }

    private static class KeyInvalidated
    extends Reset {
        private static final FlyweightState STATE = new KeyInvalidated();

        private KeyInvalidated() {
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptOpenKey(true);
        }
    }

    private static class Reset
    extends FlyweightState {
        private static final FlyweightState STATE = new Reset();

        private Reset() {
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptOpenKey(false);
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptCreateKey();
        }
    }

    private static abstract class FlyweightState {
        private FlyweightState() {
        }

        public abstract Object getOpenKey(PromptingKeyProvider var1) throws UnknownKeyException;

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }

        public abstract Object getCreateKey(PromptingKeyProvider var1) throws UnknownKeyException;

        public void resetCancelledPrompt(PromptingKeyProvider promptingKeyProvider) {
        }
    }
}

