/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import jode.bytecode.FieldInfo;
import jode.obfuscator.ClassIdentifier;
import jode.obfuscator.Identifier;
import jode.obfuscator.Main;

public class FieldIdentifier
extends Identifier {
    FieldInfo info;
    ClassIdentifier clazz;
    String name;
    String type;
    private boolean notConstant;
    private Object constant;
    private Collection fieldListeners;

    public void setSingleReachable() {
        super.setSingleReachable();
        Main.getClassBundle().analyzeIdentifier(this);
    }

    public void setSinglePreserved() {
        super.setSinglePreserved();
        this.setNotConstant();
    }

    public void analyze() {
        String string = this.getType();
        int n = string.indexOf(76);
        if (n != -1) {
            int n2 = string.indexOf(59, n);
            Main.getClassBundle().reachableClass(string.substring(n + 1, n2).replace('/', '.'));
        }
    }

    public Identifier getParent() {
        return this.clazz;
    }

    public String getFullName() {
        return this.clazz.getFullName() + "." + this.getName() + "." + this.getType();
    }

    public String getFullAlias() {
        return this.clazz.getFullAlias() + "." + this.getAlias() + "." + Main.getClassBundle().getTypeAlias(this.getType());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.info.getModifiers();
    }

    public Iterator getChilds() {
        return Collections.EMPTY_LIST.iterator();
    }

    public boolean isNotConstant() {
        return this.notConstant;
    }

    public Object getConstant() {
        return this.constant;
    }

    public void addFieldListener(Identifier identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        if (this.fieldListeners == null) {
            this.fieldListeners = new HashSet();
        }
        if (!this.fieldListeners.contains(identifier)) {
            this.fieldListeners.add(identifier);
        }
    }

    public void setNotConstant() {
        if (this.notConstant) {
            return;
        }
        this.notConstant = true;
        if (this.fieldListeners == null) {
            return;
        }
        Iterator iterator = this.fieldListeners.iterator();
        while (iterator.hasNext()) {
            Main.getClassBundle().analyzeIdentifier((Identifier)iterator.next());
        }
        this.fieldListeners = null;
    }

    public String toString() {
        return "FieldIdentifier " + this.getFullName();
    }

    public boolean conflicting(String string) {
        return this.clazz.fieldConflicts(this, string);
    }

    public void doTransformations() {
        this.info.setName(this.getAlias());
        this.info.setType(Main.getClassBundle().getTypeAlias(this.type));
    }

    public FieldIdentifier(ClassIdentifier classIdentifier, FieldInfo fieldInfo) {
        super(fieldInfo.getName());
        this.name = fieldInfo.getName();
        this.type = fieldInfo.getType();
        this.info = fieldInfo;
        this.clazz = classIdentifier;
        this.constant = fieldInfo.getConstant();
    }
}

