/*
 * Decompiled with CFR 0.152.
 */
package jode.obfuscator;

import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import jode.AssertError;
import jode.GlobalOptions;
import jode.bytecode.BytecodeInfo;
import jode.bytecode.Handler;
import jode.bytecode.Instruction;
import jode.bytecode.MethodInfo;
import jode.bytecode.Opcodes;
import jode.obfuscator.ClassBundle;
import jode.obfuscator.ClassIdentifier;
import jode.obfuscator.CodeAnalyzer;
import jode.obfuscator.CodeTransformer;
import jode.obfuscator.Identifier;
import jode.obfuscator.Main;

public class MethodIdentifier
extends Identifier
implements Opcodes {
    ClassIdentifier clazz;
    MethodInfo info;
    String name;
    String type;
    boolean globalSideEffects;
    BitSet localSideEffects;
    CodeAnalyzer codeAnalyzer;
    boolean wasTransformed = false;

    public Iterator getChilds() {
        return Collections.EMPTY_LIST.iterator();
    }

    public void setSingleReachable() {
        super.setSingleReachable();
        Main.getClassBundle().analyzeIdentifier(this);
    }

    public void analyze() {
        BytecodeInfo bytecodeInfo;
        if (GlobalOptions.verboseLevel > 1) {
            GlobalOptions.err.println("Analyze: " + this);
        }
        String string = this.getType();
        int n = string.indexOf(76);
        while (n != -1) {
            int n2 = string.indexOf(59, n);
            Main.getClassBundle().reachableClass(string.substring(n + 1, n2).replace('/', '.'));
            n = string.indexOf(76, n2);
        }
        String[] stringArray = this.info.getExceptions();
        if (stringArray != null) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                Main.getClassBundle().reachableClass(stringArray[n3]);
                ++n3;
            }
        }
        if ((bytecodeInfo = this.info.getBytecode()) != null) {
            this.codeAnalyzer.analyzeCode(this, bytecodeInfo);
        }
    }

    public Identifier getParent() {
        return this.clazz;
    }

    public String getFullName() {
        return this.clazz.getFullName() + "." + this.getName() + "." + this.getType();
    }

    public String getFullAlias() {
        return this.clazz.getFullAlias() + "." + this.getAlias() + "." + Main.getClassBundle().getTypeAlias(this.getType());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public int getModifiers() {
        return this.info.getModifiers();
    }

    public boolean conflicting(String string) {
        return this.clazz.methodConflicts(this, string);
    }

    public String toString() {
        return "MethodIdentifier " + this.getFullName();
    }

    public boolean hasGlobalSideEffects() {
        return this.globalSideEffects;
    }

    public boolean getLocalSideEffects(int n) {
        return this.globalSideEffects || this.localSideEffects.get(n);
    }

    public void setGlobalSideEffects() {
        this.globalSideEffects = true;
    }

    public void setLocalSideEffects(int n) {
        this.localSideEffects.set(n);
    }

    public void doTransformations() {
        String[] stringArray;
        if (this.wasTransformed) {
            throw new AssertError("doTransformation called on transformed method");
        }
        this.wasTransformed = true;
        this.info.setName(this.getAlias());
        ClassBundle classBundle = Main.getClassBundle();
        this.info.setType(classBundle.getTypeAlias(this.type));
        if (this.codeAnalyzer != null) {
            Object object;
            stringArray = this.info.getBytecode();
            try {
                if (this.isReachable()) {
                    this.codeAnalyzer.transformCode((BytecodeInfo)stringArray);
                }
                object = classBundle.getPostTransformers();
                int n = 0;
                while (n < ((CodeTransformer[])object).length) {
                    object[n].transformCode((BytecodeInfo)stringArray);
                    ++n;
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace(GlobalOptions.err);
                stringArray.dumpCode(GlobalOptions.err);
            }
            object = stringArray.getInstructions().iterator();
            while (object.hasNext()) {
                Instruction instruction = (Instruction)object.next();
                switch (instruction.getOpcode()) {
                    case 182: 
                    case 183: 
                    case 184: 
                    case 185: {
                        instruction.setReference(Main.getClassBundle().getReferenceAlias(instruction.getReference()));
                        break;
                    }
                    case 178: 
                    case 179: 
                    case 180: 
                    case 181: {
                        instruction.setReference(Main.getClassBundle().getReferenceAlias(instruction.getReference()));
                        break;
                    }
                    case 187: 
                    case 192: 
                    case 193: 
                    case 197: {
                        instruction.setClazzType(Main.getClassBundle().getTypeAlias(instruction.getClazzType()));
                        break;
                    }
                }
            }
            object = stringArray.getExceptionHandlers();
            int n = 0;
            while (n < ((Object)object).length) {
                ClassIdentifier classIdentifier;
                if (((Handler)object[n]).type != null && (classIdentifier = Main.getClassBundle().getClassIdentifier(((Handler)object[n]).type)) != null) {
                    ((Handler)object[n]).type = classIdentifier.getFullAlias();
                }
                ++n;
            }
            this.info.setBytecode((BytecodeInfo)stringArray);
        }
        if ((stringArray = this.info.getExceptions()) != null) {
            int n = 0;
            while (n < stringArray.length) {
                ClassIdentifier classIdentifier = Main.getClassBundle().getClassIdentifier(stringArray[n]);
                if (classIdentifier != null) {
                    stringArray[n] = classIdentifier.getFullAlias();
                }
                ++n;
            }
        }
    }

    public MethodIdentifier(ClassIdentifier classIdentifier, MethodInfo methodInfo) {
        super(methodInfo.getName());
        this.name = methodInfo.getName();
        this.type = methodInfo.getType();
        this.clazz = classIdentifier;
        this.info = methodInfo;
        BytecodeInfo bytecodeInfo = methodInfo.getBytecode();
        if (bytecodeInfo != null) {
            if ((Main.stripping & 4) != 0) {
                methodInfo.getBytecode().setLocalVariableTable(null);
            }
            if ((Main.stripping & 8) != 0) {
                methodInfo.getBytecode().setLineNumberTable(null);
            }
            this.codeAnalyzer = Main.getClassBundle().getCodeAnalyzer();
            CodeTransformer[] codeTransformerArray = Main.getClassBundle().getPreTransformers();
            int n = 0;
            while (n < codeTransformerArray.length) {
                codeTransformerArray[n].transformCode(bytecodeInfo);
                ++n;
            }
            methodInfo.setBytecode(bytecodeInfo);
        }
    }
}

