/*
 * Decompiled with CFR 0.152.
 */
package sdoc.util;

public class DynamicIntArray {
    private int[] data;
    private int size;

    public DynamicIntArray() {
        this(10);
    }

    public DynamicIntArray(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initialCapacity: " + initialCapacity);
        }
        this.data = new int[initialCapacity];
        this.size = 0;
    }

    public DynamicIntArray(int[] intArray) {
        this.size = intArray.length;
        int capacity = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.data = new int[capacity];
        System.arraycopy(intArray, 0, this.data, 0, this.size);
    }

    public void add(int value) {
        this.ensureCapacity(this.size + 1);
        this.data[this.size++] = value;
    }

    public void add(int index, int[] intArray) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Index " + index + ", not in range [0-" + this.size + "]");
        }
        int addCount = intArray.length;
        int moveCount = this.size - index;
        if (moveCount > 0) {
            System.arraycopy(this.data, index, this.data, index + addCount, moveCount);
        }
        System.arraycopy(this.data, index, intArray, 0, moveCount);
        this.size += addCount;
    }

    public void add(int index, int value) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Index " + index + ", not in range [0-" + this.size + "]");
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, index, this.data, index + 1, this.size - index);
        this.data[index] = value;
        ++this.size;
    }

    public void clear() {
        this.size = 0;
    }

    public boolean contains(int integer) {
        int i = 0;
        while (i < this.size) {
            if (this.data[i] == integer) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void ensureCapacity(int minCapacity) {
        int oldCapacity = this.data.length;
        if (minCapacity > oldCapacity) {
            int[] oldData = this.data;
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.data = new int[newCapacity];
            System.arraycopy(oldData, 0, this.data, 0, this.size);
        }
    }

    public int get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " not in valid range [" + 0 + "-" + (this.size - 1) + "]");
        }
        return this.data[index];
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void remove(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " not in valid range [0-" + (this.size - 1) + "]");
        }
        int toMove = this.size - index - 1;
        if (toMove > 0) {
            System.arraycopy(this.data, index + 1, this.data, index, toMove);
        }
        --this.size;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex >= this.size || toIndex > this.size) {
            throw new IndexOutOfBoundsException("Index range [" + fromIndex + ", " + toIndex + "] not in valid range [0-" + (this.size - 1) + "]");
        }
        int moveCount = this.size - toIndex;
        System.arraycopy(this.data, toIndex, this.data, fromIndex, moveCount);
        this.size -= toIndex - fromIndex;
    }

    public void set(int index, int value) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " not in valid range [0-" + (this.size - 1) + "]");
        }
        this.data[index] = value;
    }
}

